DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.15631605696904E-11   0.00000000000000E+00   2.32935006056494E-14   1.55833076898289E-22
      1.15632411109180E-08   1.15632644044187E-08  -7.94489340947218E-19  -2.48476022246873E-01  -2.48476022246883E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07050854637749E-11   0.00000000000000E+00   1.07050854637749E-11
      3.70608115921207E-18  -2.48476022240008E-01  -2.44829628791045E-01   0.00000000000000E+00  -1.83871885671348E-14
     -9.78222835557590E-23  -1.15739511026938E-08  -1.15739694898825E-08  -2.91159181826485E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.11043042626016E-11   0.00000000000000E+00   3.63543621300070E-14   1.50752446632020E-22
      1.11043320396885E-08   1.11043683940507E-08  -7.98263410061133E-19  -2.46740124908482E-01  -2.46740124908493E-01
      0.00000000000000E+00   0.00000000000000E+00   1.12985078151618E-11   0.00000000000000E+00   1.12985078151618E-11
      3.71370765198731E-18  -2.46740124895124E-01  -2.43238121060900E-01   0.00000000000000E+00  -2.43606269777474E-14
     -9.82231912492244E-23  -1.11156425412388E-08  -1.11156669018659E-08  -2.91544424192617E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.06571122371382E-11   0.00000000000000E+00   9.36578236892059E-14   1.47960563532813E-22
      1.06570650652102E-08   1.06571587230340E-08  -8.02239875781485E-19  -2.44821708440034E-01  -2.44821708440045E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10187082481566E-11   0.00000000000000E+00   1.10187082481566E-11
      3.72374844987844E-18  -2.44821708421277E-01  -2.41460702141393E-01   0.00000000000000E+00  -7.80739808943436E-14
     -9.78094752274043E-23  -1.06680993573012E-08  -1.06681774312822E-08  -2.92150857409695E-18
      2.39379687500000E-09
      0.00000000000000E+00  -1.05237536787128E-11   0.00000000000000E+00  -2.08155182165670E-14   1.47066295618671E-22
      1.05238073231882E-08   1.05237865076701E-08  -8.03472067080889E-19  -2.44217084410566E-01  -2.44217084410577E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08367972890573E-11   0.00000000000000E+00   1.08367972890573E-11
      3.72708127301970E-18  -2.44217084596507E-01  -2.40898117956473E-01   0.00000000000000E+00   3.74293179930073E-14
     -9.76683628603813E-23  -1.05346607342771E-08  -1.05346233049592E-08  -2.92360920593881E-18
      2.80898515625000E-09
      0.00000000000000E+00  -1.03666991780880E-11   0.00000000000000E+00  -1.65286635334011E-14   1.46214916450087E-22
      1.03667304868168E-08   1.03667139581534E-08  -8.04967746049775E-19  -2.43469162883555E-01  -2.43469162883566E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05054501398306E-11   0.00000000000000E+00   1.05054501398306E-11
      3.73144301280701E-18  -2.43469163048261E-01  -2.40199787270550E-01   0.00000000000000E+00   3.36557619697695E-14
     -9.75741729263550E-23  -1.03772530640551E-08  -1.03772194082932E-08  -2.92647526675723E-18
      3.36948933593750E-09
      0.00000000000000E+00  -1.01869590273728E-11   0.00000000000000E+00  -1.13686639297825E-14   1.45701071555923E-22
      1.01870161454959E-08   1.01870047768321E-08  -8.06738956482901E-19  -2.42565264237310E-01  -2.42565264237320E-01
      0.00000000000000E+00   0.00000000000000E+00   9.96001693521088E-12   0.00000000000000E+00   9.96001693521088E-12
      3.73702564392895E-18  -2.42565264377326E-01  -2.39352678816272E-01   0.00000000000000E+00   2.85692099893866E-14
     -9.78837144990895E-23  -1.01969933629772E-08  -1.01969647937673E-08  -2.93028668744605E-18
      4.12616997851563E-09
      0.00000000000000E+00  -9.98802332658133E-12   0.00000000000000E+00  -4.67335307735360E-15   1.45242731395335E-22
      9.98800741452046E-09   9.98800274116752E-09  -8.08777130327943E-19  -2.41503618207957E-01  -2.41503618207966E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15765409993483E-12   0.00000000000000E+00   9.15765409993483E-12
      3.74395506351780E-18  -2.41503618322554E-01  -2.38353982605379E-01   0.00000000000000E+00   2.13118056373628E-14
     -9.77700985599427E-23  -9.99718170707300E-09  -9.99716039526746E-09  -2.93517793318986E-18
      5.14768884599610E-09
      0.00000000000000E+00  -9.77549460468311E-12   0.00000000000000E+00   3.82895083493812E-15   1.45410904121170E-22
      9.77547749276615E-09   9.77548132171713E-09  -8.11044408200147E-19  -2.40299793873178E-01  -2.40299793873186E-01
      0.00000000000000E+00   0.00000000000000E+00   8.08560744093397E-12   0.00000000000000E+00   8.08560744093397E-12
      3.75221466407376E-18  -2.40299793962305E-01  -2.37217452913714E-01   0.00000000000000E+00   1.14857347805056E-14
     -9.78384234114709E-23  -9.78357841489275E-09  -9.78356692915806E-09  -2.94117025587361E-18
      6.52673931709473E-09
      0.00000000000000E+00  -9.55763888802686E-12   0.00000000000000E+00   1.42076366502569E-14   1.45789080591183E-22
      9.55764319239793E-09   9.55765740003473E-09  -8.13465121149115E-19  -2.38993052669670E-01  -2.38993052669676E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77948200883953E-12   0.00000000000000E+00   6.77948200883953E-12
      3.76156391193185E-18  -2.38993052731921E-01  -2.35979751279005E-01   0.00000000000000E+00  -9.70675383125213E-16
     -9.64336106546443E-23  -9.56443591136810E-09  -9.56443688204358E-09  -2.94809879078273E-18
      8.38845745307788E-09
      0.00000000000000E+00  -9.34492647665422E-12   0.00000000000000E+00   2.61581117336076E-14   1.46748146602116E-22
      9.34495039179873E-09   9.34497654991061E-09  -8.15920855970220E-19  -2.37649927213443E-01  -2.37649927213449E-01
      0.00000000000000E+00   0.00000000000000E+00   5.33099885178964E-12   0.00000000000000E+00   5.33099885178964E-12
      3.77148872917713E-18  -2.37649927241536E-01  -2.34704090466287E-01   0.00000000000000E+00  -1.55701509148618E-14
     -9.76264949015204E-23  -9.35029197861138E-09  -9.35030754876239E-09  -2.95556787320691E-18
      1.03884574530779E-08
      0.00000000000000E+00  -9.17905488125743E-12   0.00000000000000E+00   1.52990330547670E-14   1.47533052822857E-22
      9.17907872628670E-09   9.17909402531991E-09  -8.17895629407488E-19  -2.36560566633846E-01  -2.36560566633850E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10763884803636E-12   0.00000000000000E+00   4.10763884803636E-12
      3.77970400687321E-18  -2.36560566618054E-01  -2.33667372759746E-01   0.00000000000000E+00  -7.04071713772988E-15
     -9.75845719542129E-23  -9.18319462345070E-09  -9.18320166416794E-09  -2.96180837746572E-18
      1.23884574530779E-08
      0.00000000000000E+00  -9.05653400182259E-12   0.00000000000000E+00   6.59168675592968E-15   1.48349700993536E-22
      9.05646964805556E-09   9.05647623974246E-09  -8.19387921129482E-19  -2.35732973973085E-01  -2.35732973973088E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15885025249138E-12   0.00000000000000E+00   3.15885025249138E-12
      3.78602170737819E-18  -2.35732973902523E-01  -2.32878706695334E-01   0.00000000000000E+00  -1.93927664869770E-16
     -9.75335868663188E-23  -9.05963489606719E-09  -9.05963508999495E-09  -2.96663378624871E-18
      1.43884574530779E-08
      0.00000000000000E+00  -8.96468926461506E-12   0.00000000000000E+00   2.78812083200609E-15   1.48888192510221E-22
      8.96468365006865E-09   8.96468643818963E-09  -8.20522670469092E-19  -2.35101579698070E-01  -2.35101579698072E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42746847290122E-12   0.00000000000000E+00   2.42746847290122E-12
      3.79087664432399E-18  -2.35101579558787E-01  -2.32276459770482E-01   0.00000000000000E+00   2.14232386775211E-15
     -9.52763459233103E-23  -8.96711604898630E-09  -8.96711390666253E-09  -2.97035397385490E-18
      1.63884574530779E-08
      0.00000000000000E+00  -8.89534648802338E-12   0.00000000000000E+00   3.60479170115280E-14   1.49340454748814E-22
      8.89536583146305E-09   8.89540187938021E-09  -8.21389087349084E-19  -2.34618481749223E-01  -2.34618481749225E-01
      0.00000000000000E+00   0.00000000000000E+00   1.86521019541561E-12   0.00000000000000E+00   1.86521019541561E-12
      3.79460706471482E-18  -2.34618481528343E-01  -2.31815377298742E-01   0.00000000000000E+00  -3.24414363086954E-14
     -9.65624230104183E-23  -8.89723464813922E-09  -8.89726708957562E-09  -2.97321797736574E-18
      1.83884574530779E-08
      0.00000000000000E+00  -8.84271945360347E-12   0.00000000000000E+00   3.01064842140927E-15   1.49805646581292E-22
      8.84273568140896E-09   8.84273869205753E-09  -8.22052589982174E-19  -2.34248052045820E-01  -2.34248052045822E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43350861662282E-12   0.00000000000000E+00   1.43350861662282E-12
      3.79747408194807E-18  -2.34248051732464E-01  -2.31461664568612E-01   0.00000000000000E+00  -1.16970067729685E-16
     -9.73089885682738E-23  -8.84417208370399E-09  -8.84417220067415E-09  -2.97542149196589E-18
      2.03884574530779E-08
      0.00000000000000E+00  -8.80258330344378E-12   0.00000000000000E+00   2.48806389240518E-14   1.50103123487240E-22
      8.80257409269052E-09   8.80259897332960E-09  -8.22561598620266E-19  -2.33963633175169E-01  -2.33963633175170E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10206405830201E-12   0.00000000000000E+00   1.10206405830201E-12
      3.79967821006467E-18  -2.33963632763411E-01  -2.31190002840753E-01   0.00000000000000E+00  -2.27880914799295E-14
     -9.70793285616655E-23  -8.80367824929631E-09  -8.80370103738789E-09  -2.97711661144441E-18
      2.23884574530779E-08
      0.00000000000000E+00  -8.77181531647926E-12   0.00000000000000E+00   6.49331678977747E-16   1.50362444132863E-22
      8.77186734917974E-09   8.77186799851157E-09  -8.22952679808666E-19  -2.33745000104381E-01  -2.33745000104382E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47590029307014E-13   0.00000000000000E+00   8.47590029307014E-13
      3.80137339012328E-18  -2.33744999597272E-01  -2.30981123972156E-01   0.00000000000000E+00   1.05833268237674E-15
     -9.70396745695065E-23  -8.77271664687346E-09  -8.77271558854087E-09  -2.97842071031462E-18
      2.43884574530779E-08
      0.00000000000000E+00  -8.74839490849134E-12   0.00000000000000E+00   7.95277350195617E-15   1.50468571711556E-22
      8.74831827838441E-09   8.74832623115806E-09  -8.23253390634439E-19  -2.33576828208247E-01  -2.33576828208247E-01
      0.00000000000000E+00   0.00000000000000E+00   6.52094046387066E-13   0.00000000000000E+00   6.52094046387066E-13
      3.80267757821606E-18  -2.33576827619614E-01  -2.30820432674539E-01   0.00000000000000E+00  -6.68526671436396E-15
     -9.72756811681130E-23  -8.74897163993763E-09  -8.74897832520444E-09  -2.97942418758162E-18
      2.63884574530779E-08
      0.00000000000000E+00  -8.73020965052425E-12   0.00000000000000E+00   3.10839335267662E-17   1.50608238279546E-22
      8.73024486291352E-09   8.73024489399760E-09  -8.23484791338375E-19  -2.33447391615155E-01  -2.33447391615155E-01
      0.00000000000000E+00   0.00000000000000E+00   5.01857649310349E-13   0.00000000000000E+00   5.01857649310349E-13
      3.80368129351468E-18  -2.33447390973392E-01  -2.30696737365979E-01   0.00000000000000E+00   9.76814378168977E-16
     -9.71712468996497E-23  -8.73074772846118E-09  -8.73074675164690E-09  -2.98019650217630E-18
      2.83884574530779E-08
      0.00000000000000E+00  -8.71634109520591E-12   0.00000000000000E+00   2.57244708785095E-15   1.50702428757487E-22
      8.71635154330539E-09   8.71635411575262E-09  -8.23662926452310E-19  -2.33347734536394E-01  -2.33347734536395E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86337519151380E-13   0.00000000000000E+00   3.86337519151380E-13
      3.80445396855298E-18  -2.33347733887168E-01  -2.30601493739882E-01   0.00000000000000E+00  -1.81294026783463E-15
     -9.70259598991846E-23  -8.71673864033141E-09  -8.71674045327178E-09  -2.98079104210067E-18
      3.03884574530779E-08
      0.00000000000000E+00  -8.70568710568984E-12   0.00000000000000E+00  -9.93567605376359E-17   1.50844157908513E-22
      8.70566760279204E-09   8.70566750343543E-09  -8.23800111995128E-19  -2.33270980212083E-01  -2.33270980212083E-01
      0.00000000000000E+00   0.00000000000000E+00   2.97481647257732E-13   0.00000000000000E+00   2.97481647257732E-13
      3.80504893184750E-18  -2.33270979620731E-01  -2.30528133427714E-01   0.00000000000000E+00   6.94975001319426E-16
     -9.72036266075743E-23  -8.70596568005759E-09  -8.70596498508269E-09  -2.98124881985237E-18
      3.23884574530779E-08
      0.00000000000000E+00  -8.69742107934116E-12   0.00000000000000E+00   8.08927780910881E-16   1.50879470897958E-22
      8.69744443805645E-09   8.69744524698438E-09  -8.23905782362186E-19  -2.33211854514356E-01  -2.33211854514357E-01
      0.00000000000000E+00   0.00000000000000E+00   2.29106066449355E-13   0.00000000000000E+00   2.29106066449355E-13
      3.80550714398040E-18  -2.33211854067219E-01  -2.30471620110036E-01   0.00000000000000E+00  -3.56059516077299E-16
     -9.71706320131917E-23  -8.69767399699122E-09  -8.69767435305083E-09  -2.98160136161821E-18
      3.43884574530779E-08
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00  -9.94206334765629E-17   1.50973087199858E-22
      8.69111413646644E-09   8.69111403704596E-09  -8.23987194875682E-19  -2.33166300301605E-01  -2.33166300301605E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76476323570150E-13   0.00000000000000E+00   1.76476323570150E-13
      3.80586009662754E-18  -2.33166300105697E-01  -2.30428077081647E-01   0.00000000000000E+00   4.51878299204747E-16
     -9.72897551388980E-23  -8.69129096524774E-09  -8.69129051336953E-09  -2.98187290175185E-18
      3.63884574530779E-08
      0.00000000000000E+00  -8.68621602140184E-12   0.00000000000000E+00   2.33337635788644E-16   1.50939616148488E-22
      8.68623859918377E-09   8.68623883252156E-09  -8.24049924659332E-19  -2.33131198982228E-01  -2.33131198982228E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35954306129484E-13   0.00000000000000E+00   1.35954306129484E-13
      3.80613200523980E-18  -2.33131199162495E-01  -2.30394524934933E-01   0.00000000000000E+00   3.60875777081932E-17
     -9.66434128004409E-23  -8.68637482291518E-09  -8.68637478682770E-09  -2.98208208058046E-18
      3.83884574530779E-08
      0.00000000000000E+00  -8.68245038717633E-12   0.00000000000000E+00   3.31070302720180E-16   1.51074314474724E-22
      8.68248306553709E-09   8.68248339660755E-09  -8.24098264229927E-19  -2.33104149508957E-01  -2.33104149508957E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04748771896764E-13   0.00000000000000E+00   1.04748771896764E-13
      3.80634150278359E-18  -2.33104150201483E-01  -2.30368668980373E-01   0.00000000000000E+00  -1.26581431656476E-16
     -9.73832237414284E-23  -8.68258801879792E-09  -8.68258814537945E-09  -2.98224323855366E-18
      4.03884574530779E-08
      0.00000000000000E+00  -8.67960320032290E-12   0.00000000000000E+00   5.24328154894452E-17   1.51025161109373E-22
      8.67958977971176E-09   8.67958983214473E-09  -8.24135517639045E-19  -2.33083303341208E-01  -2.33083303341208E-01
      0.00000000000000E+00   0.00000000000000E+00   8.07125920870523E-14   0.00000000000000E+00   8.07125920870523E-14
      3.80650292796776E-18  -2.33083304688007E-01  -2.30348742564835E-01   0.00000000000000E+00   1.06930463408897E-16
     -9.70099751820233E-23  -8.67967065166719E-09  -8.67967054473682E-09  -2.98236741032872E-18
      4.23884574530779E-08
      0.00000000000000E+00  -8.67739892662992E-12   0.00000000000000E+00   9.39506409432744E-17   1.51093629264780E-22
      8.67736031812405E-09   8.67736041207484E-09  -8.24164228700254E-19  -2.33067237231479E-01  -2.33067237231479E-01
      0.00000000000000E+00   0.00000000000000E+00   6.21966234280385E-14   0.00000000000000E+00   6.21966234280385E-14
      3.80662732121462E-18  -2.33067239363928E-01  -2.30333385462417E-01   0.00000000000000E+00   2.83444565528815E-17
     -9.73451799414748E-23  -8.67742263704262E-09  -8.67742260869827E-09  -2.98246309251436E-18
      4.43884574530779E-08
      0.00000000000000E+00  -8.67556203188577E-12   0.00000000000000E+00   8.67084531644820E-16   1.51112598978015E-22
      8.67564209407716E-09   8.67564296116184E-09  -8.24186356008152E-19  -2.33054855057802E-01  -2.33054855057803E-01
      0.00000000000000E+00   0.00000000000000E+00   4.79313136707303E-14   0.00000000000000E+00   4.79313136707303E-14
      3.80672318384196E-18  -2.33054858076337E-01  -2.30321549992881E-01   0.00000000000000E+00  -7.81418103892069E-16
     -9.73565345853630E-23  -8.67569011105732E-09  -8.67569089247552E-09  -2.98253682783381E-18
      4.63884574530779E-08
      0.00000000000000E+00  -8.67427620556486E-12   0.00000000000000E+00   1.93908622778428E-17   1.51204150493096E-22
      8.67431842694174E-09   8.67431844633275E-09  -8.24203411631330E-19  -2.33045311022583E-01  -2.33045311022583E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69390466048509E-14   0.00000000000000E+00   3.69390466048509E-14
      3.80679706193517E-18  -2.33045314980538E-01  -2.30312427380010E-01   0.00000000000000E+00   5.18758800392032E-17
     -9.73059123466843E-23  -8.67435543725514E-09  -8.67435538537936E-09  -2.98259365030384E-18
      4.83884574530779E-08
      0.00000000000000E+00  -8.67326591345558E-12   0.00000000000000E+00   2.95457765935895E-16   1.51138737592094E-22
      8.67329793400436E-09   8.67329822946227E-09  -8.24216557063901E-19  -2.33037955072992E-01  -2.33037955072992E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84688519614161E-14   0.00000000000000E+00   2.84688519614161E-14
      3.80685399963909E-18  -2.33037959947286E-01  -2.30305396519475E-01   0.00000000000000E+00  -2.42280655594595E-16
     -9.73269324162495E-23  -8.67332645603349E-09  -8.67332669831424E-09  -2.98263744257519E-18
      5.03884574530779E-08
      0.00000000000000E+00  -8.67253115555792E-12   0.00000000000000E+00  -1.12927356023036E-18   1.51174588783888E-22
      8.67251162379933E-09   8.67251162267021E-09  -8.24226689286973E-19  -2.33032285251958E-01  -2.33032285251958E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19413240807149E-14   0.00000000000000E+00   2.19413240807149E-14
      3.80689788228725E-18  -2.33032290911618E-01  -2.30299977266303E-01   0.00000000000000E+00   4.39558934815220E-17
     -9.72973592687870E-23  -8.67253360795010E-09  -8.67253356399430E-09  -2.98267119300028E-18
      5.23884574530779E-08
      0.00000000000000E+00  -8.67188824239747E-12   0.00000000000000E+00   9.80772717243858E-17   1.51166928166946E-22
      8.67190549330822E-09   8.67190559138564E-09  -8.24234498471864E-19  -2.33027915334991E-01  -2.33027915334991E-01
      0.00000000000000E+00   0.00000000000000E+00   1.69104658178130E-14   0.00000000000000E+00   1.69104658178130E-14
      3.80693170321889E-18  -2.33027921513639E-01  -2.30295800413578E-01   0.00000000000000E+00  -6.56830586957575E-17
     -9.73423336439186E-23  -8.67192243616830E-09  -8.67192250185146E-09  -2.98269720474703E-18
      5.43884574530779E-08
      0.00000000000000E+00  -8.67142901871143E-12   0.00000000000000E+00  -5.12274686645732E-18   1.51078308627224E-22
      8.67143843344910E-09   8.67143842832651E-09  -8.24240517151994E-19  -2.33024547326038E-01  -2.33024547326038E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30327097427095E-14   0.00000000000000E+00   1.30327097427095E-14
      3.80695776863838E-18  -2.33024553593710E-01  -2.30292580861886E-01   0.00000000000000E+00   3.07394000594605E-17
     -9.70148577739706E-23  -8.67145149177555E-09  -8.67145146103624E-09  -2.98271725148638E-18
      5.63884574530779E-08
      0.00000000000000E+00  -8.67106163976260E-12   0.00000000000000E+00   3.09901148325924E-17   1.51044460112020E-22
      8.67107846838791E-09   8.67107849937818E-09  -8.24245155345705E-19  -2.33021951784085E-01  -2.33021951784085E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00434333278666E-14   0.00000000000000E+00   1.00434333278666E-14
      3.80697785550503E-18  -2.33021957522792E-01  -2.30290099139105E-01   0.00000000000000E+00  -1.14562649568377E-17
     -9.76443853122344E-23  -8.67108853135514E-09  -8.67108854281151E-09  -2.98273270015932E-18
      5.83884574530779E-08
      0.00000000000000E+00  -8.67078610555098E-12   0.00000000000000E+00  -4.61175969732067E-18   1.50473535452315E-22
      8.67080113429792E-09   8.67080112968631E-09  -8.24248729271782E-19  -2.33019951761325E-01  -2.33019951761325E-01
      0.00000000000000E+00   0.00000000000000E+00   7.73874772880882E-15   0.00000000000000E+00   7.73874772880882E-15
      3.80699333300049E-18  -2.33019956151971E-01  -2.30288185868072E-01   0.00000000000000E+00   1.99030034577014E-17
     -9.81849234684245E-23  -8.67080888833693E-09  -8.67080886843403E-09  -2.98274460372871E-18
      6.03884574530779E-08
      0.00000000000000E+00  -8.67060241607656E-12   0.00000000000000E+00   8.79622635017523E-18   1.49901552150657E-22
      8.67058747075088E-09   8.67058747954726E-09  -8.24251482521900E-19  -2.33018410951934E-01  -2.33018410951934E-01
      0.00000000000000E+00   0.00000000000000E+00   5.96160700447415E-15   0.00000000000000E+00   5.96160700447415E-15
      3.80700525621450E-18  -2.33018412976150E-01  -2.30286710566479E-01   0.00000000000000E+00   2.93215470066266E-18
     -1.00181869694610E-22  -8.67059344408632E-09  -8.67059344115427E-09  -2.98275377369260E-18
      6.23884574530779E-08
      0.00000000000000E+00  -8.67041872660215E-12   0.00000000000000E+00  -3.28561666296741E-18   1.45159155666858E-22
      8.67042292444317E-09   8.67042292115770E-09  -8.24253602952236E-19  -2.33017224242411E-01  -2.33017224242411E-01
      0.00000000000000E+00   0.00000000000000E+00   4.59103869770512E-15   0.00000000000000E+00   4.59103869770512E-15
      3.80701443829189E-18  -2.33017222707431E-01  -2.30285572569621E-01   0.00000000000000E+00   1.24230973342924E-17
     -9.62613537640737E-23  -8.67042752461941E-09  -8.67042751219641E-09  -2.98276083533966E-18
      6.43884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.83303538573020E-18   1.39633273999644E-22
      8.67029623495657E-09   8.67029623678974E-09  -8.24255235377935E-19  -2.33016310607929E-01  -2.33016310607929E-01
      0.00000000000000E+00   0.00000000000000E+00   3.53390768293391E-15   0.00000000000000E+00   3.53390768293391E-15
      3.80702150610726E-18  -2.33016304197487E-01  -2.30284694306039E-01   0.00000000000000E+00   5.20351664383096E-18
     -9.50280683380152E-23  -8.67029977590085E-09  -8.67029977069743E-09  -2.98276627072933E-18
      6.63884574530779E-08
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00  -2.13762654849282E-18   5.11513665546267E-22
      8.67019873564678E-09   8.67019873350966E-09  -8.24256491561229E-19  -2.33015607523238E-01  -2.33015607523238E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71854073563403E-15   0.00000000000000E+00   2.71854073563403E-15
      3.80702694318873E-18  -2.33015594884587E-01  -2.30284015967022E-01   0.00000000000000E+00   7.62030039770176E-18
     -1.06727375794474E-22  -8.67020145967059E-09  -8.67020145205039E-09  -2.98277045162750E-18
      6.83884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.08365447394271E-19   5.78805361799505E-23
      8.67012371835913E-09   8.67012371825082E-09  -8.24257457812795E-19  -2.33015066713617E-01  -2.33015066713617E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08985562669329E-15   0.00000000000000E+00   2.08985562669329E-15
      3.80703112289998E-18  -2.33015046583898E-01  -2.30283491498478E-01   0.00000000000000E+00   4.33372175432274E-18
     -9.09019751627387E-23  -8.67012581244008E-09  -8.67012580810645E-09  -2.98277366508719E-18
      7.03884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.34055628078659E-18   8.68070967869402E-23
      8.67006600160995E-09   8.67006600026948E-09  -8.24258200903218E-19  -2.33014650839909E-01  -2.33014650839909E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60551857462121E-15   0.00000000000000E+00   1.60551857462121E-15
      3.80703433393713E-18  -2.33014622215250E-01  -2.30283085465982E-01   0.00000000000000E+00   4.64671652923625E-18
     -1.09288552866082E-22  -8.67006761043467E-09  -8.67006760578806E-09  -2.98277613303392E-18
      7.23884574530779E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -4.86859017862072E-19   8.25079307097470E-23
      8.67002156304630E-09   8.67002156255952E-09  -8.24258772603243E-19  -2.33014330962192E-01  -2.33014330962192E-01
      0.00000000000000E+00   0.00000000000000E+00   1.23312735307490E-15   0.00000000000000E+00   1.23312735307490E-15
      3.80703680019184E-18  -2.33014293309585E-01  -2.30282770677933E-01   0.00000000000000E+00   3.05275339325330E-18
     -2.26658462631169E-22  -8.67002279873940E-09  -8.67002279568688E-09  -2.98277802758860E-18
      7.43884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -8.21366674109841E-19   1.65393042503857E-22
      8.66998727674833E-09   8.66998727592713E-09  -8.24259213190749E-19  -2.33014084575369E-01  -2.33014084575369E-01
      0.00000000000000E+00   0.00000000000000E+00   9.47844894388278E-16   0.00000000000000E+00   9.47844894388278E-16
      3.80703869588163E-18  -2.33014038084030E-01  -2.30282526344097E-01   0.00000000000000E+00   2.82032173452234E-18
     -2.25737392328942E-23  -8.66998822659232E-09  -8.66998822377202E-09  -2.98277948269088E-18
      7.63884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -4.52884283819182E-19   1.41518573407357E-22
      8.66996070039529E-09   8.66996069994255E-09  -8.24259554131555E-19  -2.33013894107024E-01  -2.33013894107024E-01
      0.00000000000000E+00   0.00000000000000E+00   7.30712789524628E-16   0.00000000000000E+00   7.30712789524628E-16
      3.80704015730720E-18  -2.33013839968467E-01  -2.30282336669776E-01   0.00000000000000E+00   2.00448553334924E-18
     -2.55040232927165E-23  -8.66996143265979E-09  -8.66996143065534E-09  -2.98278060317565E-18
      7.83884574530779E-08
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00  -5.06151663037205E-19   1.28433984821401E-22
      8.66993992074370E-09   8.66993992023768E-09  -8.24259820124854E-19  -2.33013745768008E-01  -2.33013745768008E-01
      0.00000000000000E+00   0.00000000000000E+00   5.67246845897995E-16   0.00000000000000E+00   5.67246845897995E-16
      3.80704129180090E-18  -2.33013686466924E-01  -2.30282189766328E-01   0.00000000000000E+00   1.70252244254762E-18
     -4.44880895844987E-25  -8.66994048918703E-09  -8.66994048748451E-09  -2.98278147167605E-18
      8.03884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.45062007874055E-19   1.37539617950029E-22
      8.66992343238415E-09   8.66992343203923E-09  -8.24260030646546E-19  -2.33013628685980E-01  -2.33013628685980E-01
      0.00000000000000E+00   0.00000000000000E+00   4.46339518769806E-16   0.00000000000000E+00   4.46339518769806E-16
      3.80704218447994E-18  -2.33013568277076E-01  -2.30282076809211E-01   0.00000000000000E+00   1.23288762908970E-18
     -6.15310636046106E-24  -8.66992387961163E-09  -8.66992387837875E-09  -2.98278215383339E-18
      8.23884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.29878811339412E-19   1.62251372423890E-22
      8.66991005128714E-09   8.66991005095742E-09  -8.24260201087725E-19  -2.33013534262584E-01  -2.33013534262584E-01
      0.00000000000000E+00   0.00000000000000E+00   3.59395478075405E-16   0.00000000000000E+00   3.59395478075405E-16
      3.80704290327089E-18  -2.33013478598359E-01  -2.30281991373591E-01   0.00000000000000E+00   9.62274858090169E-19
      1.96212004855153E-23  -8.66991041131519E-09  -8.66991041035290E-09  -2.98278270218317E-18
      8.43884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.59292126992134E-19  -3.37226347989325E-22
      8.66989885147510E-09   8.66989885121547E-09  -8.24260343570599E-19  -2.33013455711883E-01  -2.33013455711883E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99622048943381E-16   0.00000000000000E+00   2.99622048943381E-16
      3.80704350251499E-18  -2.33013412577025E-01  -2.30281928899594E-01   0.00000000000000E+00   6.51882551096292E-19
      8.66878243955994E-24  -8.66989915148942E-09  -8.66989915083752E-09  -2.98278315894439E-18
      8.63884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.52925806571125E-18   1.39953675223080E-22
      8.66988912350837E-09   8.66988912197926E-09  -8.24260467490604E-19  -2.33013387745460E-01  -2.33013387745460E-01
      0.00000000000000E+00   0.00000000000000E+00   2.61408894381572E-16   0.00000000000000E+00   2.61408894381572E-16
      3.80704402533278E-18  -2.33013366844861E-01  -2.30281886244279E-01   0.00000000000000E+00   1.68745446419916E-18
     -1.64782156904509E-23  -8.66988938507557E-09  -8.66988938338814E-09  -2.98278355784217E-18
      8.83884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   9.78184112083769E-20   1.36849975515559E-22
      8.66988034483399E-09   8.66988034493195E-09  -8.24260579857380E-19  -2.33013326377965E-01  -2.33013326377965E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39956398487195E-16   0.00000000000000E+00   2.39956398487195E-16
      3.80704450524558E-18  -2.33013339124637E-01  -2.30281861296558E-01   0.00000000000000E+00  -1.47311023183868E-19
     -1.98051695579243E-23  -8.66988058474101E-09  -8.66988058488834E-09  -2.98278392538819E-18
      8.93884574530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -3.29722992459051E-18   1.52031028652759E-22
      8.66987623007123E-09   8.66987622677415E-09  -8.24260633899143E-19  -2.33013296922523E-01  -2.33013296922523E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32539902698990E-16   0.00000000000000E+00   2.32539902698990E-16
      3.80704473778548E-18  -2.33013329450397E-01  -2.30281852920951E-01   0.00000000000000E+00   3.25860439931809E-18
     -9.75247518416417E-23  -8.66987646257255E-09  -8.66987645931405E-09  -2.98278410388634E-18
      8.95572074530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.87295632814642E-19   1.51226415324469E-22
      8.66987544624504E-09   8.66987544595789E-09  -8.24260642913689E-19  -2.33013291985449E-01  -2.33013291985449E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34393977241657E-16   0.00000000000000E+00   2.34393977241657E-16
      3.80704477733946E-18  -2.33013327952016E-01  -2.30281851670301E-01   0.00000000000000E+00  -3.94096124622946E-18
     -1.01563232711981E-22  -8.66987567641079E-09  -8.66987568035185E-09  -2.98278413442578E-18
      8.97850199530779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.06469160777955E-19   1.50387722288451E-22
      8.66987450263774E-09   8.66987450243142E-09  -8.24260655050684E-19  -2.33013285375319E-01  -2.33013285375319E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30236106554882E-16   0.00000000000000E+00   2.30236106554882E-16
      3.80704482979013E-18  -2.33013326146390E-01  -2.30281850161981E-01   0.00000000000000E+00   2.55436889905284E-20
     -9.75151602530183E-23  -8.66987473269299E-09  -8.66987473266754E-09  -2.98278417473944E-18
      9.00925668280779E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -2.04289159540989E-19   1.13519514002600E-22
      8.66987324401586E-09   8.66987324381168E-09  -8.24260671276427E-19  -2.33013276542209E-01  -2.33013276542209E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28793023318734E-16   0.00000000000000E+00   2.28793023318734E-16
      3.80704490015470E-18  -2.33013324099460E-01  -2.30281848512039E-01   0.00000000000000E+00  -7.41054111760728E-21
     -9.58206479927181E-23  -8.66987347259721E-09  -8.66987347260471E-09  -2.98278422887828E-18
      9.05077551093279E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.97959474741374E-19   1.45872658039727E-22
      8.66987156809459E-09   8.66987156789678E-09  -8.24260692931706E-19  -2.33013264758385E-01  -2.33013264758385E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27343590813207E-16   0.00000000000000E+00   2.27343590813207E-16
      3.80704499454510E-18  -2.33013322035406E-01  -2.30281846976448E-01   0.00000000000000E+00  -5.75871467697972E-20
     -9.64410396459829E-23  -8.66987179518270E-09  -8.66987179524038E-09  -2.98278430161339E-18
      9.10682592890154E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.57230270117506E-18   1.47904415869774E-22
      8.66986933876783E-09   8.66986934134028E-09  -8.24260721798307E-19  -2.33013249054627E-01  -2.33013249054627E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26266182442837E-16   0.00000000000000E+00   2.26266182442837E-16
      3.80704512136824E-18  -2.33013320497468E-01  -2.30281846141212E-01   0.00000000000000E+00  -2.88190128288635E-18
     -9.87812358056697E-23  -8.66986956472445E-09  -8.66986956760645E-09  -2.98278439956994E-18
      9.18249399315936E-08
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   1.88524118573010E-14   1.51473643814824E-22
      8.67000601837581E-09   8.67002487078782E-09  -8.24260819844288E-19  -2.33013227153100E-01  -2.33013227153100E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21945414074822E-15   0.00000000000000E+00  -1.21945414074822E-15
      3.80704419863090E-18  -2.33013217497582E-01  -2.30281700564687E-01   0.00000000000000E+00  -1.87740184733059E-14
     -1.02352492860057E-22  -8.67000487731512E-09  -8.67002365133369E-09  -2.98278337878661E-18
      9.23356993653338E-08
      0.00000000000000E+00  -8.66959212396728E-12   0.00000000000000E+00  -2.16368280330624E-13   1.47286988952350E-22
      8.66961976803488E-09   8.66940339975469E-09  -8.24260797870696E-19  -2.33013214201041E-01  -2.33013214201041E-01
      0.00000000000000E+00   0.00000000000000E+00   2.59861499634795E-15   0.00000000000000E+00   2.59861499634795E-15
      3.80704552589802E-18  -2.33013341486320E-01  -2.30281944891045E-01   0.00000000000000E+00   2.16102212845743E-13
     -1.00040969213631E-22  -8.66962210058244E-09  -8.66940599836969E-09  -2.98278472802733E-18
      9.30252246008831E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -7.02093429586720E-17   1.51049231863379E-22
      8.66985726806273E-09   8.66985719785354E-09  -8.24260858866812E-19  -2.33013195143639E-01  -2.33013195143639E-01
      0.00000000000000E+00   0.00000000000000E+00   1.44939834125902E-16   0.00000000000000E+00   1.44939834125902E-16
      3.80704562583769E-18  -2.33013347662278E-01  -2.30281877129364E-01   0.00000000000000E+00   6.98961195762463E-17
     -9.82977873024532E-23  -8.66985741268939E-09  -8.66985734279337E-09  -2.98278476697088E-18
      9.39560836688747E-08
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -2.05224511749574E-17   1.49848293640590E-22
      8.66985567036642E-09   8.66985564984412E-09  -8.24260891836086E-19  -2.33013169559769E-01  -2.33013169559769E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65913719601371E-16   0.00000000000000E+00   2.65913719601371E-16
      3.80704587336589E-18  -2.33013357308482E-01  -2.30281887246388E-01   0.00000000000000E+00   1.79773308214208E-17
     -9.46831684408540E-23  -8.66985593373507E-09  -8.66985591575783E-09  -2.98278498152980E-18
      9.52127434106633E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.29816147485192E-19   1.07444713185823E-22
      8.66985239540876E-09   8.66985239527905E-09  -8.24260943733176E-19  -2.33013135149362E-01  -2.33013135149362E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45310802651358E-16   0.00000000000000E+00   2.45310802651358E-16
      3.80704618163810E-18  -2.33013374239456E-01  -2.30281905215396E-01   0.00000000000000E+00  -1.39865185066366E-18
     -1.49156864462422E-22  -8.66985263919106E-09  -8.66985264058986E-09  -2.98278523790493E-18
      9.69092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -8.02723274269543E-20   1.49070577056746E-22
      8.66984740190782E-09   8.66984740182770E-09  -8.24261018273024E-19  -2.33013089949970E-01  -2.33013089949970E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36289874230986E-16   0.00000000000000E+00   2.36289874230986E-16
      3.80704658250166E-18  -2.33013405003395E-01  -2.30281937555344E-01   0.00000000000000E+00  -9.92569925615629E-19
     -9.63404433916811E-23  -8.66984763712491E-09  -8.66984763811757E-09  -2.98278556422864E-18
      9.89092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -1.38923870773861E-19   1.53331013266677E-22
      8.66984190061004E-09   8.66984190047127E-09  -8.24261100531112E-19  -2.33013041486130E-01  -2.33013041486130E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25576667966893E-16   0.00000000000000E+00   2.25576667966893E-16
      3.80704703365500E-18  -2.33013451281575E-01  -2.30281985570149E-01   0.00000000000000E+00  -9.71088134903039E-19
     -9.73374503632729E-23  -8.66984212507675E-09  -8.66984212604794E-09  -2.98278593312389E-18
      9.94092340620780E-08
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -9.21599517578640E-14   1.27089543993701E-22
      8.66991169976486E-09   8.66981953981323E-09  -8.24261196954737E-19  -2.33013028956265E-01  -2.33013028956265E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46764969274718E-15   0.00000000000000E+00  -1.46764969274718E-15
      3.80704629983015E-18  -2.33013429022377E-01  -2.30281941807185E-01   0.00000000000000E+00   9.21302139074333E-14
     -1.05420383531855E-22  -8.66991020237734E-09  -8.66981807216354E-09  -2.98278510287541E-18
      1.00084234062078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.05228512879103E-18   3.33055098096922E-22
      8.66982994124451E-09   8.66982993519256E-09  -8.24261182672136E-19  -2.33013014114447E-01  -2.33013014114447E-01
      0.00000000000000E+00   0.00000000000000E+00   6.18769727937562E-16   0.00000000000000E+00   6.18769727937562E-16
      3.80704671749972E-18  -2.33013452424014E-01  -2.30281990358460E-01   0.00000000000000E+00   4.71452334623438E-18
     -9.97600399097676E-23  -8.66983055867671E-09  -8.66983055396228E-09  -2.98278553482758E-18
      1.00995484062078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -1.41407462787116E-20   2.06873495514146E-22
      8.66983043685030E-09   8.66983043683636E-09  -8.24261203173502E-19  -2.33012995673491E-01  -2.33012995673491E-01
      0.00000000000000E+00   0.00000000000000E+00   3.80870047501509E-16   0.00000000000000E+00   3.80870047501509E-16
      3.80704706456755E-18  -2.33013483468834E-01  -2.30282021320241E-01   0.00000000000000E+00  -8.57956678093052E-19
     -1.02208209957017E-22  -8.66983081684836E-09  -8.66983081770641E-09  -2.98278586139405E-18
      1.02225671562078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.09695028685608E-20   2.33676772265856E-22
      8.66983072681891E-09   8.66983072683011E-09  -8.24261227794120E-19  -2.33012975178932E-01  -2.33012975178932E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99990461468192E-16   0.00000000000000E+00   2.99990461468192E-16
      3.80704743361207E-18  -2.33013524587872E-01  -2.30282062373406E-01   0.00000000000000E+00  -8.72679001882967E-19
     -4.64472749143077E-23  -8.66983102594786E-09  -8.66983102682058E-09  -2.98278620581795E-18
      1.03886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.24019143585015E-20  -8.93565315862826E-23
      8.66983182771640E-09   8.66983182774872E-09  -8.24261243389891E-19  -2.33012959227019E-01  -2.33012959227019E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06439476725043E-16   0.00000000000000E+00   2.06439476725043E-16
      3.80704777645708E-18  -2.33013577526074E-01  -2.30282114994248E-01   0.00000000000000E+00  -7.88388668820430E-19
      1.66241502170611E-22  -8.66983203339997E-09  -8.66983203418819E-09  -2.98278653306718E-18
      1.05886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   1.84702067890057E-19   2.85117101167165E-23
      8.66983612097704E-09   8.66983612116177E-09  -8.24261218127184E-19  -2.33012964726841E-01  -2.33012964726841E-01
      0.00000000000000E+00   0.00000000000000E+00   8.57571251977932E-17   0.00000000000000E+00   8.57571251977932E-17
      3.80704794797133E-18  -2.33013631876563E-01  -2.30282168030153E-01   0.00000000000000E+00  -6.70350380367170E-19
      9.27811266161421E-25  -8.66983620624854E-09  -8.66983620691889E-09  -2.98278672984414E-18
      1.07886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00  -6.74200130873726E-18   1.59062626976720E-22
      8.66984500190894E-09   8.66984499516709E-09  -8.24261130952021E-19  -2.33013003562401E-01  -2.33013003562401E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.07341099876750E-17   0.00000000000000E+00  -6.07341099876750E-17
      3.80704782650310E-18  -2.33013668140911E-01  -2.30282201542646E-01   0.00000000000000E+00   6.75419980559176E-18
     -1.01579545322422E-22  -8.66984494118708E-09  -8.66984493443298E-09  -2.98278669555108E-18
      1.08886424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   2.83700093861726E-19   1.51159969412155E-22
      8.66985075882079E-09   8.66985075910465E-09  -8.24261069662111E-19  -2.33013032434429E-01  -2.33013032434429E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41972904816034E-16   0.00000000000000E+00  -1.41972904816034E-16
      3.80704768453020E-18  -2.33013680511551E-01  -2.30282212125205E-01   0.00000000000000E+00  -2.50195376864054E-19
     -9.73710500999345E-23  -8.66985061688145E-09  -8.66985061713174E-09  -2.98278661486809E-18
      1.10236424687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   3.88623626551323E-19   1.51145461210463E-22
      8.66986137696621E-09   8.66986137735498E-09  -8.24260949373151E-19  -2.33013091449448E-01  -2.33013091449448E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.69370464640177E-16   0.00000000000000E+00  -2.69370464640177E-16
      3.80704732088007E-18  -2.33013683113797E-01  -2.30282211422155E-01   0.00000000000000E+00   4.33485564758358E-19
     -9.73607589457453E-23  -8.66986110841790E-09  -8.66986110798451E-09  -2.98278637150692E-18
      1.12058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   5.61452734684345E-19   1.51145092229486E-22
      8.66988171875180E-09   8.66988171931340E-09  -8.24260706666461E-19  -2.33013214170890E-01  -2.33013214170890E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.75296479681304E-16   0.00000000000000E+00  -4.75296479681304E-16
      3.80704645465224E-18  -2.33013650790694E-01  -2.30282172755049E-01   0.00000000000000E+00   1.14991773301801E-18
     -9.73604255998119E-23  -8.66988124516674E-09  -8.66988124401692E-09  -2.98278574798578E-18
      1.14058924687078E-07
      0.00000000000000E+00  -8.66986765817890E-12   0.00000000000000E+00   7.63022379259420E-19   1.51144826108151E-22
      8.66991199418340E-09   8.66991199494658E-09  -8.24260331761403E-19  -2.33013407611888E-01  -2.33013407611888E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.39719624032301E-16   0.00000000000000E+00  -7.39719624032301E-16
      3.80704497521299E-18  -2.33013557623683E-01  -2.30282070132753E-01   0.00000000000000E+00   2.15792506672193E-18
     -9.73603816680182E-23  -8.66991125738478E-09  -8.66991125522695E-09  -2.98278464345159E-18
      1.16058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   9.64604825855182E-19   1.51144899549482E-22
      8.66995036322962E-09   8.66995036419437E-09  -8.24259842940513E-19  -2.33013663572262E-01  -2.33013663572262E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03303272414372E-15   0.00000000000000E+00  -1.03303272414372E-15
      3.80704290914754E-18  -2.33013392218574E-01  -2.30281892731467E-01   0.00000000000000E+00   3.36915716338972E-18
     -9.73603590310868E-23  -8.66994933453071E-09  -8.66994933116165E-09  -2.98278306620703E-18
      1.18058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   1.15022498151450E-18   1.51145224701290E-22
      8.66999616049950E-09   8.66999616164987E-09  -8.24259244504499E-19  -2.33013980907422E-01  -2.33013980907422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33780426420726E-15   0.00000000000000E+00  -1.33780426420726E-15
      3.80704023353901E-18  -2.33013141584623E-01  -2.30281627764587E-01   0.00000000000000E+00   4.73432258565669E-18
     -9.73603101726273E-23  -8.66999482857985E-09  -8.66999482384562E-09  -2.98278098903452E-18
      1.20058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   1.35202506246194E-18   1.51145557806753E-22
      8.67004766127350E-09   8.67004766262567E-09  -8.24258553937194E-19  -2.33014351649014E-01  -2.33014351649014E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62767405722878E-15   0.00000000000000E+00  -1.62767405722878E-15
      3.80703697819090E-18  -2.33012796295823E-01  -2.30281266341190E-01   0.00000000000000E+00   6.10333410071002E-18
     -9.73602486941544E-23  -8.67004604105484E-09  -8.67004603495160E-09  -2.98277842425371E-18
      1.22058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00   1.35630642395165E-18   1.51145757350148E-22
      8.67010182846545E-09   8.67010182982191E-09  -8.24257805537756E-19  -2.33014758995590E-01  -2.33014758995590E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86662681262066E-15   0.00000000000000E+00  -1.86662681262066E-15
      3.80703324493727E-18  -2.33012352954553E-01  -2.30280806009165E-01   0.00000000000000E+00   7.55634516007029E-18
     -9.73601782614042E-23  -8.67009997075134E-09  -8.67009996319510E-09  -2.98277543939952E-18
      1.24058924687078E-07
      0.00000000000000E+00  -8.67014319239053E-12   0.00000000000000E+00   1.32344546570852E-18   1.51145905506203E-22
      8.67015408798875E-09   8.67015408931235E-09  -8.24257053815338E-19  -2.33015175393739E-01  -2.33015175393739E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.00886249590177E-15   0.00000000000000E+00  -2.00886249590177E-15
      3.80702922721228E-18  -2.33011817043854E-01  -2.30280253678238E-01   0.00000000000000E+00   8.70977796219690E-18
     -9.73600961308954E-23  -8.67015208915953E-09  -8.67015208044985E-09  -2.98277217339694E-18
      1.26058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   1.11039057971721E-18   1.51145884858535E-22
      8.67019817047845E-09   8.67019817158899E-09  -8.24256376181538E-19  -2.33015560949943E-01  -2.33015560949943E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99959828554152E-15   0.00000000000000E+00  -1.99959828554152E-15
      3.80702522801571E-18  -2.33011206030897E-01  -2.30279628773547E-01   0.00000000000000E+00   9.47196272353138E-18
     -9.73600098684029E-23  -8.67019618146257E-09  -8.67019617199070E-09  -2.98276885183417E-18
      1.28058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   8.33641983088464E-19   1.51145654182472E-22
      8.67022606322720E-09   8.67022606406099E-09  -8.24255874369805E-19  -2.33015862473597E-01  -2.33015862473597E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77709586147410E-15   0.00000000000000E+00  -1.77709586147410E-15
      3.80702167382399E-18  -2.33010552507740E-01  -2.30278966392189E-01   0.00000000000000E+00   9.41720299447329E-18
     -9.73599247260191E-23  -8.67022429638224E-09  -8.67022428696513E-09  -2.98276579945418E-18
      1.30058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   2.07056224869454E-19   1.51145135379505E-22
      8.67022812400541E-09   8.67022812421262E-09  -8.24255673906504E-19  -2.33016013511611E-01  -2.33016013511611E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27624754298595E-15   0.00000000000000E+00  -1.27624754298595E-15
      3.80701912132890E-18  -2.33009907052877E-01  -2.30278320130040E-01   0.00000000000000E+00   8.49839282547518E-18
     -9.73598512327472E-23  -8.67022685646337E-09  -8.67022684796507E-09  -2.98276344742240E-18
      1.32058924687078E-07
      0.00000000000000E+00  -8.67023503712773E-12   0.00000000000000E+00   5.86597732173482E-19   1.51144266590920E-22
      8.67019341235174E-09   8.67019341293849E-09  -8.24255920863092E-19  -2.33015935789954E-01  -2.33015935789954E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.34004641228389E-16   0.00000000000000E+00  -4.34004641228389E-16
      3.80701825331962E-18  -2.33009340403259E-01  -2.30277764151104E-01   0.00000000000000E+00   5.02414936084714E-18
     -9.73598016308723E-23  -8.67019298395790E-09  -8.67019297893385E-09  -2.98276233245653E-18
      1.34058924687078E-07
      0.00000000000000E+00  -8.67005134765332E-12   0.00000000000000E+00  -1.45038847397956E-18   1.51142992015469E-22
      8.67011029488169E-09   8.67011029343145E-09  -8.24256775143428E-19  -2.33015542475369E-01  -2.33015542475369E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03198732469128E-16   0.00000000000000E+00   8.03198732469128E-16
      3.80701985971709E-18  -2.33008944418088E-01  -2.30277393962951E-01   0.00000000000000E+00   2.08499561258895E-18
     -9.73597911250767E-23  -8.67011109871508E-09  -8.67011109663018E-09  -2.98276308457366E-18
      1.36058924687078E-07
      0.00000000000000E+00  -8.66995950291611E-12   0.00000000000000E+00   1.67824615360510E-18   1.51141276670040E-22
      8.66996736961944E-09   8.66996737129784E-09  -8.24258399487790E-19  -2.33014743708803E-01  -2.33014743708804E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46987492395832E-15   0.00000000000000E+00   2.46987492395832E-15
      3.80702479946693E-18  -2.33008831243621E-01  -2.30277325293294E-01   0.00000000000000E+00  -8.17332025847365E-18
     -9.73598370242226E-23  -8.66996983299934E-09  -8.66996984117276E-09  -2.98276639997914E-18
      1.38058924687078E-07
      0.00000000000000E+00  -8.66977581344170E-12   0.00000000000000E+00  -3.86029388502131E-18   1.51139116858464E-22
      8.66975476198328E-09   8.66975475812314E-09  -8.24260943699725E-19  -2.33013454714507E-01  -2.33013454714507E-01
      0.00000000000000E+00   0.00000000000000E+00   4.57000207200142E-15   0.00000000000000E+00   4.57000207200142E-15
      3.80703393947108E-18  -2.33009129995745E-01  -2.30277690367905E-01   0.00000000000000E+00  -1.19799316130347E-17
     -9.73599579317812E-23  -8.66975931614518E-09  -8.66975932812521E-09  -2.98277299577135E-18
      1.40058924687078E-07
      0.00000000000000E+00  -8.66950027923007E-12   0.00000000000000E+00   3.88367403251575E-18   1.51136553977537E-22
      8.66946577286733E-09   8.66946577675116E-09  -8.24264523565117E-19  -2.33011606793518E-01  -2.33011606793518E-01
      0.00000000000000E+00   0.00000000000000E+00   7.06392944463917E-15   0.00000000000000E+00   7.06392944463917E-15
      3.80704806732996E-18  -2.33009980324345E-01  -2.30278630959808E-01   0.00000000000000E+00  -3.14842325961840E-17
     -9.73601723315853E-23  -8.66947280919627E-09  -8.66947284068060E-09  -2.98278354376485E-18
      1.42058924687078E-07
      0.00000000000000E+00  -8.66913290028124E-12   0.00000000000000E+00  -7.09882471590236E-18   1.51133688440660E-22
      8.66909892411967E-09   8.66909891702100E-09  -8.24269194718572E-19  -2.33009161137653E-01  -2.33009161137653E-01
      0.00000000000000E+00   0.00000000000000E+00   9.85436562173178E-15   0.00000000000000E+00   9.85436562173178E-15
      3.80706777606121E-18  -2.33011522157647E-01  -2.30280287493657E-01   0.00000000000000E+00  -3.39161410230663E-17
     -9.73604966001602E-23  -8.66910873747038E-09  -8.66910877138661E-09  -2.98279858134264E-18
      1.44058924687078E-07
      0.00000000000000E+00  -8.66867367659521E-12   0.00000000000000E+00   3.26256571029063E-18   1.51130694301487E-22
      8.66866023580756E-09   8.66866023907028E-09  -8.24274921797825E-19  -2.33006125318087E-01  -2.33006125318087E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27727877472565E-14   0.00000000000000E+00   1.27727877472565E-14
      3.80709332163670E-18  -2.33013881238745E-01  -2.30282783868977E-01   0.00000000000000E+00  -5.95344255592770E-17
     -9.73609424357500E-23  -8.66867295232349E-09  -8.66867301185801E-09  -2.98281839983888E-18
      1.46058924687078E-07
      0.00000000000000E+00  -8.66812260817196E-12   0.00000000000000E+00  -1.09298367218926E-17   1.51127830780193E-22
      8.66816576135343E-09   8.66816575042374E-09  -8.24281544447012E-19  -2.33002571710650E-01  -2.33002571710650E-01
      0.00000000000000E+00   0.00000000000000E+00   1.55672004692105E-14   0.00000000000000E+00   1.55672004692105E-14
      3.80712445603764E-18  -2.33017150050818E-01  -2.30286207590627E-01   0.00000000000000E+00  -6.02223860335290E-17
     -9.73615136737677E-23  -8.66818125740173E-09  -8.66818131762421E-09  -2.98284291159063E-18
      1.48058924687078E-07
      0.00000000000000E+00  -8.66766338448592E-12   0.00000000000000E+00  -5.29782913023123E-18   1.51125451580305E-22
      8.66764400757402E-09   8.66764400227634E-09  -8.24288742175403E-19  -2.32998656834608E-01  -2.32998656834608E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78942954251582E-14   0.00000000000000E+00   1.78942954251582E-14
      3.80716024462849E-18  -2.33021364417631E-01  -2.30290585609157E-01   0.00000000000000E+00  -8.04752321394010E-17
     -9.73622026524777E-23  -8.66766181609642E-09  -8.66766189657175E-09  -2.98287150245309E-18
      1.50058924687078E-07
      0.00000000000000E+00  -8.66711231606268E-12   0.00000000000000E+00  -1.26347055919461E-17   1.51124005996465E-22
      8.66713818047719E-09   8.66713816784263E-09  -8.24296001425728E-19  -2.32994639900428E-01  -2.32994639900428E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93168997438021E-14   0.00000000000000E+00   1.93168997438021E-14
      3.80719887842798E-18  -2.33026476220258E-01  -2.30295856330948E-01   0.00000000000000E+00  -8.36543213593728E-17
     -9.73629862120269E-23  -8.66715740108795E-09  -8.66715748474237E-09  -2.98290287700225E-18
      1.52058924687078E-07
      0.00000000000000E+00  -8.66674493711385E-12   0.00000000000000E+00  -1.06231332257166E-17   1.51124032749877E-22
      8.66670772207671E-09   8.66670771145373E-09  -8.24302589132328E-19  -2.32990898331368E-01  -2.32990898331368E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93112512083424E-14   0.00000000000000E+00   1.93112512083424E-14
      3.80723750093040E-18  -2.33032323635201E-01  -2.30301839369652E-01   0.00000000000000E+00  -9.15770329186002E-17
     -9.73638217213467E-23  -8.66672693112780E-09  -8.66672702270493E-09  -2.98293491179807E-18
      1.54058924687078E-07
      0.00000000000000E+00  -8.66637755816502E-12   0.00000000000000E+00  -2.67755908640252E-18   1.51126139882667E-22
      8.66642885379373E-09   8.66642885111633E-09  -8.24307538380777E-19  -2.32987937305783E-01  -2.32987937305783E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72855586301624E-14   0.00000000000000E+00   1.72855586301624E-14
      3.80727207204766E-18  -2.33038600896347E-01  -2.30308205131255E-01   0.00000000000000E+00  -9.63935938562893E-17
     -9.73646434283947E-23  -8.66644604028126E-09  -8.66644613667495E-09  -2.98296453366688E-18
      1.56058924687078E-07
      0.00000000000000E+00  -8.66637755816502E-12   0.00000000000000E+00   4.72573151534574E-17   1.51130970579459E-22
      8.66639358005230E-09   8.66639362730977E-09  -8.24309652182543E-19  -2.32986390086617E-01  -2.32986390086617E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26133947539536E-14   0.00000000000000E+00   1.26133947539536E-14
      3.80729729883716E-18  -2.33044830508931E-01  -2.30314447331305E-01   0.00000000000000E+00  -1.32095949617714E-16
     -9.73653597579356E-23  -8.66640610860848E-09  -8.66640624070453E-09  -2.98298764665462E-18
      1.58058924687078E-07
      0.00000000000000E+00  -8.66665309237664E-12   0.00000000000000E+00   3.75328307430172E-17   1.51139149695899E-22
      8.66670663981087E-09   8.66670667734386E-09  -8.24307533930674E-19  -2.32987004602739E-01  -2.32987004602739E-01
      0.00000000000000E+00   0.00000000000000E+00   4.68578672407375E-15   0.00000000000000E+00   4.68578672407375E-15
      3.80730667041061E-18  -2.33050341876366E-01  -2.30319862565895E-01   0.00000000000000E+00  -9.36483815771369E-17
     -9.73658521800866E-23  -8.66671126948209E-09  -8.66671136313057E-09  -2.98299913647994E-18
      1.60058924687078E-07
      0.00000000000000E+00  -8.66747969501151E-12   0.00000000000000E+00   2.86544770526175E-16   1.51151212359158E-22
      8.66747975496872E-09   8.66748004151364E-09  -8.24299649196544E-19  -2.32990613464060E-01  -2.32990613464060E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01969041478030E-15   0.00000000000000E+00  -7.01969041478030E-15
      3.80729263102978E-18  -2.33054261390184E-01  -2.30323542191714E-01   0.00000000000000E+00  -2.97154044650068E-16
     -9.73659763685472E-23  -8.66747272466909E-09  -8.66747302182323E-09  -2.98299298183324E-18
      1.62058924687078E-07
      0.00000000000000E+00  -8.66885736606962E-12   0.00000000000000E+00   1.24089006248947E-16   1.51167505973435E-22
      8.66882323428364E-09   8.66882335837280E-09  -8.24284431435603E-19  -2.32998080948447E-01  -2.32998080948447E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.28464152092966E-14   0.00000000000000E+00  -2.28464152092966E-14
      3.80724693819936E-18  -2.33055518889687E-01  -2.30324381402336E-01   0.00000000000000E+00  -6.76444123925525E-17
     -9.73655666620933E-23  -8.66880044431308E-09  -8.66880051195759E-09  -2.98296250676377E-18
      1.64058924687078E-07
      0.00000000000000E+00  -8.67087795028819E-12   0.00000000000000E+00   7.83857682558203E-16   1.51188086287712E-22
      8.67083303439006E-09   8.67083381824790E-09  -8.24260428780589E-19  -2.33010227401092E-01  -2.33010227401092E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28498252149916E-14   0.00000000000000E+00  -4.28498252149916E-14
      3.80716123854893E-18  -2.33052878962783E-01  -2.30321114570102E-01   0.00000000000000E+00  -6.46869215785205E-16
     -9.73644443890624E-23  -8.67079032155337E-09  -8.67079096842268E-09  -2.98290080976835E-18
      1.66058924687078E-07
      0.00000000000000E+00  -8.67363329240441E-12   0.00000000000000E+00   2.35998585167635E-16   1.51212569790974E-22
      8.67357642408566E-09   8.67357666008440E-09  -8.24226508021408E-19  -2.33027723254388E-01  -2.33027723254388E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66744472667986E-14   0.00000000000000E+00  -6.66744472667986E-14
      3.80702788965440E-18  -2.33044999260863E-01  -2.30312378041346E-01   0.00000000000000E+00   1.62089328381387E-17
     -9.73624312534231E-23  -8.67351000184596E-09  -8.67350998563713E-09  -2.98280138163299E-18
      1.68058924687078E-07
      0.00000000000000E+00  -8.67703154768109E-12   0.00000000000000E+00   1.32551004026925E-15   1.51240027358535E-22
      8.67707033512963E-09   8.67707166063983E-09  -8.24182099359011E-19  -2.33050959287124E-01  -2.33050959287124E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.34121823433469E-14   0.00000000000000E+00  -9.34121823433469E-14
      3.80684106528971E-18  -2.33030529546473E-01  -2.30296815955762E-01   0.00000000000000E+00  -9.68566550150105E-16
     -9.73593679872805E-23  -8.67697727989083E-09  -8.67697824845747E-09  -2.98265896593070E-18
      1.70058924687078E-07
      0.00000000000000E+00  -8.68125640559264E-12   0.00000000000000E+00   2.84155626334967E-16   1.51268800825096E-22
      8.68126264131481E-09   8.68126292547058E-09  -8.24127494502988E-19  -2.33079887821449E-01  -2.33079887821449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21487211292188E-13   0.00000000000000E+00  -1.21487211292188E-13
      3.80659809086713E-18  -2.33008244879733E-01  -2.30273219301981E-01   0.00000000000000E+00   2.34928175298523E-16
     -9.73551388620862E-23  -8.68114167318737E-09  -8.68114143825929E-09  -2.98247059636414E-18
      1.72058924687078E-07
      0.00000000000000E+00  -8.68603233192743E-12   0.00000000000000E+00   1.18145779705527E-16   1.51296441366225E-22
      8.68600397883432E-09   8.68600409698025E-09  -8.24064168578122E-19  -2.33113847976432E-01  -2.33113847976432E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48514447112195E-13   0.00000000000000E+00  -1.48514447112195E-13
      3.80630106197290E-18  -2.32977230841321E-01  -2.30240719964052E-01   0.00000000000000E+00   5.57229905862072E-16
     -9.73497019417822E-23  -8.68585613976295E-09  -8.68585558253314E-09  -2.98223689339478E-18
      1.74058924687078E-07
      0.00000000000000E+00  -8.69099194773663E-12   0.00000000000000E+00   1.84043471593541E-16   1.51319593924112E-22
      8.69102709391792E-09   8.69102727796154E-09  -8.23995117857044E-19  -2.33151379676229E-01  -2.33151379676229E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71239398399064E-13   0.00000000000000E+00  -1.71239398399064E-13
      3.80595858317611E-18  -2.32937105060434E-01  -2.30199018748966E-01   0.00000000000000E+00   6.19951370696167E-16
     -9.73431239126215E-23  -8.69085665851442E-09  -8.69085603856315E-09  -2.98196346531906E-18
      1.76058924687078E-07
      0.00000000000000E+00  -8.69595156354584E-12   0.00000000000000E+00   1.22151947129695E-16   1.51333978571267E-22
      8.69592367186925E-09   8.69592379402135E-09  -8.23925177401328E-19  -2.33190045360140E-01  -2.33190045360140E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85507357064019E-13   0.00000000000000E+00  -1.85507357064019E-13
      3.80558756846198E-18  -2.32888279281827E-01  -2.30148654735680E-01   0.00000000000000E+00   7.98281307772592E-16
     -9.73356183913485E-23  -8.69573908494549E-09  -8.69573828666428E-09  -2.98166239106065E-18
      1.78058924687078E-07
      0.00000000000000E+00  -8.70017642145739E-12   0.00000000000000E+00   1.57735562320389E-16   1.51334469894528E-22
      8.70012859017947E-09   8.70012874791518E-09  -8.23861277862004E-19  -2.33226279317480E-01  -2.33226279317480E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86318495715763E-13   0.00000000000000E+00  -1.86318495715763E-13
      3.80521493147055E-18  -2.32832247115194E-01  -2.30091298005850E-01   0.00000000000000E+00   8.16482582513029E-16
     -9.73275845782155E-23  -8.69994324590194E-09  -8.69994242941946E-09  -2.98135365360854E-18
      1.80058924687078E-07
      0.00000000000000E+00  -8.70293176357361E-12   0.00000000000000E+00   6.96780389827053E-17   1.51315268678297E-22
      8.70291397816936E-09   8.70291404784755E-09  -8.23812596427348E-19  -2.33255289535215E-01  -2.33255289535215E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67998839770030E-13   0.00000000000000E+00  -1.67998839770030E-13
      3.80487893379101E-18  -2.32771877761107E-01  -2.30030045296344E-01   0.00000000000000E+00   8.86658757264961E-16
     -9.73196429754730E-23  -8.70274693566644E-09  -8.70274604900778E-09  -2.98106633736366E-18
      1.82058924687078E-07
      0.00000000000000E+00  -8.70339098725965E-12   0.00000000000000E+00   1.24022794197954E-17   1.51270229194227E-22
      8.70339828061754E-09   8.70339829301997E-09  -8.23790528598926E-19  -2.33271050267652E-01  -2.33271050267652E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24520125134731E-13   0.00000000000000E+00  -1.24520125134731E-13
      3.80462989354074E-18  -2.32711687020565E-01  -2.29969688252565E-01   0.00000000000000E+00   8.13971608806384E-16
     -9.73126623080982E-23  -8.70327458686635E-09  -8.70327377289483E-09  -2.98083936494181E-18
      1.84058924687078E-07
      0.00000000000000E+00  -8.70054380040622E-12   0.00000000000000E+00  -6.99773758304060E-17   1.51193344204606E-22
      8.70057523642649E-09   8.70057516644926E-09  -8.23808431462982E-19  -2.33266413383545E-01  -2.33266413383545E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.99687428349577E-14   0.00000000000000E+00  -4.99687428349577E-14
      3.80452995605507E-18  -2.32658047287332E-01  -2.29916914439572E-01   0.00000000000000E+00   6.26039986130807E-16
     -9.73077722418124E-23  -8.70052582374632E-09  -8.70052519770643E-09  -2.98072152459209E-18
      1.86058924687078E-07
      0.00000000000000E+00  -8.69337991090403E-12   0.00000000000000E+00  -1.79190973554923E-16   1.51079411133157E-22
      8.69336868234255E-09   8.69336850315173E-09  -8.23881050224745E-19  -2.33233385499010E-01  -2.33233385499010E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07801543550152E-14   0.00000000000000E+00   6.07801543550152E-14
      3.80465151636378E-18  -2.32619288053644E-01  -2.29880390793247E-01   0.00000000000000E+00   2.94678697138135E-16
     -9.73063535368380E-23  -8.69342957798468E-09  -8.69342928330608E-09  -2.98077046613903E-18
      1.88058924687078E-07
      0.00000000000000E+00  -8.68070533716939E-12   0.00000000000000E+00  -3.14898824936851E-16   1.50924886854859E-22
      8.68071789123777E-09   8.68071757633909E-09  -8.24023563925289E-19  -2.33163607388826E-01  -2.33163607388826E-01
      0.00000000000000E+00   0.00000000000000E+00   2.11196744313965E-13   0.00000000000000E+00   2.11196744313965E-13
      3.80507390985241E-18  -2.32605629985760E-01  -2.29870671082139E-01   0.00000000000000E+00  -2.05287367842287E-16
     -9.73099975608438E-23  -8.68092856779595E-09  -8.68092877308341E-09  -2.98105034592712E-18
      1.90058924687078E-07
      0.00000000000000E+00  -8.66169347656743E-12   0.00000000000000E+00  -4.73690923393648E-16   1.50728923503096E-22
      8.66169676636300E-09   8.66169629267223E-09  -8.24250185172063E-19  -2.33049072730953E-01  -2.33049072730953E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02036934300565E-13   0.00000000000000E+00   4.02036934300565E-13
      3.80587798372101E-18  -2.32628890378521E-01  -2.29899864142383E-01   0.00000000000000E+00  -8.92172755829931E-16
     -9.73204263298924E-23  -8.66209743743368E-09  -8.66209832960653E-09  -2.98162779854894E-18
      1.92058924687078E-07
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00  -6.48574717440852E-16   1.50494564107510E-22
      8.63566769583610E-09   8.63566704726154E-09  -8.24572268336893E-19  -2.32883113674588E-01  -2.32883113674588E-01
      0.00000000000000E+00   0.00000000000000E+00   6.30121012025785E-13   0.00000000000000E+00   6.30121012025785E-13
      3.80713822574506E-18  -2.32701897404514E-01  -2.29981000038072E-01   0.00000000000000E+00  -1.77225034540090E-15
     -9.73393649019593E-23  -8.63629539602312E-09  -8.63629716827356E-09  -2.98256595740817E-18
      1.94058924687078E-07
      0.00000000000000E+00  -8.60245362106858E-12   0.00000000000000E+00  -8.27402353188941E-16   1.50230055203915E-22
      8.60246709167510E-09   8.60246626427290E-09  -8.24995912246592E-19  -2.32661664709603E-01  -2.32661664709604E-01
      0.00000000000000E+00   0.00000000000000E+00   8.87013699684249E-13   0.00000000000000E+00   8.87013699684249E-13
      3.80891225314443E-18  -2.32837557500430E-01  -2.30127039407282E-01   0.00000000000000E+00  -2.83480361990402E-15
     -9.73683597739552E-23  -8.60335044316887E-09  -8.60335327797258E-09  -2.98391634089783E-18
      1.96058924687078E-07
      0.00000000000000E+00  -8.56259300512051E-12   0.00000000000000E+00  -9.93672706308478E-16   1.49950205317638E-22
      8.56261482889993E-09   8.56261383522738E-09  -8.25519092512759E-19  -2.32384791012864E-01  -2.32384791012865E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15770949203672E-12   0.00000000000000E+00   1.15770949203672E-12
      3.81122767212850E-18  -2.33047536315482E-01  -2.30349488838478E-01   0.00000000000000E+00  -4.04438904751666E-15
     -9.74085403905393E-23  -8.56376750033027E-09  -8.56377154471941E-09  -2.98570857961574E-18
      1.98058924687078E-07
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -1.12418258797925E-15   1.49677678474594E-22
      8.51753432383753E-09   8.51753319965509E-09  -8.26128429504704E-19  -2.32058430653067E-01  -2.32058430653069E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41947477615788E-12   0.00000000000000E+00   1.41947477615788E-12
      3.81406662168082E-18  -2.33340539981047E-01  -2.30656613166747E-01   0.00000000000000E+00  -5.33614837813188E-15
     -9.74603262512810E-23  -8.51894733828277E-09  -8.51895267443124E-09  -2.98793819217611E-18
      2.00058924687078E-07
      0.00000000000000E+00  -8.46973797580370E-12   0.00000000000000E+00  -1.19178057475821E-15   1.49444055097276E-22
      8.46976455886551E-09   8.46976336708509E-09  -8.26795793932821E-19  -2.31696249997150E-01  -2.31696249997151E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64104870048698E-12   0.00000000000000E+00   1.64104870048698E-12
      3.81734871908179E-18  -2.33720219753210E-01  -2.31051273567313E-01   0.00000000000000E+00  -6.60704525602017E-15
     -9.75230895394543E-23  -8.47139780874022E-09  -8.47140441578557E-09  -2.99055292514897E-18
      2.02058924687078E-07
      0.00000000000000E+00  -8.42317269403949E-12   0.00000000000000E+00  -1.16370729792296E-15   1.49290414198572E-22
      8.42314088293854E-09   8.42313971923139E-09  -8.27475073773005E-19  -2.31321447990791E-01  -2.31321447990792E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78245153024721E-12   0.00000000000000E+00   1.78245153024721E-12
      3.82091362214229E-18  -2.34182767258999E-01  -2.31528465898878E-01   0.00000000000000E+00  -7.71324678596112E-15
     -9.75947924660783E-23  -8.42491445751476E-09  -8.42492217076164E-09  -2.99343854836928E-18
      2.04058924687078E-07
      0.00000000000000E+00  -8.38294469914259E-12   0.00000000000000E+00  -1.00470015843811E-15   1.49267090256515E-22
      8.38291880066145E-09   8.38291779596144E-09  -8.28099569103336E-19  -2.30968270058599E-01  -2.30968270058600E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79568204056117E-12   0.00000000000000E+00   1.79568204056117E-12
      3.82450498622341E-18  -2.34714315877810E-01  -2.32072682864144E-01   0.00000000000000E+00  -8.46643709262824E-15
     -9.76716289961380E-23  -8.38470501156482E-09  -8.38471347800201E-09  -2.99640541712007E-18
      2.06058924687078E-07
      0.00000000000000E+00  -8.35585050166637E-12   0.00000000000000E+00  -6.78329431790580E-16   1.49432145789556E-22
      8.35581459660766E-09   8.35581391827838E-09  -8.28580631220674E-19  -2.30682913141675E-01  -2.30682913141677E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62659283687457E-12   0.00000000000000E+00   1.62659283687457E-12
      3.82775817189716E-18  -2.35288311762422E-01  -2.32655271640533E-01   0.00000000000000E+00  -8.63703142150664E-15
     -9.77477110446309E-23  -8.35743187408374E-09  -8.35744051111526E-09  -2.99917754067648E-18
      2.08058924687078E-07
      0.00000000000000E+00  -8.34988059374788E-12   0.00000000000000E+00  -1.50703264219416E-16   1.49848004261409E-22
      8.34993792194667E-09   8.34993777124356E-09  -8.28808291410509E-19  -2.30523433329064E-01  -2.30523433329065E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21820148082268E-12   0.00000000000000E+00   1.21820148082268E-12
      3.83019457485880E-18  -2.35863062501794E-01  -2.33232002738284E-01   0.00000000000000E+00  -7.96250463975965E-15
     -9.78148479390853E-23  -8.35114801021965E-09  -8.35115597272438E-09  -3.00138628344829E-18
      2.10058924687078E-07
      0.00000000000000E+00  -8.37467867279391E-12   0.00000000000000E+00   6.10377959274133E-16   1.50575659352379E-22
      8.37459229390154E-09   8.37459290427965E-09  -8.28654688387773E-19  -2.30558227873167E-01  -2.30558227873167E-01
      0.00000000000000E+00   0.00000000000000E+00   5.15616012558535E-13   0.00000000000000E+00   5.15616012558535E-13
      3.83122580688392E-18  -2.36379713483305E-01  -2.33741107663918E-01   0.00000000000000E+00  -6.16946385482703E-15
     -9.78624729822108E-23  -8.37510235082825E-09  -8.37510852029221E-09  -3.00257111849614E-18
      2.12058924687078E-07
      0.00000000000000E+00  -8.43988843621126E-12   0.00000000000000E+00   1.56806427870365E-15   1.51665991612151E-22
      8.43991627967158E-09   8.43991784773601E-09  -8.27981042800217E-19  -2.30862681931365E-01  -2.30862681931364E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27379616972284E-13   0.00000000000000E+00  -5.27379616972284E-13
      3.83017104764997E-18  -2.36760949565654E-01  -2.34102091564088E-01   0.00000000000000E+00  -2.93864314514968E-15
     -9.78777709198568E-23  -8.43938752947579E-09  -8.43939046811903E-09  -3.00219000484976E-18
      2.14058924687078E-07
      0.00000000000000E+00  -8.55634756299040E-12   0.00000000000000E+00   2.89117062071303E-15   1.53148079642823E-22
      8.55632695923393E-09   8.55632985040471E-09  -8.26648678106218E-19  -2.31513677725821E-01  -2.31513677725819E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.94022274302023E-12   0.00000000000000E+00  -1.94022274302023E-12
      3.82629060216393E-18  -2.36910788321299E-01  -2.34215699253284E-01   0.00000000000000E+00   1.77915629670200E-15
     -9.78460547384179E-23  -8.55439140681790E-09  -8.55438962766170E-09  -2.99964192405771E-18
      2.16058924687078E-07
      0.00000000000000E+00  -8.73369975053813E-12   0.00000000000000E+00   3.97800485872508E-15   1.55015040112692E-22
      8.73370580848754E-09   8.73370978649255E-09  -8.24534120430131E-19  -2.32581877036713E-01  -2.32581877036709E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.72632463560115E-12   0.00000000000000E+00  -3.72632463560115E-12
      3.81883795289273E-18  -2.36715940619857E-01  -2.33965529373212E-01   0.00000000000000E+00   8.68254765818896E-15
     -9.77514323082470E-23  -8.72999214440452E-09  -8.72998346185696E-09  -2.99430383246260E-18
      2.18058924687078E-07
      0.00000000000000E+00  -8.98030286994034E-12   0.00000000000000E+00   6.11815829017854E-15   1.57208942057450E-22
      8.98023632066125E-09   8.98024243881969E-09  -8.21547641344718E-19  -2.34122004944860E-01  -2.34122004944854E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85329028186045E-12   0.00000000000000E+00  -5.85329028186045E-12
      3.80713137232901E-18  -2.36049382284466E-01  -2.33221969180994E-01   0.00000000000000E+00   1.64170667663713E-14
     -9.75777978233755E-23  -8.97440556560450E-09  -8.97438914853783E-09  -2.98558373098429E-18
      2.20058924687078E-07
      0.00000000000000E+00  -9.30074915805740E-12   0.00000000000000E+00   7.98385162153669E-15   1.59607364093609E-22
      9.30077706521259E-09   9.30078504906437E-09  -8.17653926492920E-19  -2.36161714322526E-01  -2.36161714322517E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.24345626399729E-12   0.00000000000000E+00  -8.24345626399729E-12
      3.79064445980102E-18  -2.34776996087938E-01  -2.31849346140852E-01   0.00000000000000E+00   2.60043549899375E-14
     -9.73101910072022E-23  -9.29256759715528E-09  -9.29254159280039E-09  -2.97299053330810E-18
      2.22058924687078E-07
      0.00000000000000E+00  -9.69467123594049E-12   0.00000000000000E+00   9.78602983410369E-15   1.62015170580167E-22
      9.69464069851512E-09   9.69465048454511E-09  -8.12893069484142E-19  -2.38689898513769E-01  -2.38689898513758E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07655611624504E-11   0.00000000000000E+00  -1.07655611624504E-11
      3.76911333747612E-18  -2.32768381298456E-01  -2.29717434595922E-01   0.00000000000000E+00   3.66536116075742E-14
     -9.69365938957875E-23  -9.68392157699418E-09  -9.68388492338266E-09  -2.95622026799197E-18
      2.24058924687078E-07
      0.00000000000000E+00  -1.01527009403944E-11   0.00000000000000E+00   1.14067428270602E-14   1.64165022436417E-22
      1.01526940349690E-08   1.01527054417120E-08  -8.07400234842922E-19  -2.41645361335469E-01  -2.41645361335456E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32281828379235E-11   0.00000000000000E+00  -1.32281828379235E-11
      3.74265697180027E-18  -2.29913075780302E-01  -2.26718589462987E-01   0.00000000000000E+00   4.75973471431586E-14
     -9.64502855823079E-23  -1.01395248562211E-08  -1.01394772588740E-08  -2.93525673695735E-18
      2.26058924687078E-07
      0.00000000000000E+00  -1.06538058265987E-11   0.00000000000000E+00   1.24741836753098E-14   1.65729183716650E-22
      1.06538048952802E-08   1.06538173694641E-08  -8.01423236154169E-19  -2.44906430117836E-01  -2.44906430117821E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53746704777836E-11   0.00000000000000E+00  -1.53746704777836E-11
      3.71190763084470E-18  -2.26143365823975E-01  -2.22791673956997E-01   0.00000000000000E+00   5.79946537298316E-14
     -9.58529164023045E-23  -1.06385006936400E-08  -1.06384426989863E-08  -2.91048439469053E-18
      2.28058924687078E-07
      0.00000000000000E+00  -1.11608806207214E-11   0.00000000000000E+00   1.26270438934712E-14   1.66343159260938E-22
      1.11608932950203E-08   1.11609059220644E-08  -7.95338865760358E-19  -2.48281382918327E-01  -2.48281382918310E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68781879288387E-11   0.00000000000000E+00  -1.68781879288387E-11
      3.67815125498703E-18  -2.21464338553248E-01  -2.17953354607903E-01   0.00000000000000E+00   6.66944959962231E-14
     -9.51584266007409E-23  -1.11440944286315E-08  -1.11440277341356E-08  -2.88281238922667E-18
      2.30058924687077E-07
      0.00000000000000E+00  -1.16172571199056E-11   0.00000000000000E+00   1.13672051486696E-14   1.65639635208191E-22
      1.16172484064680E-08   1.16172597736733E-08  -7.89670344310737E-19  -2.51498722387093E-01  -2.51498722387075E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73349137327673E-11   0.00000000000000E+00  -1.73349137327673E-11
      3.64348142752149E-18  -2.15990532783152E-01  -2.12335910430842E-01   0.00000000000000E+00   7.24342416594529E-14
     -9.43976947626689E-23  -1.15999972941821E-08  -1.15999248599405E-08  -2.85381108321075E-18
      2.32058924687077E-07
      0.00000000000000E+00  -1.19444080738389E-11   0.00000000000000E+00   8.15932748892320E-15   1.63288554183004E-22
      1.19444315876095E-08   1.19444397469371E-08  -7.85108496196048E-19  -2.54195957616579E-01  -2.54195957616563E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62559035675400E-11   0.00000000000000E+00  -1.62559035675400E-11
      3.61096962038641E-18  -2.09985984945125E-01  -2.06227937034359E-01   0.00000000000000E+00   7.38436533378326E-14
     -9.36233172899227E-23  -1.19282576870228E-08  -1.19281838433696E-08  -2.82586112419036E-18
      2.34058924687077E-07
      0.00000000000000E+00  -1.20440596137090E-11   0.00000000000000E+00   2.50870735577800E-15   1.59033345711776E-22
      1.20440931793241E-08   1.20440956880317E-08  -7.82536535654629E-19  -2.55906569541567E-01  -2.55906569541554E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30662281698230E-11   0.00000000000000E+00  -1.30662281698230E-11
      3.58483716404676E-18  -2.03899994220621E-01  -2.00109539103472E-01   0.00000000000000E+00   6.94808652649031E-14
     -9.29132167710633E-23  -1.20310989407270E-08  -1.20310294598618E-08  -2.80230062839214E-18
      2.36058924687077E-07
      0.00000000000000E+00  -1.18072838811880E-11   0.00000000000000E+00  -5.85100830666398E-15   1.52698907188466E-22
      1.18072447042891E-08   1.18072388532810E-08  -7.83051535264022E-19  -2.56048060828523E-01  -2.56048060828516E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.13470406407460E-12   0.00000000000000E+00  -7.13470406407460E-12
      3.57056775591861E-18  -1.98384188061206E-01  -1.94666483890812E-01   0.00000000000000E+00   5.77217011828904E-14
     -9.23714584151422E-23  -1.18001618709180E-08  -1.18001041492169E-08  -2.78751622065459E-18
      2.38058924687077E-07
      0.00000000000000E+00  -1.11350722495661E-11   0.00000000000000E+00  -1.66717267930841E-14   1.44131044686336E-22
      1.11351218311631E-08   1.11351051594365E-08  -7.87965973658565E-19  -2.53919190778989E-01  -2.53919190778991E-01
      0.00000000000000E+00   0.00000000000000E+00   2.13006556296360E-12   0.00000000000000E+00   2.13006556296360E-12
      3.57482788704454E-18  -1.94268715151484E-01  -1.90759851077609E-01   0.00000000000000E+00   3.64539031500284E-14
     -9.21253457243683E-23  -1.11372716789025E-08  -1.11372352249994E-08  -2.78686191338598E-18
      2.40058924687077E-07
      0.00000000000000E+00  -9.97351185810254E-12   0.00000000000000E+00  -2.88708593959331E-14   1.33041115840596E-22
      9.97351145182274E-09   9.97348258096348E-09  -7.98767275943809E-19  -2.48718995006546E-01  -2.48718995006561E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50885198153671E-11   0.00000000000000E+00   1.50885198153671E-11
      3.60500492667528E-18  -1.92472209550668E-01  -1.89325241615304E-01   0.00000000000000E+00   2.61846435904575E-15
     -9.23193071526724E-23  -9.98857371924311E-09  -9.98857110077885E-09  -2.80623765073147E-18
      2.42058924687077E-07
      0.00000000000000E+00  -8.35438098587105E-12   0.00000000000000E+00  -4.02916141681419E-14   1.18816012661033E-22
      8.35443388276103E-09   8.35439359114698E-09  -8.17023939095075E-19  -2.39599594545117E-01  -2.39599594545148E-01
      0.00000000000000E+00   0.00000000000000E+00   3.15934733102326E-11   0.00000000000000E+00   3.15934733102326E-11
      3.66819187329574E-18  -1.93832615822090E-01  -1.91190557193200E-01   0.00000000000000E+00  -4.82700295268121E-14
     -9.31051627175958E-23  -8.38593879442761E-09  -8.38598706445723E-09  -2.85116793420067E-18
      2.44058924687077E-07
      0.00000000000000E+00  -6.42628441767344E-12   0.00000000000000E+00  -4.81078515416941E-14   1.00510581980834E-22
      6.42629202170177E-09   6.42624391385033E-09  -8.44255782480083E-19  -2.25758404430308E-01  -2.25758404430359E-01
      0.00000000000000E+00   0.00000000000000E+00   5.07006223408711E-11   0.00000000000000E+00   5.07006223408711E-11
      3.76959311797748E-18  -1.98883077240696E-01  -1.96842480804738E-01   0.00000000000000E+00  -1.21966470137204E-13
     -9.46215782837839E-23  -6.47682256972096E-09  -6.47694453619119E-09  -2.92533733549740E-18
      2.46058924687077E-07
      0.00000000000000E+00  -4.44455052294663E-12   0.00000000000000E+00  -4.96808546909267E-14   7.73378794533105E-23
      4.44459146404306E-09   4.44454178318845E-09  -8.81808028414632E-19  -2.06567634198054E-01  -2.06567634198125E-01
      0.00000000000000E+00   0.00000000000000E+00   7.05295018203359E-11   0.00000000000000E+00   7.05295018203359E-11
      3.91065212161816E-18  -2.07650922269659E-01  -2.06228431460429E-01   0.00000000000000E+00  -2.24440231025371E-13
     -9.69514738652617E-23  -4.51484684477766E-09  -4.51507128500878E-09  -3.02884409320352E-18
      2.48058924687077E-07
      0.00000000000000E+00  -2.70198032390823E-12   0.00000000000000E+00  -4.41026615353458E-14   4.96885934822065E-23
      2.70201961387955E-09   2.70197551121807E-09  -9.30753215689825E-19  -1.81721297005333E-01  -1.81721297005422E-01
      0.00000000000000E+00   0.00000000000000E+00   8.85701532363039E-11   0.00000000000000E+00   8.85701532363039E-11
      4.08779242809076E-18  -2.19597067870516E-01  -2.18717901595129E-01   0.00000000000000E+00  -3.58683018724623E-13
     -1.00072979967633E-22  -2.79018698143554E-09  -2.79054566445437E-09  -3.15703921240094E-18
      2.50058924687077E-07
      0.00000000000000E+00  -1.41238836877735E-12   0.00000000000000E+00  -3.33313890583453E-14   1.99312242241329E-23
      1.41246358275794E-09   1.41243025136890E-09  -9.91733284394158E-19  -1.51355734509837E-01  -1.51355734509940E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02599689048674E-10   0.00000000000000E+00   1.02599689048674E-10
      4.29299180618811E-18  -2.33781535664903E-01  -2.33304227032462E-01   0.00000000000000E+00  -5.19933404433682E-13
     -1.03867190188105E-22  -1.51451000701304E-09  -1.51502994041758E-09  -3.30125852179395E-18
      2.52058924687077E-07
      0.00000000000000E+00  -6.24452368273974E-13   0.00000000000000E+00  -2.20726285078490E-14  -7.71694217764202E-24
      6.24469421152063E-10   6.24447348523548E-10  -1.06403911606896E-18  -1.16305836283707E-01  -1.16305836283818E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11193666395882E-10   0.00000000000000E+00   1.11193666395882E-10
      4.51537913897988E-18  -2.49192974807086E-01  -2.48961213880783E-01   0.00000000000000E+00  -6.89328667127694E-13
     -1.08188118349130E-22  -7.34951686252194E-10  -7.35641014919430E-10  -3.45134002291092E-18
      2.54058924687077E-07
      0.00000000000000E+00  -2.38337093053532E-13   0.00000000000000E+00  -1.18718187143030E-14  -2.66054712467760E-23
      2.38384551771148E-10   2.38372679952407E-10  -1.14187664330632E-18  -7.94416965416512E-02  -7.94416965417627E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11456117198092E-10   0.00000000000000E+00   1.11456117198092E-10
      4.73829137337606E-18  -2.65041287245229E-01  -2.64931075936308E-01   0.00000000000000E+00  -8.19646062233749E-13
     -1.12786335778809E-22  -3.49009151088153E-10  -3.49828797150499E-10  -3.59641473006973E-18
      2.56058924687077E-07
      0.00000000000000E+00  -9.79064898632235E-14   0.00000000000000E+00  -5.61830864768868E-15  -3.50589336192137E-23
      9.79349527534281E-11   9.79293344447453E-11  -1.20909396568398E-18  -4.81763900222608E-02  -4.81763900223572E-02
      0.00000000000000E+00   0.00000000000000E+00   9.63189336060496E-11   0.00000000000000E+00   9.63189336060496E-11
      4.93092924058816E-18  -2.80870097061297E-01  -2.80808900680601E-01   0.00000000000000E+00  -7.97190312628818E-13
     -1.16949036325547E-22  -1.93451077738049E-10  -1.94248268050794E-10  -3.72183527490418E-18
      2.58058924687077E-07
      0.00000000000000E+00  -6.46586949940988E-14   0.00000000000000E+00  -2.11961026315134E-15  -3.67365340074566E-23
      6.46980991938005E-11   6.46959795835007E-11  -1.25271195401033E-18  -2.85381401681188E-02  -2.85381401681887E-02
      0.00000000000000E+00   0.00000000000000E+00   6.99315202792931E-11   0.00000000000000E+00   6.99315202792931E-11
      5.07079228114674E-18  -2.96492037935581E-01  -2.96449624895613E-01   0.00000000000000E+00  -6.11494006149904E-13
     -1.19996095690018E-22  -1.34016005856523E-10  -1.34627499862793E-10  -3.81808032713642E-18
      2.60058924687077E-07
      0.00000000000000E+00  -6.37402476220236E-14   0.00000000000000E+00  -5.31361508733492E-16  -3.45369059567488E-23
      6.37765054167741E-11   6.37759740552308E-11  -1.27586309657902E-18  -1.86252494796313E-02  -1.86252494796785E-02
      0.00000000000000E+00   0.00000000000000E+00   4.72548913169735E-11   0.00000000000000E+00   4.72548913169735E-11
      5.16530206378069E-18  -3.11839549586363E-01  -3.11804570748732E-01   0.00000000000000E+00  -4.34320560827177E-13
     -1.22096622075124E-22  -1.10596544811256E-10  -1.11030865372205E-10  -3.88943896720168E-18
      2.62058924687077E-07
      0.00000000000000E+00  -7.03530687009655E-14   0.00000000000000E+00   7.01533206160358E-17  -2.91720339948637E-23
      7.03155884205300E-11   7.03156585738215E-11  -1.28661059302482E-18  -1.41871650925627E-02  -1.41871650925955E-02
      0.00000000000000E+00   0.00000000000000E+00   3.27899105639630E-11   0.00000000000000E+00   3.27899105639630E-11
      5.23088188490861E-18  -3.26888318228713E-01  -3.26855836428263E-01   0.00000000000000E+00  -3.40132094205330E-13
     -1.23710467564519E-22  -1.02765437043456E-10  -1.03105569137785E-10  -3.94427129188380E-18
      2.64058924687077E-07
      0.00000000000000E+00  -7.82517161008128E-14   0.00000000000000E+00   2.68765625786692E-16  -2.05449171214759E-23
      7.82459927068927E-11   7.82462614724979E-11  -1.29065338308999E-18  -1.24174447966486E-02  -1.24174447966728E-02
      0.00000000000000E+00   0.00000000000000E+00   2.42365238015440E-11   0.00000000000000E+00   2.42365238015440E-11
      5.27935493251171E-18  -3.41634149615530E-01  -3.41601864242748E-01   0.00000000000000E+00  -3.03121663749167E-13
     -1.25128395432779E-22  -1.02179663610167E-10  -1.02482785274041E-10  -3.98870154942171E-18
      2.66058924687077E-07
      0.00000000000000E+00  -8.67014319239053E-14   0.00000000000000E+00   3.42311357507977E-16  -8.41118855369965E-24
      8.66693044557489E-11   8.66696467670980E-11  -1.29090982536239E-18  -1.20289554762351E-02  -1.20289554762540E-02
      0.00000000000000E+00   0.00000000000000E+00   1.89035620246114E-11   0.00000000000000E+00   1.89035620246114E-11
      5.31716205656093E-18  -3.56105224295551E-01  -3.56071965549681E-01   0.00000000000000E+00  -2.90023011333963E-13
     -1.26467771418964E-22  -1.05283185780249E-10  -1.05573208791709E-10  -4.02625223119854E-18
      2.68058924687077E-07
      0.00000000000000E+00  -9.63451293306956E-14   0.00000000000000E+00   4.15127411384574E-16   7.38573318660391E-24
      9.63020700519790E-11   9.63024851793978E-11  -1.28847309174821E-18  -1.26339617913354E-02  -1.26339617913504E-02
      0.00000000000000E+00   0.00000000000000E+00   1.49866837570556E-11   0.00000000000000E+00   1.49866837570556E-11
      5.34713542407504E-18  -3.70326350868337E-01  -3.70291291635241E-01   0.00000000000000E+00  -2.80698395974151E-13
     -1.27747794907320E-22  -1.11008470540351E-10  -1.11289168936453E-10  -4.05866233232683E-18
      2.70058924687077E-07
      0.00000000000000E+00  -1.09111547802542E-13   0.00000000000000E+00   5.64965470910432E-16   2.64849880554242E-23
      1.09116415521461E-10   1.09116980486958E-10  -1.28314620938624E-18  -1.44107045532569E-02  -1.44107045532681E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11897997281041E-11   0.00000000000000E+00   1.11897997281041E-11
      5.36951502353125E-18  -3.84280400161358E-01  -3.84242500359479E-01   0.00000000000000E+00  -2.61036705917386E-13
     -1.28923066795888E-22  -1.20045743509017E-10  -1.20306780215063E-10  -4.08636881414501E-18
      2.72058924687077E-07
      0.00000000000000E+00  -1.29592924199820E-13   0.00000000000000E+00   8.95023634759067E-16   5.01199237950311E-23
      1.29557173540553E-10   1.29558068564238E-10  -1.27336736221350E-18  -1.81008420385632E-02  -1.81008420385694E-02
      0.00000000000000E+00   0.00000000000000E+00   6.22289629934135E-12   0.00000000000000E+00   6.22289629934135E-12
      5.38196081612993E-18  -3.97942460883641E-01  -3.97899686577066E-01   0.00000000000000E+00  -2.16258233232167E-13
     -1.29883974231362E-22  -1.35564706630216E-10  -1.35780964863579E-10  -4.10859345391642E-18
      2.74058924687077E-07
      0.00000000000000E+00  -1.67524800666529E-13   0.00000000000000E+00   1.58057214778985E-15   8.15295288285716E-23
      1.67504801600973E-10   1.67506382173202E-10  -1.25594122621764E-18  -2.50864085235725E-02  -2.50864085235711E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.42715550755360E-12   0.00000000000000E+00  -1.42715550755360E-12
      5.37910650511482E-18  -4.11280965106542E-01  -4.11228646420452E-01   0.00000000000000E+00  -1.28972844730007E-13
     -1.30446827302889E-22  -1.65950253820789E-10  -1.66079226665649E-10  -4.12316527889719E-18
      2.76058924687077E-07
      0.00000000000000E+00  -2.42010882541833E-13   0.00000000000000E+00   2.80929615357378E-15   1.23835273144201E-22
      2.41972614018501E-10   2.41975423314778E-10  -1.22733506975718E-18  -3.67318785731044E-02  -3.67318785730921E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.22445531674468E-11   0.00000000000000E+00  -1.22445531674468E-11
      5.35461739877993E-18  -4.24234170513108E-01  -4.24161800392157E-01   0.00000000000000E+00  -3.38567197476525E-15
     -1.30447890177383E-22  -2.29727484475225E-10  -2.29730870147330E-10  -4.12728232902275E-18
      2.78058924687077E-07
      0.00000000000000E+00  -3.81339348885651E-13   0.00000000000000E+00   4.65046668367958E-15   1.72530367895512E-22
      3.81387823418206E-10   3.81392473885062E-10  -1.18758460458878E-18  -5.27412080446388E-02  -5.27412080446153E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.35904163473567E-11   0.00000000000000E+00  -2.35904163473567E-11
      5.30743656608522E-18  -4.36683307135788E-01  -4.36570591839604E-01   0.00000000000000E+00   1.05686891161620E-13
     -1.29962099110157E-22  -3.57907744428738E-10  -3.57802057537706E-10  -4.11985196149644E-18
      2.80058924687077E-07
      0.00000000000000E+00  -6.22707318267031E-13   0.00000000000000E+00   7.20795736324957E-15   2.15683554931099E-22
      6.22699732002465E-10   6.22706939960044E-10  -1.14109132437076E-18  -7.12500360317522E-02  -7.12500360317198E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.23547932281740E-11   0.00000000000000E+00  -3.23547932281740E-11
      5.24272697962887E-18  -4.48434949023554E-01  -4.48248974971203E-01   0.00000000000000E+00   1.54546945100163E-13
     -1.29254130813334E-22  -5.90506693676840E-10  -5.90352146731870E-10  -4.10163565525811E-18
      2.82058924687077E-07
      0.00000000000000E+00  -1.01286376192460E-12   0.00000000000000E+00   1.08199981712390E-14   2.47172289981372E-22
      1.01289342601558E-09   1.01290424601400E-09  -1.09289957778779E-18  -9.05982879108365E-02  -9.05982879107981E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84596327088795E-11   0.00000000000000E+00  -3.84596327088795E-11
      5.16580771421111E-18  -4.59208434834928E-01  -4.58901462092573E-01   0.00000000000000E+00   1.59364736975802E-13
     -1.28515489540930E-22  -9.74603978041970E-10  -9.74444613305123E-10  -4.07290813642332E-18
      2.84058924687077E-07
      0.00000000000000E+00  -1.60810950376659E-12   0.00000000000000E+00   1.57629576471450E-14   2.69309873604608E-22
      1.60806571986642E-09   1.60808148282434E-09  -1.04634265449551E-18  -1.09956192162048E-01  -1.09956192162005E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.34238398295286E-11   0.00000000000000E+00  -4.34238398295286E-11
      5.07896003455205E-18  -4.68622825212271E-01  -4.68129920013636E-01   0.00000000000000E+00   1.50576660836866E-13
     -1.27801276569286E-22  -1.56480821965552E-09  -1.56465764299481E-09  -4.03261738005654E-18
      2.86058924687077E-07
      0.00000000000000E+00  -2.46952129403598E-12   0.00000000000000E+00   2.22281908155973E-14   2.85986565360502E-22
      2.46949056180162E-09   2.46951278999272E-09  -1.00287794914147E-18  -1.29056826499406E-01  -1.29056826499358E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.85675442441439E-11   0.00000000000000E+00  -4.85675442441439E-11
      4.98182494606376E-18  -4.76188331093258E-01  -4.75425672067861E-01   0.00000000000000E+00   1.45552552279717E-13
     -1.27088505668680E-22  -2.42109079830072E-09  -2.42094524574857E-09  -3.97894699692229E-18
      2.88058924687077E-07
      0.00000000000000E+00  -3.65339995664100E-12   0.00000000000000E+00   3.00879353219696E-14   2.99161793209855E-22
      3.65337672692770E-09   3.65340681486332E-09  -9.62809813545555E-19  -1.47827667068673E-01  -1.47827667068619E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43599025102176E-11   0.00000000000000E+00  -5.43599025102176E-11
      4.87310514104333E-18  -4.81316504034364E-01  -4.80182709465671E-01   0.00000000000000E+00   1.50670889510266E-13
     -1.26325601479203E-22  -3.59919758324248E-09  -3.59904691235310E-09  -3.91029532749777E-18
      2.90058924687077E-07
      0.00000000000000E+00  -5.20162669174828E-12   0.00000000000000E+00   3.89888288027636E-14   3.09233296625929E-22
      5.20154588572874E-09   5.20158487455785E-09  -9.25860694137505E-19  -1.66240107835100E-01  -1.66240107835039E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06456544856659E-11   0.00000000000000E+00  -6.06456544856659E-11
      4.75181383207200E-18  -4.83348678621051E-01  -4.81729141501402E-01   0.00000000000000E+00   1.69878325082209E-13
     -1.25442425250030E-22  -5.14110909839714E-09  -5.14093922007219E-09  -3.82595313793449E-18
      2.92058924687077E-07
      0.00000000000000E+00  -7.14138754157124E-12   0.00000000000000E+00   4.85777404277123E-14   3.15960870999034E-22
      7.14136366492239E-09   7.14141224266313E-09  -8.91498754531120E-19  -1.84285458718612E-01  -1.84285458718545E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70217918002343E-11   0.00000000000000E+00  -6.70217918002343E-11
      4.61777024847153E-18  -4.81584593315655E-01  -4.79355956400373E-01   0.00000000000000E+00   2.07357507048208E-13
     -1.24347229505704E-22  -7.07459780836982E-09  -7.07439045086289E-09  -3.72627149394041E-18
      2.94058924687077E-07
      0.00000000000000E+00  -9.49196990092348E-12   0.00000000000000E+00   5.86538601688252E-14   3.18863995596204E-22
      9.49193654116497E-09   9.49199519502545E-09  -8.59152054634919E-19  -2.01965060970442E-01  -2.01965060970369E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30770359509249E-11   0.00000000000000E+00  -7.30770359509249E-11
      4.47161617656968E-18  -4.75298726752572E-01  -4.72331480311876E-01   0.00000000000000E+00   2.65952690653051E-13
     -1.22929416959787E-22  -9.41918411176507E-09  -9.41891815907454E-09  -3.61246412193476E-18
      2.96058924687077E-07
      0.00000000000000E+00  -1.22702732014512E-11   0.00000000000000E+00   6.91650653551093E-14   3.17347723567331E-22
      1.22701922728712E-08   1.22702614379369E-08  -8.28314420971819E-19  -2.19284543761359E-01  -2.19284543761281E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.85419475247202E-11   0.00000000000000E+00  -7.85419475247202E-11
      4.31453228152024E-18  -4.63744600678723E-01  -4.59903811586505E-01   0.00000000000000E+00   3.45363186967281E-13
     -1.21069834090904E-22  -1.21920648535990E-08  -1.21917194904122E-08  -3.48621786054842E-18
      2.98058924687077E-07
      0.00000000000000E+00  -1.54920028932168E-11   0.00000000000000E+00   8.00856876635017E-14   3.10794320646656E-22
      1.54919677989667E-08   1.54920478846547E-08  -7.98576682274609E-19  -2.36251039874110E-01  -2.36251039874027E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.33243412299542E-11   0.00000000000000E+00  -8.33243412299542E-11
      4.14788359906033E-18  -4.46156735161863E-01  -4.41302444213535E-01   0.00000000000000E+00   4.41220437518704E-13
     -1.18654648587649E-22  -1.54091647638621E-08  -1.54087235434247E-08  -3.34930691678572E-18
      3.00058924687077E-07
      0.00000000000000E+00  -1.91671700525760E-11   0.00000000000000E+00   9.12651096618450E-14   2.98779850201400E-22
      1.91671122767657E-08   1.91672035418757E-08  -7.69622422619482E-19  -2.52872031616573E-01  -2.52872031616485E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.74555607356501E-11   0.00000000000000E+00  -8.74555607356501E-11
      3.97297247758903E-18  -4.21762006363175E-01  -4.15751151483051E-01   0.00000000000000E+00   5.45802413106560E-13
     -1.15583825082461E-22  -1.90802937835530E-08  -1.90797479811400E-08  -3.20335005496955E-18
      3.02058924687077E-07
      0.00000000000000E+00  -2.32900803058218E-11   0.00000000000000E+00   1.02336718528544E-13   2.81636766224516E-22
      2.32900229474189E-08   2.32901252841377E-08  -7.41212098294713E-19  -2.69154981177943E-01  -2.69154981177852E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.09994637579778E-11   0.00000000000000E+00  -9.09994637579778E-11
      3.79097355007308E-18  -3.89810467135100E-01  -3.82501759861283E-01   0.00000000000000E+00   6.49553976586164E-13
     -1.11762935631210E-22  -2.31997753743562E-08  -2.31991258203798E-08  -3.04976145177836E-18
      3.04058924687077E-07
      0.00000000000000E+00  -2.78194035212110E-11   0.00000000000000E+00   1.12404005810845E-13   2.61310315326477E-22
      2.78192721573991E-08   2.78193845614052E-08  -7.13176180361256E-19  -2.85107093587597E-01  -2.85107093587503E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.40860042010094E-11   0.00000000000000E+00  -9.40860042010094E-11
      3.60280154167106E-18  -3.49651289066000E-01  -3.40916521497704E-01   0.00000000000000E+00   7.38051203795825E-13
     -1.07075273259475E-22  -2.77260366084079E-08  -2.77252985572042E-08  -2.88962536130980E-18
      3.06058924687077E-07
      0.00000000000000E+00  -3.26075452060510E-11   0.00000000000000E+00   1.18849177939009E-13   2.41006552075794E-22
      3.26074704216403E-08   3.26075892708185E-08  -6.85450588266700E-19  -3.00734335329282E-01  -3.00734335329185E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73229478215720E-11   0.00000000000000E+00  -9.73229478215720E-11
      3.40815564602791E-18  -3.00951743070750E-01  -2.90709327120118E-01   0.00000000000000E+00   7.80107720686524E-13
     -1.01322036080740E-22  -3.25110464307175E-08  -3.25102663229969E-08  -2.72270505776121E-18
      3.08058924687077E-07
      0.00000000000000E+00  -3.72220084928316E-11   0.00000000000000E+00   1.14599235336720E-13   2.20388077440831E-22
      3.72219116574229E-08   3.72220262566585E-08  -6.58161360113474E-19  -3.16039243225332E-01  -3.16039243225230E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02434668877784E-10   0.00000000000000E+00  -1.02434668877784E-10
      3.20328630827234E-18  -2.44232477184463E-01  -2.32537705156079E-01   0.00000000000000E+00   7.31205906954449E-13
     -9.43288079491136E-23  -3.71203227936876E-08  -3.71195915877807E-08  -2.54512494815887E-18
      3.10058924687077E-07
      0.00000000000000E+00  -4.08706325231378E-11   0.00000000000000E+00   9.07217525797438E-14   1.86803013216866E-22
      4.08704954824071E-08   4.08705862041599E-08  -6.31618786483800E-19  -3.31020195203759E-01  -3.31020195203647E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11543291571332E-10   0.00000000000000E+00  -1.11543291571332E-10
      2.98019972512968E-18  -1.81521347191780E-01  -1.68679777096609E-01   0.00000000000000E+00   5.88405565808536E-13
     -8.69271654551052E-23  -4.07596313181542E-08  -4.07590429125885E-08  -2.34858093864588E-18
      3.12058924687077E-07
      0.00000000000000E+00  -4.27495003121922E-11   0.00000000000000E+00   3.94678772602542E-13   1.31345519476583E-22
      4.27494673438434E-08   4.27498620226161E-08  -6.05897743220456E-19  -3.45682153401430E-01  -3.45682153401309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21317058075090E-10   0.00000000000000E+00  -1.21317058075090E-10
      2.73756560897950E-18  -1.16364157121322E-01  -1.02933566111344E-01   0.00000000000000E+00   9.14398291639030E-14
     -7.95659971514442E-23  -4.26286364043702E-08  -4.26285449645411E-08  -2.13166786575904E-18
      3.14058924687077E-07
      0.00000000000000E+00  -3.87843793174688E-11   0.00000000000000E+00  -9.79158571027296E-14   6.57998027732472E-23
      3.87844292160630E-08   3.87843313002060E-08  -5.79711126013419E-19  -3.60052007397211E-01  -3.60052007397090E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20511376393535E-10   0.00000000000000E+00  -1.20511376393535E-10
      2.49654285619243E-18  -6.01897737839962E-02  -4.80081348782373E-02   0.00000000000000E+00   4.05734093319328E-13
     -5.38059701836573E-23  -3.86642256579057E-08  -3.86638199238124E-08  -1.91683173017901E-18
      3.16058924687077E-07
      0.00000000000000E+00  -2.66916419930398E-11   0.00000000000000E+00  -2.98767061015150E-13   2.61669148452891E-23
      2.66919533490896E-08   2.66916545820286E-08  -5.48881099441167E-19  -3.74190094834062E-01  -3.74190094833970E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.17676506480920E-11   0.00000000000000E+00  -9.17676506480920E-11
      2.31300755489625E-18  -2.86526246018695E-02  -2.02718894813059E-02   0.00000000000000E+00   4.42431902763944E-13
     -2.39826224248803E-23  -2.66003293632832E-08  -2.65998869313805E-08  -1.76412645545508E-18
      3.18058924687077E-07
      0.00000000000000E+00  -1.75716432778068E-11   0.00000000000000E+00  -2.24885270064487E-13   1.19303087230363E-23
      1.75718682669676E-08   1.75716433816975E-08  -5.15233683258521E-19  -3.88094353923199E-01  -3.88094353923133E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63586307171166E-11   0.00000000000000E+00  -6.63586307171166E-11
      2.18029029346201E-18  -1.54782194713696E-02  -9.96288073624244E-03   0.00000000000000E+00   2.94290958540877E-13
     -1.19489157522037E-23  -1.75055790419389E-08  -1.75052847509804E-08  -1.66505661020349E-18
      3.20058924687077E-07
      0.00000000000000E+00  -1.35024621958273E-11   0.00000000000000E+00  -1.00077202053707E-13   7.08144322712092E-24
      1.35025193631151E-08   1.35024192859131E-08  -4.81352874416968E-19  -4.01739907744131E-01  -4.01739907744075E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59681271889926E-11   0.00000000000000E+00  -5.59681271889926E-11
      2.06835403908403E-18  -1.04733303843033E-02  -6.23679216171526E-03   0.00000000000000E+00   1.44081362717667E-13
     -7.64365097086689E-24  -1.34465952400868E-08  -1.34464511587241E-08  -1.58700116466706E-18
      3.22058924687077E-07
      0.00000000000000E+00  -1.20041071530237E-11   0.00000000000000E+00  -3.66515049015634E-14   5.26853340511633E-24
      1.20041798916823E-08   1.20041432401774E-08  -4.48008068764903E-19  -4.15117312134218E-01  -4.15117312134165E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29640779931362E-11   0.00000000000000E+00  -5.29640779931362E-11
      1.96242588309776E-18  -8.47373392430384E-03  -4.70830420876081E-03   0.00000000000000E+00   7.10115470104154E-14
     -5.61594755993066E-24  -1.19512501737313E-08  -1.19511791621843E-08  -1.51441781433285E-18
      3.24058924687077E-07
      0.00000000000000E+00  -1.14805921509408E-11   0.00000000000000E+00   2.57658213504623E-15   4.21347605517983E-24
      1.14806040313772E-08   1.14806066079594E-08  -4.15415278479769E-19  -4.28226616607970E-01  -4.28226616607917E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25833196410639E-11   0.00000000000000E+00  -5.25833196410639E-11
      1.85725924381563E-18  -7.52511645288190E-03  -3.92451874141917E-03   0.00000000000000E+00   2.63852109172827E-14
     -4.83007977837398E-24  -1.14280496735292E-08  -1.14280232883183E-08  -1.44184396533586E-18
      3.26058924687077E-07
      0.00000000000000E+00  -1.12857894633237E-11   0.00000000000000E+00  -4.54754015831439E-15   3.62364235536247E-24
      1.12857881778780E-08   1.12857836303379E-08  -3.83679446474484E-19  -4.41071354715623E-01  -4.41071354715570E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30231499756591E-11   0.00000000000000E+00  -5.30231499756591E-11
      1.75121294386431E-18  -6.96914391325515E-03  -3.43006030110288E-03   0.00000000000000E+00   3.08881748894649E-14
     -4.18199453902756E-24  -1.12327913685371E-08  -1.12327604803622E-08  -1.36753349738982E-18
      3.28058924687077E-07
      0.00000000000000E+00  -1.11996390998230E-11   0.00000000000000E+00  -1.89041406622399E-15   3.28356412582667E-24
      1.11995741334087E-08   1.11995722429946E-08  -3.52871065806776E-19  -4.53656091971839E-01  -4.53656091971785E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36710696455813E-11   0.00000000000000E+00  -5.36710696455813E-11
      1.64387080457315E-18  -6.58847522422832E-03  -3.07675639410188E-03   0.00000000000000E+00   2.57146797010578E-14
     -3.52710024061403E-24  -1.11459268880288E-08  -1.11459011733491E-08  -1.29099973876637E-18
      3.30058924687077E-07
      0.00000000000000E+00  -1.11523390601611E-11   0.00000000000000E+00  -9.46952750486772E-16   2.89898384346257E-24
      1.11523716089339E-08   1.11523706619811E-08  -3.23034510481927E-19  -4.65985493989044E-01  -4.65985493988990E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43169351971672E-11   0.00000000000000E+00  -5.43169351971672E-11
      1.53523693417881E-18  -6.30492970292263E-03  -2.80828446479534E-03   0.00000000000000E+00   2.26613851462726E-14
     -3.32041115520633E-24  -1.10980763881691E-08  -1.10980537267840E-08  -1.21220242369688E-18
      3.32058924687077E-07
      0.00000000000000E+00  -1.11220302968827E-11   0.00000000000000E+00  -5.47589642288010E-16   2.65773669194887E-24
      1.11220341791284E-08   1.11220336315387E-08  -2.94191286480512E-19  -4.78063738483737E-01  -4.78063738483682E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.48807933755312E-11   0.00000000000000E+00  -5.48807933755312E-11
      1.42547534742775E-18  -6.08450751610147E-03  -2.59759671035383E-03   0.00000000000000E+00   2.04504874558858E-14
     -3.01473122760276E-24  -1.10671732886506E-08  -1.10671528381632E-08  -1.13128406094724E-18
      3.34058924687077E-07
      0.00000000000000E+00  -1.11007223178505E-11   0.00000000000000E+00  -3.40441407467020E-16   2.46524150664371E-24
      1.11006932036347E-08   1.11006928631933E-08  -2.66346503221304E-19  -4.89893398096650E-01  -4.89893398096594E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53238190261492E-11   0.00000000000000E+00  -5.53238190261492E-11
      1.31482770937545E-18  -5.90885075781252E-03  -2.42880201666252E-03   0.00000000000000E+00   1.86695298435477E-14
     -2.76458456493234E-24  -1.10453877136970E-08  -1.10453690441672E-08  -1.04848120615415E-18
      3.36058924687077E-07
      0.00000000000000E+00  -1.10849250230508E-11   0.00000000000000E+00  -2.16943803365725E-16   2.30839663317373E-24
      1.10848952574095E-08   1.10848950404657E-08  -2.39502279812865E-19  -5.01471526547711E-01  -5.01471526547656E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56067397557163E-11   0.00000000000000E+00  -5.56067397557163E-11
      1.20361422986402E-18  -5.76641066140383E-03  -2.29142725545201E-03   0.00000000000000E+00   1.71616854965473E-14
     -2.55756388606709E-24  -1.10293054623955E-08  -1.10292883007100E-08  -9.64111950051153E-19
      3.38058924687077E-07
      0.00000000000000E+00  -1.10726178282650E-11   0.00000000000000E+00  -1.41417708061386E-16   2.17858176287525E-24
      1.10726496960348E-08   1.10726495546171E-08  -2.13695899989425E-19  -5.12774317819754E-01  -5.12774317819699E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56208997222685E-11   0.00000000000000E+00  -5.56208997222685E-11
      1.09237243041948E-18  -5.64938932686831E-03  -2.17826744139876E-03   0.00000000000000E+00   1.58314398937252E-14
     -2.38471488251059E-24  -1.10170444863347E-08  -1.10170286548948E-08  -8.78676530430056E-19
      3.40058924687077E-07
      0.00000000000000E+00  -1.10624230624350E-11   0.00000000000000E+00  -1.04274812237610E-16   2.07012870749319E-24
      1.10623906860185E-08   1.10623905817437E-08  -1.89081016597355E-19  -5.23720793860246E-01  -5.23720793860191E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50683834056280E-11   0.00000000000000E+00  -5.50683834056280E-11
      9.82235663608225E-19  -5.55250962187070E-03  -2.08444494124053E-03   0.00000000000000E+00   1.45705738635756E-14
     -2.23992568125954E-24  -1.10073367689119E-08  -1.10073221983381E-08  -7.93154647010871E-19
      3.42058924687077E-07
      0.00000000000000E+00  -1.10528712097654E-11   0.00000000000000E+00  -9.90424306948507E-17   1.97939233274572E-24
      1.10528552613313E-08   1.10528551622889E-08  -1.65953477904174E-19  -5.34158393172870E-01  -5.34158393172816E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.35546442016178E-11   0.00000000000000E+00  -5.35546442016178E-11
      8.75126375204990E-19  -5.47221383095335E-03  -2.00667573186134E-03   0.00000000000000E+00   1.32752576835428E-14
     -2.11906079714332E-24  -1.09993137933450E-08  -1.09993005180873E-08  -7.09172897300815E-19
      3.44058924687077E-07
      0.00000000000000E+00  -1.10431356676214E-11   0.00000000000000E+00  -1.05942538787931E-16   1.90401003296738E-24
      1.10431117205358E-08   1.10431116145932E-08  -1.44726274923662E-19  -5.43871499370378E-01  -5.43871499370327E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.07083966473108E-11   0.00000000000000E+00  -5.07083966473108E-11
      7.73709581910368E-19  -5.40606617029966E-03  -1.94270061689351E-03   0.00000000000000E+00   1.18597238100282E-14
     -2.01924706071993E-24  -1.09924150776697E-08  -1.09924032179459E-08  -6.28983306986706E-19
      3.46058924687077E-07
      0.00000000000000E+00  -1.10322979886309E-11   0.00000000000000E+00  -1.61258555879792E-16   1.84256465993447E-24
      1.10322792710861E-08   1.10322791098275E-08  -1.25962102204192E-19  -5.52565131516944E-01  -5.52565131516898E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.60633187609853E-11   0.00000000000000E+00  -4.60633187609853E-11
      6.81582944388398E-19  -5.35249298712660E-03  -1.89107634372646E-03   0.00000000000000E+00   1.02748233049594E-14
     -1.93876000680035E-24  -1.09862260658898E-08  -1.09862157910665E-08  -5.55620842184206E-19
      3.48058924687077E-07
      0.00000000000000E+00  -1.10193478806846E-11   0.00000000000000E+00  -2.32042131647515E-16   1.79451152611266E-24
      1.10193721702395E-08   1.10193719381974E-08  -1.10430507231975E-19  -5.59837850596364E-01  -5.59837850596325E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.90043601741505E-11   0.00000000000000E+00  -3.90043601741505E-11
      6.03574224040097E-19  -5.31071434210635E-03  -1.85113983205464E-03   0.00000000000000E+00   8.37738777480163E-15
     -1.87704653097539E-24  -1.09803759554110E-08  -1.09803675780233E-08  -4.93143716808122E-19
      3.50058924687077E-07
      0.00000000000000E+00  -1.10032750516733E-11   0.00000000000000E+00  -3.33968667401670E-16   1.76013744299051E-24
      1.10033138964198E-08   1.10033135624512E-08  -9.91277649350489E-20  -5.65173981405568E-01  -5.65173981405539E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88818063589221E-11   0.00000000000000E+00  -2.88818063589221E-11
      5.45810611322253E-19  -5.28068715438527E-03  -1.82298249461295E-03   0.00000000000000E+00   6.05996432762819E-15
     -1.83470636462360E-24  -1.09744378160566E-08  -1.09744317560922E-08  -4.46682846387204E-19
      3.52058924687077E-07
      0.00000000000000E+00  -1.09831610542249E-11   0.00000000000000E+00  -4.65300093145984E-16   1.74059045006485E-24
      1.09831469875013E-08   1.09831465222012E-08  -9.32542927766930E-20  -5.67960875143728E-01  -5.67960875143713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51748446300980E-11   0.00000000000000E+00  -1.51748446300980E-11
      5.15460922062057E-19  -5.26316983851333E-03  -1.80750037802868E-03   0.00000000000000E+00   3.20829808907888E-15
     -1.81359969797308E-24  -1.09679748858692E-08  -1.09679716775711E-08  -4.22206629285363E-19
      3.54058924687077E-07
      0.00000000000000E+00  -1.09580874409672E-11   0.00000000000000E+00  -4.94945392282621E-16   1.73806730663769E-24
      1.09580906261043E-08   1.09580901311589E-08  -9.41791266810256E-20  -5.67519844734953E-01  -5.67519844734955E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39146209091946E-12   0.00000000000000E+00   2.39146209091946E-12
      5.20243846243896E-19  -5.25991200197305E-03  -1.80660249873340E-03   0.00000000000000E+00  -4.20224278894773E-16
     -1.81727435734952E-24  -1.09604811730256E-08  -1.09604815932499E-08  -4.26064719562871E-19
      3.56058924687077E-07
      0.00000000000000E+00  -1.09274112987399E-11   0.00000000000000E+00  -8.07630572272140E-16   1.75633262467649E-24
      1.09273853115874E-08   1.09273845039568E-08  -1.03429508061419E-19  -5.63134247559403E-01  -5.63134247559427E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38087016270491E-11   0.00000000000000E+00   2.38087016270491E-11
      5.67861249497994E-19  -5.27414224469332E-03  -1.82375944993636E-03   0.00000000000000E+00  -4.58012218430194E-15
     -1.85204882728663E-24  -1.09511886254617E-08  -1.09511932055839E-08  -4.64431741436575E-19
      3.58058924687077E-07
      0.00000000000000E+00  -1.08899386459592E-11   0.00000000000000E+00  -7.41545189958837E-16   1.80187601865400E-24
      1.08899243827537E-08   1.08899236412085E-08  -1.22734523255863E-19  -5.54063138673871E-01  -5.54063138673920E-01
      0.00000000000000E+00   0.00000000000000E+00   4.87921318456199E-11   0.00000000000000E+00   4.87921318456199E-11
      6.65445513189233E-19  -5.31175022870383E-03  -1.86529934403609E-03   0.00000000000000E+00  -1.01577413530555E-14
     -1.92949213160167E-24  -1.09387056153128E-08  -1.09387157730541E-08  -5.42710989933370E-19
      3.60058924687077E-07
      0.00000000000000E+00  -1.08434652089322E-11   0.00000000000000E+00  -1.32240280696254E-15   1.88632932660364E-24
      1.08435001311465E-08   1.08434988087437E-08  -1.54127719721099E-19  -5.39542826689608E-01  -5.39542826689685E-01
      0.00000000000000E+00   0.00000000000000E+00   7.67292131825802E-11   0.00000000000000E+00   7.67292131825802E-11
      8.18903939554394E-19  -5.38402364391655E-03  -1.94339846981185E-03   0.00000000000000E+00  -1.65281408012924E-14
     -2.07221581487732E-24  -1.09202114937854E-08  -1.09202280219262E-08  -6.64776219833295E-19
      3.62058924687077E-07
      0.00000000000000E+00  -1.07830313718497E-11   0.00000000000000E+00  -1.79018510584582E-15   2.03159504691638E-24
      1.07829818576256E-08   1.07829800674405E-08  -2.00088495392676E-19  -5.18790457414969E-01  -5.18790457415076E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06465535067270E-10   0.00000000000000E+00   1.06465535067270E-10
      1.03183500968893E-18  -5.51431143066654E-03  -2.08338637631705E-03   0.00000000000000E+00  -2.51794629685253E-14
     -2.32895600249359E-24  -1.08894204230448E-08  -1.08894456025078E-08  -8.31746514296258E-19
      3.64058924687077E-07
      0.00000000000000E+00  -1.06947685793932E-11   0.00000000000000E+00  -3.97863949240045E-13   2.28082412550629E-24
      1.06948307746217E-08   1.06944329106724E-08  -2.63654428221974E-19  -4.91026676881266E-01  -4.91026676881402E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35896028349595E-10   0.00000000000000E+00   1.35896028349595E-10
      1.30362706638812E-18  -5.75607237729355E-03  -2.34365127803806E-03   0.00000000000000E+00   3.58225563812170E-13
     -2.82091936726648E-24  -1.08306871645858E-08  -1.08303289390220E-08  -1.03997263816615E-18
      3.66058924687077E-07
      0.00000000000000E+00  -1.05376222340312E-11   0.00000000000000E+00  -9.46215387380461E-15   2.71818572735717E-24
      1.05375728796209E-08   1.05375634174671E-08  -3.48255380589104E-19  -4.55526112554709E-01  -4.55526112554871E-01
      0.00000000000000E+00   0.00000000000000E+00   1.61583172088255E-10   0.00000000000000E+00   1.61583172088255E-10
      1.62679341056463E-18  -6.24946822987627E-03  -2.87850561511848E-03   0.00000000000000E+00  -4.92027880478354E-14
     -3.91561403945389E-24  -1.06990973867673E-08  -1.06991465895553E-08  -1.27853802997553E-18
      3.68058924687077E-07
      0.00000000000000E+00  -1.01647326009686E-11   0.00000000000000E+00  -2.57174382731600E-14   3.44842278845006E-24
      1.01647076665983E-08   1.01646819491601E-08  -4.56447372451678E-19  -4.11682558164445E-01  -4.11682558164625E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79567979778910E-10   0.00000000000000E+00   1.79567979778910E-10
      1.98592937012245E-18  -7.42588394094284E-03  -4.16674096089753E-03   0.00000000000000E+00  -6.43583238928241E-14
     -7.01470894823630E-24  -1.03441855706151E-08  -1.03442499289390E-08  -1.52948199767077E-18
      3.70058924687077E-07
      0.00000000000000E+00  -9.03485864384161E-12   0.00000000000000E+00  -2.92159877310763E-14   3.93565918300840E-24
      9.03486090930419E-09   9.03483169331646E-09  -5.85877246160387E-19  -3.59096108748168E-01  -3.59096108748359E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91031787980176E-10   0.00000000000000E+00   1.91031787980176E-10
      2.36799294608281E-18  -1.07636517744991E-02  -7.85689044614975E-03   0.00000000000000E+00  -1.17421849472392E-13
     -1.79163610611253E-23  -9.22574605944715E-09  -9.22586348129664E-09  -1.78211569992242E-18
      3.72058924687077E-07
      0.00000000000000E+00  -5.97789841062629E-12   0.00000000000000E+00  -7.87356226708767E-14  -1.23429694731144E-24
      5.97794795011876E-09   5.97786921449609E-09  -7.25211939832591E-19  -2.97887791188415E-01  -2.97887791188626E-01
      0.00000000000000E+00   0.00000000000000E+00   2.11427977015075E-10   0.00000000000000E+00   2.11427977015075E-10
      2.79084890011295E-18  -1.99675256909358E-02  -1.80174947044847E-02   0.00000000000000E+00  -1.69560783817786E-13
     -4.83350346421033E-23  -6.18912763072729E-09  -6.18929719151116E-09  -2.06563696028036E-18
      3.74058924687077E-07
      0.00000000000000E+00  -2.19766087190170E-12   0.00000000000000E+00  -9.59744847559300E-14  -1.96439569508556E-23
      2.19779935638468E-09   2.19770338189991E-09  -8.66471700139486E-19  -2.29549537958036E-01  -2.29549537958273E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37338192519944E-10   0.00000000000000E+00   2.37338192519944E-10
      3.26552528515284E-18  -3.63221534614194E-02  -3.55549629497689E-02   0.00000000000000E+00  -2.99834694795338E-13
     -7.78691554940834E-23  -2.43474173972498E-09  -2.43504157441985E-09  -2.39905358501336E-18
      3.76058924687077E-07
      0.00000000000000E+00  -4.56100964972578E-13   0.00000000000000E+00  -4.66895369441809E-14  -3.68966140839755E-23
      4.56177181348016E-10   4.56130491811034E-10  -1.01171988836276E-18  -1.57434720187559E-01  -1.57434720187800E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41317692281906E-10   0.00000000000000E+00   2.41317692281906E-10
      3.74816066971666E-18  -5.57444389351472E-02  -5.55247008223063E-02   0.00000000000000E+00  -5.27519494961713E-13
     -8.83460374363385E-23  -6.96920664597890E-10  -6.97448184092941E-10  -2.73644078135389E-18
      3.78058924687077E-07
      0.00000000000000E+00  -2.25019606158441E-14   0.00000000000000E+00  -1.51423058768434E-14  -4.39955502315227E-23
      2.25272217277417E-11   2.25120794218208E-11  -1.15258647168819E-18  -8.81521683958515E-02  -8.81521683960700E-02
      0.00000000000000E+00   0.00000000000000E+00   2.18556594573377E-10   0.00000000000000E+00   2.18556594573377E-10
      4.18527385886341E-18  -7.56703463375499E-02  -7.55943954446043E-02   0.00000000000000E+00  -7.53122577114181E-13
     -9.54379685500505E-23  -2.40315551417989E-10  -2.41068673995198E-10  -3.03268738717522E-18
      3.80058924687077E-07
      0.00000000000000E+00   2.65431290529752E-14   0.00000000000000E+00  -4.59519058864978E-15  -4.61994291053545E-23
     -2.65411390717305E-11  -2.65457342623654E-11  -1.24917980621249E-18  -4.10895027696988E-02  -4.10895027698563E-02
      0.00000000000000E+00   0.00000000000000E+00   1.57570126080848E-10   0.00000000000000E+00   1.57570126080848E-10
      4.50041411102511E-18  -9.54128745332284E-02  -9.53715941710853E-02   0.00000000000000E+00  -7.10792216650157E-13
     -1.01194204962560E-22  -1.30313599601731E-10  -1.31024391818483E-10  -3.25123430481262E-18
      3.82058924687077E-07
      0.00000000000000E+00   7.89864739984730E-15   0.00000000000000E+00  -7.81904394198737E-16  -4.59996843501772E-23
     -7.85590735301922E-12  -7.85668925745941E-12  -1.29486866613439E-18  -1.99343370326314E-02  -1.99343370327273E-02
      0.00000000000000E+00   0.00000000000000E+00   9.59101434801037E-11   0.00000000000000E+00   9.59101434801037E-11
      4.69223439798531E-18  -1.14843259037311E-01  -1.14815517242320E-01   0.00000000000000E+00  -4.66014286892085E-13
     -1.04425345447689E-22  -8.75874399356483E-11  -8.80534542226449E-11  -3.39736573185092E-18
      3.84058924687077E-07
      0.00000000000000E+00  -1.00110763556204E-14   0.00000000000000E+00   3.21535235886217E-16  -4.56585220369700E-23
      1.00084720010769E-11   1.00087935362671E-11  -1.31333473870698E-18  -1.19710360778701E-02  -1.19710360779308E-02
      0.00000000000000E+00   0.00000000000000E+00   6.07346588245668E-11   0.00000000000000E+00   6.07346588245668E-11
      4.81370371563445E-18  -1.33915710434972E-01  -1.33893422448099E-01   0.00000000000000E+00  -3.21449791493582E-13
     -1.06463569798433E-22  -7.04220025692334E-11  -7.07434523608334E-11  -3.50036897692747E-18
      3.86058924687077E-07
      0.00000000000000E+00  -2.21345816670139E-14   0.00000000000000E+00   5.00023215979778E-16  -4.46424166990745E-23
      2.21891171851193E-11   2.21896172082907E-11  -1.32004233474948E-18  -9.00805285357739E-03  -9.00805285362020E-03
      0.00000000000000E+00   0.00000000000000E+00   4.28056884387288E-11   0.00000000000000E+00   4.28056884387288E-11
      4.89931509251190E-18  -1.52613188825108E-01  -1.52592711945841E-01   0.00000000000000E+00  -2.76330456082395E-13
     -1.08126328195500E-22  -6.47189751908292E-11  -6.49953056470197E-11  -3.57927275776243E-18
      3.88058924687077E-07
      0.00000000000000E+00  -3.08598317017290E-14   0.00000000000000E+00   4.36861429684080E-16  -4.26350695419875E-23
      3.08381823690024E-11   3.08386192303894E-11  -1.32185603508553E-18  -7.75619392451428E-03  -7.75619392454736E-03
      0.00000000000000E+00   0.00000000000000E+00   3.30823604619536E-11   0.00000000000000E+00   3.30823604619536E-11
      4.96547981343581E-18  -1.70933317055197E-01  -1.70913178752451E-01   0.00000000000000E+00  -2.71960035317490E-13
     -1.09700244366692E-22  -6.36490196569156E-11  -6.39209796923428E-11  -3.64362377835029E-18
      3.90058924687077E-07
      0.00000000000000E+00  -3.74726527806709E-14   0.00000000000000E+00   3.43343789818378E-16  -3.92272350161372E-23
      3.74712786607420E-11   3.74716220044926E-11  -1.32159539270471E-18  -7.09785741998908E-03  -7.09785742001631E-03
      0.00000000000000E+00   0.00000000000000E+00   2.72272670519852E-11   0.00000000000000E+00   2.72272670519852E-11
      5.01993434753978E-18  -1.88880278737117E-01  -1.88859895457989E-01   0.00000000000000E+00  -2.78664658810817E-13
     -1.11260222669825E-22  -6.44202243975556E-11  -6.46988890564777E-11  -3.69833895483507E-18
      3.92058924687077E-07
      0.00000000000000E+00  -4.28914922759150E-14   0.00000000000000E+00   2.69476817249180E-16  -3.39928817870089E-23
      4.29135348236073E-11   4.29138043003905E-11  -1.32044402805487E-18  -6.67521977576383E-03  -6.67521977578722E-03
      0.00000000000000E+00   0.00000000000000E+00   2.33886363367163E-11   0.00000000000000E+00   2.33886363367163E-11
      5.06671162021322E-18  -2.06460905407790E-01  -2.06440017039968E-01   0.00000000000000E+00  -2.86338708935728E-13
     -1.12817012649780E-22  -6.60161019280577E-11  -6.63024406371062E-11  -3.74626759215834E-18
      3.94058924687077E-07
      0.00000000000000E+00  -4.76674186107064E-14   0.00000000000000E+00   2.19399006133700E-16  -2.65647686251164E-23
      4.76356158130162E-11   4.76358352119958E-11  -1.31892675517234E-18  -6.36951368943936E-03  -6.36951368946010E-03
      0.00000000000000E+00   0.00000000000000E+00   2.07329742100514E-11   0.00000000000000E+00   2.07329742100514E-11
      5.10817756863332E-18  -2.23682844413553E-01  -2.23661305156914E-01   0.00000000000000E+00  -2.92442750287386E-13
     -1.14366587886987E-22  -6.80763666716460E-11  -6.83688094220478E-11  -3.78925081346098E-18
      3.96058924687077E-07
      0.00000000000000E+00  -5.18922765222526E-14   0.00000000000000E+00   1.87302624336553E-16  -1.67484495332128E-23
      5.19203682427272E-11   5.19205555453348E-11  -1.31728589521200E-18  -6.13490222181876E-03  -6.13490222183759E-03
      0.00000000000000E+00   0.00000000000000E+00   1.88309882280031E-11   0.00000000000000E+00   1.88309882280031E-11
      5.14583954508932E-18  -2.40553647515469E-01  -2.40531357711206E-01   0.00000000000000E+00  -2.96797211077655E-13
     -1.15903743832697E-22  -7.04547465621447E-11  -7.07515437733382E-11  -3.82855364987732E-18
      3.98058924687077E-07
      0.00000000000000E+00  -5.59334449593838E-14   0.00000000000000E+00   1.66909453895999E-16  -4.64900038900753E-24
      5.59379550780770E-11   5.59381219875263E-11  -1.31563311094066E-18  -5.94916834271796E-03  -5.94916834273538E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74297979224122E-11   0.00000000000000E+00   1.74297979224122E-11
      5.18069914093415E-18  -2.57080412743201E-01  -2.57057298795272E-01   0.00000000000000E+00  -2.99823878120406E-13
     -1.17425070482867E-22  -7.30680960317004E-11  -7.33679199099383E-11  -3.86506602999350E-18
      4.00058924687077E-07
      0.00000000000000E+00  -5.97909239220999E-14   0.00000000000000E+00   1.53960597596686E-16   9.08342999025036E-24
      5.97891139081722E-11   5.97892678687789E-11  -1.31401671541820E-18  -5.79916815795715E-03  -5.79916815797352E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63671810255025E-11   0.00000000000000E+00   1.63671810255025E-11
      5.21343350298515E-18  -2.73269989337033E-01  -2.73245997021375E-01   0.00000000000000E+00  -3.02030907130513E-13
     -1.18929320267078E-22  -7.58544179870315E-11  -7.61564488942809E-11  -3.89941678756695E-18
      4.02058924687077E-07
      0.00000000000000E+00  -6.35565581476085E-14   0.00000000000000E+00   1.45501620656949E-16   2.31827962370805E-23
      6.35350707153581E-11   6.35352162170019E-11  -1.31245414536505E-18  -5.67617166724193E-03  -5.67617166725747E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55349450269564E-11   0.00000000000000E+00   1.55349450269564E-11
      5.24450339303906E-18  -2.89129613073366E-01  -2.89104702962783E-01   0.00000000000000E+00  -3.03880902471809E-13
     -1.20416941992961E-22  -7.87662803413668E-11  -7.90701612439590E-11  -3.93204924767401E-18
      4.04058924687077E-07
      0.00000000000000E+00  -6.72303476359096E-14   0.00000000000000E+00   1.39895519240064E-16   3.69077924468273E-23
      6.72153636088324E-11   6.72155035043885E-11  -1.31094830023887E-18  -5.57411898701916E-03  -5.57411898703402E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48590665211459E-11   0.00000000000000E+00   1.48590665211459E-11
      5.27422152608136E-18  -3.04666572829071E-01  -3.04640716360717E-01   0.00000000000000E+00  -3.05739829257556E-13
     -1.21889722827667E-22  -8.17688301961544E-11  -8.20745700255338E-11  -3.96327322584249E-18
      4.06058924687077E-07
      0.00000000000000E+00  -7.08122923870031E-14   0.00000000000000E+00   1.36103917883272E-16   4.96727581072858E-23
      7.08560828230686E-11   7.08562189270362E-11  -1.30949583675510E-18  -5.48887559252661E-03  -5.48887559254090E-03
      0.00000000000000E+00   0.00000000000000E+00   1.42857871541588E-11   0.00000000000000E+00   1.42857871541588E-11
      5.30279310038968E-18  -3.19884832762191E-01  -3.19858010089998E-01   0.00000000000000E+00  -3.07800732677618E-13
     -1.23350010119243E-22  -8.48342053483943E-11  -8.51420060811953E-11  -3.99329726363457E-18
      4.08058924687077E-07
      0.00000000000000E+00  -7.44860818753042E-14   0.00000000000000E+00   1.33424023285372E-16   6.10796468808847E-23
      7.44730729436895E-11   7.44732063677739E-11  -1.30809160470579E-18  -5.41766658850320E-03  -5.41766658851697E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37747100900334E-11   0.00000000000000E+00   1.37747100900334E-11
      5.33034252056974E-18  -3.34781779405441E-01  -3.34753978418552E-01   0.00000000000000E+00  -3.10089783952449E-13
     -1.24799810720938E-22  -8.79378266737304E-11  -8.82479164578076E-11  -4.02225091586396E-18
      4.10058924687077E-07
      0.00000000000000E+00  -7.80680266263977E-14   0.00000000000000E+00   1.31465293717058E-16   7.09485981630421E-23
      7.80767562934406E-11   7.80768877588053E-11  -1.30673006596162E-18  -5.35859868246416E-03  -5.35859868247746E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33051754919596E-11   0.00000000000000E+00   1.33051754919596E-11
      5.35695287155366E-18  -3.49359043515083E-01  -3.49330255328122E-01   0.00000000000000E+00  -3.12848040935351E-13
     -1.26241977505197E-22  -9.10692152097030E-11  -9.13820632507646E-11  -4.05022280559204E-18
      4.12058924687077E-07
      0.00000000000000E+00  -8.16499713774913E-14   0.00000000000000E+00   1.30207099179209E-16   7.92935492522854E-23
      8.16798791895371E-11   8.16800093967156E-11  -1.30540420971921E-18  -5.31048371146396E-03  -5.31048371147684E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28823448027759E-11   0.00000000000000E+00   1.28823448027759E-11
      5.38271756115922E-18  -3.63645762403434E-01  -3.63615972489553E-01   0.00000000000000E+00  -3.16927551687907E-13
     -1.27682926724877E-22  -9.42454266476764E-11  -9.45623541994920E-11  -4.07731335144000E-18
      4.14058924687077E-07
      0.00000000000000E+00  -8.53237608657924E-14   0.00000000000000E+00   1.29853617971009E-16   8.62633428943341E-23
      8.53015648469229E-11   8.53016947006271E-11  -1.30410454025491E-18  -5.27280814701287E-03  -5.27280814702539E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25245400382943E-11   0.00000000000000E+00   1.25245400382943E-11
      5.40776664123580E-18  -3.77708981821405E-01  -3.77678163857665E-01   0.00000000000000E+00  -3.23530117332246E-13
     -1.29133930548426E-22  -9.75027046214600E-11  -9.78262347389214E-11  -4.10366210098089E-18
      4.16058924687077E-07
      0.00000000000000E+00  -8.89057056168859E-14   0.00000000000000E+00   1.29672751537112E-16   9.20543072950671E-23
      8.89429611363593E-11   8.89430908092029E-11  -1.30282640842968E-18  -5.24569965143706E-03  -5.24569965144923E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21692963040120E-11   0.00000000000000E+00   1.21692963040120E-11
      5.43210523384382E-18  -3.91543016108402E-01  -3.91511163091781E-01   0.00000000000000E+00  -3.30569776839238E-13
     -1.30596199368269E-22  -1.00781817336244E-10  -1.01112387113214E-10  -4.12927882541414E-18
      4.18058924687077E-07
      0.00000000000000E+00  -9.25794951051870E-14   0.00000000000000E+00   1.29463251826560E-16   9.68724782231209E-23
      9.25990311815526E-11   9.25991606449013E-11  -1.30156669958736E-18  -5.23000686654890E-03  -5.23000686656069E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17926575132484E-11   0.00000000000000E+00   1.17926575132484E-11
      5.45569054887032E-18  -4.05119943125955E-01  -4.05087057188175E-01   0.00000000000000E+00  -3.37386191368965E-13
     -1.32067814932253E-22  -1.04054431966650E-10  -1.04391818158151E-10  -4.15412384928297E-18
      4.20058924687077E-07
      0.00000000000000E+00  -9.62532845934880E-14   0.00000000000000E+00   1.29474636523534E-16   1.00913727653670E-22
      9.62709956343690E-11   9.62711251091064E-11  -1.30032030437158E-18  -5.22746862536232E-03  -5.22746862537372E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14030945084534E-11   0.00000000000000E+00   1.14030945084534E-11
      5.47849673788723E-18  -4.18429897242043E-01  -4.18395977461631E-01   0.00000000000000E+00  -3.44491685655543E-13
     -1.33548914093827E-22  -1.07329727931770E-10  -1.07674219617559E-10  -4.17817643351565E-18
      4.22058924687077E-07
      0.00000000000000E+00  -9.99270740817891E-14   0.00000000000000E+00   1.29982265176844E-16   1.04349888885838E-22
      9.99662150607054E-11   9.99663450430749E-11  -1.29907908579334E-18  -5.24114883261506E-03  -5.24114883262606E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10048135201698E-11   0.00000000000000E+00   1.10048135201698E-11
      5.50050636492757E-18  -4.31473017189031E-01  -4.31438059000993E-01   0.00000000000000E+00  -3.52075703813040E-13
     -1.35040145199186E-22  -1.10619082859297E-10  -1.10971158563245E-10  -4.20142727913423E-18
      4.24058924687077E-07
      0.00000000000000E+00  -1.03692708307298E-13   0.00000000000000E+00   1.31432561707740E-16   1.07327077398691E-22
      1.03701768996468E-10   1.03701900429137E-10  -1.29782962728592E-18  -5.27650076192890E-03  -5.27650076193949E-03
      0.00000000000000E+00   0.00000000000000E+00   1.05963918390483E-11   0.00000000000000E+00   1.05963918390483E-11
      5.52169914860566E-18  -4.44252955876136E-01  -4.44216949783888E-01   0.00000000000000E+00  -3.60054080201744E-13
     -1.36541437040279E-22  -1.13938238187846E-10  -1.14298292268185E-10  -4.22386952131975E-18
      4.26058924687077E-07
      0.00000000000000E+00  -1.07550187270014E-13   0.00000000000000E+00   1.34755997654436E-16   1.09974098249255E-22
      1.07514629150285E-10   1.07514763906392E-10  -1.29654773693405E-18  -5.34383875132416E-03  -5.34383875133433E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01705397708703E-11   0.00000000000000E+00   1.01705397708703E-11
      5.54204022814740E-18  -4.56774401022962E-01  -4.56737328180255E-01   0.00000000000000E+00  -3.68147260600972E-13
     -1.38051215716890E-22  -1.17317156416523E-10  -1.17685303677262E-10  -4.24549249121335E-18
      4.28058924687077E-07
      0.00000000000000E+00  -1.11499510969937E-13   0.00000000000000E+00   1.42234147814967E-16   1.12422944139571E-22
      1.11487087266906E-10   1.11487229501166E-10  -1.29518513326523E-18  -5.46432115055736E-03  -5.46432115056707E-03
      0.00000000000000E+00   0.00000000000000E+00   9.70855641849102E-12   0.00000000000000E+00   9.70855641849102E-12
      5.56145734098439E-18  -4.69042210230318E-01  -4.69004031759465E-01   0.00000000000000E+00  -3.75787720395100E-13
     -1.39565362529375E-22  -1.20819998199122E-10  -1.21195785919657E-10  -4.26627220771916E-18
      4.30058924687077E-07
      0.00000000000000E+00  -1.15816213618691E-13   0.00000000000000E+00   1.58594850951576E-16   1.14857991848879E-22
      1.15816842927811E-10   1.15817001522777E-10  -1.29363388043517E-18  -5.68602796846864E-03  -5.68602796847780E-03
      0.00000000000000E+00   0.00000000000000E+00   9.16191054357890E-12   0.00000000000000E+00   9.16191054357890E-12
      5.57978116207154E-18  -4.81060993662681E-01  -4.81021623696408E-01   0.00000000000000E+00  -3.81707683773562E-13
     -1.41074741206275E-22  -1.24597204382441E-10  -1.24978912066356E-10  -4.28614728163638E-18
      4.32058924687077E-07
      0.00000000000000E+00  -1.21051363639520E-13   0.00000000000000E+00   1.99618624966568E-16   1.17662717748109E-22
      1.21042403254434E-10   1.21042602873177E-10  -1.29161657274408E-18  -6.13384812364992E-03  -6.13384812365831E-03
      0.00000000000000E+00   0.00000000000000E+00   8.38992118940350E-12   0.00000000000000E+00   8.38992118940350E-12
      5.59656100445035E-18  -4.92834551241684E-01  -4.92793778592508E-01   0.00000000000000E+00  -3.82507598691471E-13
     -1.42557587864080E-22  -1.29050016463747E-10  -1.29432524062581E-10  -4.30494443170627E-18
      4.34058924687077E-07
      0.00000000000000E+00  -1.28858166302160E-13   0.00000000000000E+00   3.24961040512342E-16   1.21959845130181E-22
      1.28907120111652E-10   1.28907445072814E-10  -1.28828919052479E-18  -7.19018842368728E-03  -7.19018842369420E-03
      0.00000000000000E+00   0.00000000000000E+00   6.91877102560251E-12   0.00000000000000E+00   6.91877102560251E-12
      5.61039854650156E-18  -5.04364161487590E-01  -5.04321375047924E-01   0.00000000000000E+00  -3.67039773897863E-13
     -1.43951773817702E-22  -1.35459176324374E-10  -1.35826216098416E-10  -4.32210935597677E-18
      4.36058924687077E-07
      0.00000000000000E+00  -1.46033132159968E-13   0.00000000000000E+00   7.19034617462049E-16   1.31757927818121E-22
      1.46071030218847E-10   1.46071749253596E-10  -1.28071398866516E-18  -1.01841178609616E-02  -1.01841178609646E-02
      0.00000000000000E+00   0.00000000000000E+00   2.99440520554508E-12   0.00000000000000E+00   2.99440520554508E-12
      5.61638735691265E-18  -5.15641554361375E-01  -5.15594597574509E-01   0.00000000000000E+00  -2.94239914269615E-13
     -1.45048703656850E-22  -1.48771914544726E-10  -1.49066154459141E-10  -4.33567336824749E-18
      4.38058924687077E-07
      0.00000000000000E+00  -1.95537445514824E-13   0.00000000000000E+00   1.98803374180655E-15   1.58321334758207E-22
      1.95497859541308E-10   1.95499847575208E-10  -1.26068767713142E-18  -1.87261282155327E-02  -1.87261282155249E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.81567908417908E-12   0.00000000000000E+00  -7.81567908417908E-12
      5.60075599874429E-18  -5.26622643931358E-01  -5.26563522660072E-01   0.00000000000000E+00  -6.63546064235441E-14
     -1.45291989878062E-22  -1.87617813884460E-10  -1.87684168491029E-10  -4.34006832161286E-18
      4.40058924687077E-07
      0.00000000000000E+00  -3.12823174928836E-13   0.00000000000000E+00   4.21383164489004E-15   2.04526116086577E-22
      3.12844445667995E-10   3.12848659499844E-10  -1.22280246919880E-18  -3.46767325962938E-02  -3.46767325962704E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.34412536386824E-11   0.00000000000000E+00  -2.34412536386824E-11
      5.55387349146692E-18  -5.37190991473985E-01  -5.37099827055283E-01   0.00000000000000E+00   2.32031690525475E-13
     -1.44425572918378E-22  -2.89639437551542E-10  -2.89407405861161E-10  -4.33107102226812E-18
      4.42058924687077E-07
      0.00000000000000E+00  -5.22780244185242E-13   0.00000000000000E+00   6.58346038615494E-15   2.47453538573618E-22
      5.22770200115000E-10   5.22776783575634E-10  -1.17502666989572E-18  -5.40130537537099E-02  -5.40130537536764E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.34817905286265E-11   0.00000000000000E+00  -3.34817905286265E-11
      5.48690991040967E-18  -5.47164437646924E-01  -5.47010306974116E-01   0.00000000000000E+00   3.43940389775315E-13
     -1.43116474583499E-22  -4.89638933436639E-10  -4.89294993047007E-10  -4.31188324051395E-18
      4.44058924687077E-07
      0.00000000000000E+00  -8.61962858692639E-13   0.00000000000000E+00   9.65219325054215E-15   2.76808763253446E-22
      8.61915221599722E-10   8.61924873793250E-10  -1.12492958766061E-18  -7.39487312834623E-02  -7.39487312834234E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.89528691113166E-11   0.00000000000000E+00  -3.89528691113166E-11
      5.40900417218704E-18  -5.56295306765712E-01  -5.56036064190123E-01   0.00000000000000E+00   3.38646066386320E-13
     -1.41796268345063E-22  -8.23310650748178E-10  -8.22972004681933E-10  -4.28407458452643E-18
      4.46058924687077E-07
      0.00000000000000E+00  -1.38382465550581E-12   0.00000000000000E+00   1.40270163358930E-14   2.97503142167752E-22
      1.38379250341814E-09   1.38380653043477E-09  -1.07618479156358E-18  -9.37178607389924E-02  -9.37178607389491E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.32564956928328E-11   0.00000000000000E+00  -4.32564956928328E-11
      5.32249118080137E-18  -5.64243580316967E-01  -5.63821294068241E-01   0.00000000000000E+00   3.09413927561821E-13
     -1.40558973659057E-22  -1.34085944866936E-09  -1.34055003474194E-09  -4.24630638923779E-18
      4.48058924687077E-07
      0.00000000000000E+00  -2.15210588224677E-12   0.00000000000000E+00   1.99923059171985E-14   3.14500147420368E-22
      2.15207742179461E-09   2.15209741410084E-09  -1.03040329428112E-18  -1.13179044182833E-01  -1.13179044182785E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.79377949708291E-11   0.00000000000000E+00  -4.79377949708291E-11
      5.22661559085971E-18  -5.70555371534904E-01  -5.69892537283729E-01   0.00000000000000E+00   2.82899480922382E-13
     -1.39396055609351E-22  -2.10444251861080E-09  -2.10415961913001E-09  -4.19621229657860E-18
      4.50058924687077E-07
      0.00000000000000E+00  -3.22815882337015E-12   0.00000000000000E+00   2.74827644797034E-14   3.29339579364226E-22
      3.22811131076242E-09   3.22813879352723E-09  -9.88169244143422E-19  -1.32283921877036E-01  -1.32283921876983E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34260050659026E-11   0.00000000000000E+00  -5.34260050659026E-11
      5.11976358072791E-18  -5.74667465452665E-01  -5.73667389771662E-01   0.00000000000000E+00   2.65057140880531E-13
     -1.38273502416516E-22  -3.17497784560207E-09  -3.17471278846133E-09  -4.13159433658449E-18
      4.52058924687077E-07
      0.00000000000000E+00  -4.66075303433315E-12   0.00000000000000E+00   3.61875153997400E-14   3.41877643916091E-22
      4.66073822962243E-09   4.66077441713817E-09  -9.49387046477824E-19  -1.51014137887420E-01  -1.51014137887360E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.96468749821623E-11   0.00000000000000E+00  -5.96468749821623E-11
      5.00046983076359E-18  -5.75932608507708E-01  -5.74483186567633E-01   0.00000000000000E+00   2.62873353843724E-13
     -1.37126597730286E-22  -4.60139041550972E-09  -4.60112754215601E-09  -4.05108278428576E-18
      4.54058924687077E-07
      0.00000000000000E+00  -6.48276893105607E-12   0.00000000000000E+00   4.57006527302083E-14   3.51511933366345E-22
      6.48280792833562E-09   6.48285362898870E-09  -9.13585607053072E-19  -1.69366703938829E-01  -1.69366703938763E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61958121412675E-11   0.00000000000000E+00  -6.61958121412675E-11
      4.86807820648105E-18  -5.73651338589088E-01  -5.71629987554726E-01   0.00000000000000E+00   2.85475478946489E-13
     -1.35848919464504E-22  -6.41694329232624E-09  -6.41665781684742E-09  -3.95449259942798E-18
      4.56058924687077E-07
      0.00000000000000E+00  -8.71606556099429E-12   0.00000000000000E+00   5.57909086198456E-14   3.57639743560761E-22
      8.71597687382010E-09   8.71603266472908E-09  -8.80170270290941E-19  -1.87345544701286E-01  -1.87345544701213E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25674874003059E-11   0.00000000000000E+00  -7.25674874003059E-11
      4.72294323168044E-18  -5.67094218163492E-01  -5.64371369716644E-01   0.00000000000000E+00   3.41222435592100E-13
     -1.34290683271751E-22  -8.64380639976423E-09  -8.64346517732877E-09  -3.84277296138950E-18
      4.58058924687077E-07
      0.00000000000000E+00  -1.13787363373777E-11   0.00000000000000E+00   6.63386691641872E-14   3.59721251075204E-22
      1.13786325537254E-08   1.13786988923949E-08  -8.48575724737309E-19  -2.04957400227483E-01  -2.04957400227405E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.83783604279208E-11   0.00000000000000E+00  -7.83783604279208E-11
      4.56618651082460E-18  -5.55508529686514E-01  -5.51948695595880E-01   0.00000000000000E+00   4.33308728601290E-13
     -1.32274330104483E-22  -1.13007538406955E-08  -1.13003205319670E-08  -3.71761078608728E-18
      4.60058924687077E-07
      0.00000000000000E+00  -1.44895175865966E-11   0.00000000000000E+00   7.73649854418473E-14   3.57175054580859E-22
      1.44893985473621E-08   1.44894759123479E-08  -8.18331879702735E-19  -2.22209910742433E-01  -2.22209910742350E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34865487176762E-11   0.00000000000000E+00  -8.34865487176762E-11
      4.39921341338924E-18  -5.38117985575702E-01  -5.33579756527098E-01   0.00000000000000E+00   5.55177787923507E-13
     -1.29630674943326E-22  -1.44065445414181E-08  -1.44059893636303E-08  -3.58088153368651E-18
      4.62058924687077E-07
      0.00000000000000E+00  -1.80616349508090E-11   0.00000000000000E+00   8.87381739971166E-14   3.49184480493344E-22
      1.80615068084975E-08   1.80615955466718E-08  -7.89079834096403E-19  -2.39110658992126E-01  -2.39110658992038E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.79978324345246E-11   0.00000000000000E+00  -8.79978324345246E-11
      4.22321774852020E-18  -5.14132880509243E-01  -5.08470700429787E-01   0.00000000000000E+00   6.89090379976039E-13
     -1.26248704739933E-22  -1.79742868046172E-08  -1.79735977142373E-08  -3.43413791442379E-18
      4.64058924687076E-07
      0.00000000000000E+00  -2.20886592984102E-11   0.00000000000000E+00   9.99756783499939E-14   3.34560414624730E-22
      2.20885774970615E-08   2.20886774727402E-08  -7.60563874076250E-19  -2.55666769866532E-01  -2.55666769866440E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.21543380087181E-11   0.00000000000000E+00  -9.21543380087181E-11
      4.03890907250276E-18  -4.82786749193466E-01  -4.75857136143123E-01   0.00000000000000E+00   8.11278590299733E-13
     -1.22111915799837E-22  -2.19973344133216E-08  -2.19965231347314E-08  -3.27834519842651E-18
      4.66058924687076E-07
      0.00000000000000E+00  -2.65301789450290E-11   0.00000000000000E+00   1.10234717169453E-13   3.12216792538085E-22
      2.65300552627883E-08   2.65301654975058E-08  -7.32604959998508E-19  -2.71885066778456E-01  -2.71885066778360E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.61009862427419E-11   0.00000000000000E+00  -9.61009862427419E-11
      3.84670710001728E-18  -4.43399975238506E-01  -4.35072258685840E-01   0.00000000000000E+00   9.04825021357445E-13
     -1.17267977386253E-22  -2.64349693362843E-08  -2.64340645112631E-08  -3.11410214001877E-18
      4.68058924687076E-07
      0.00000000000000E+00  -3.13098709140459E-11   0.00000000000000E+00   1.18635091382063E-13   2.83233116794034E-22
      3.13097870424907E-08   3.13099056775824E-08  -7.05057210482720E-19  -2.87772719670344E-01  -2.87772719670244E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96408041484057E-11   0.00000000000000E+00  -9.96408041484057E-11
      3.64742549172046E-18  -3.95448384380815E-01  -3.85615812952585E-01   0.00000000000000E+00   9.69834602823175E-13
     -1.11707833889462E-22  -3.12112347080367E-08  -3.12102648734339E-08  -2.94236828123774E-18
      4.70058924687076E-07
      0.00000000000000E+00  -3.62954787838820E-11   0.00000000000000E+00   1.23780330590511E-13   2.53260317028892E-22
      3.62953171769510E-08   3.62954409572818E-08  -6.77803475440305E-19  -3.03337126968096E-01  -3.03337126967994E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02620810897577E-10   0.00000000000000E+00  -1.02620810897577E-10
      3.44218386992531E-18  -3.38689323213759E-01  -3.27286818664399E-01   0.00000000000000E+00   1.00093464045801E-12
     -1.05261947617834E-22  -3.61938210810246E-08  -3.61928201463843E-08  -2.76438039448501E-18
      4.72058924687076E-07
      0.00000000000000E+00  -4.11066734977611E-11   0.00000000000000E+00   1.19525325440115E-13   2.27909377969761E-22
      4.11065110325949E-08   4.11066305579206E-08  -6.50888527526214E-19  -3.18582801406821E-01  -3.18582801406715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06466626570578E-10   0.00000000000000E+00  -1.06466626570578E-10
      3.22925061678415E-18  -2.73665857180330E-01  -2.60748562423228E-01   0.00000000000000E+00   9.44305425076719E-13
     -9.75833775652165E-23  -4.10011082367749E-08  -4.10001639313500E-08  -2.57836208925794E-18
      4.74058924687076E-07
      0.00000000000000E+00  -4.48249158388706E-11   0.00000000000000E+00   9.24945682916400E-14   1.97168600073098E-22
      4.48248066502970E-08   4.48248991448655E-08  -6.24647406624683E-19  -3.33507636019448E-01  -3.33507636019333E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14534114703854E-10   0.00000000000000E+00  -1.14534114703854E-10
      3.00018238737645E-18  -2.02679523272064E-01  -1.88593087798249E-01   0.00000000000000E+00   7.58346345371267E-13
     -8.89911816380445E-23  -4.47111233765069E-08  -4.47103650301616E-08  -2.37553498075176E-18
      4.76058924687076E-07
      0.00000000000000E+00  -4.65249619245820E-11   0.00000000000000E+00   2.20361197540847E-13   1.41632028380792E-22
      4.65249511070358E-08   4.65251714682335E-08  -5.99322701320059E-19  -3.48111893412996E-01  -3.48111893412870E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25648227908656E-10   0.00000000000000E+00  -1.25648227908656E-10
      2.74888593155913E-18  -1.29761304009690E-01  -1.15142576539305E-01   0.00000000000000E+00   3.61709160625142E-13
     -8.13742521350327E-23  -4.63998849494854E-08  -4.63995232403248E-08  -2.14956323023907E-18
      4.78058924687076E-07
      0.00000000000000E+00  -4.24742416347812E-11   0.00000000000000E+00  -9.94454252480127E-14   7.08812762723557E-23
      4.24743161045737E-08   4.24742166591485E-08  -5.73811440636502E-19  -3.62420617323552E-01  -3.62420617323425E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27153317324368E-10   0.00000000000000E+00  -1.27153317324368E-10
      2.49457929691040E-18  -6.61445460417393E-02  -5.28024473360849E-02   0.00000000000000E+00   4.54049894766608E-13
     -5.81640121115320E-23  -4.23475173917188E-08  -4.23470633418241E-08  -1.92076785627389E-18
      4.80058924687077E-07
      0.00000000000000E+00  -2.88047138619734E-11   0.00000000000000E+00  -3.37927297598160E-13   2.73436403143022E-23
      2.88050694585887E-08   2.88047315312911E-08  -5.43356108855377E-19  -3.76501804262243E-01  -3.76501804262146E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68519622472992E-11   0.00000000000000E+00  -9.68519622472992E-11
      2.30087537241580E-18  -3.03831497671315E-02  -2.13382560676274E-02   0.00000000000000E+00   4.95982186777726E-13
     -2.53739249729410E-23  -2.87083755512306E-08  -2.87078795690438E-08  -1.75751926356042E-18
      4.82058924687077E-07
      0.00000000000000E+00  -1.82805009595745E-11   0.00000000000000E+00  -2.59622132711733E-13   1.19694962276118E-23
      1.82807717504431E-08   1.82805121283104E-08  -5.09714597916353E-19  -3.90356838815411E-01  -3.90356838815343E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.80910971630440E-11   0.00000000000000E+00  -6.80910971630440E-11
      2.16469317808971E-18  -1.58013008655766E-02  -1.00631660968751E-02   0.00000000000000E+00   3.31344058774977E-13
     -1.21171177411920E-23  -1.82127523752061E-08  -1.82124210311473E-08  -1.65497858017336E-18
      4.84058924687077E-07
      0.00000000000000E+00  -1.36829371044401E-11   0.00000000000000E+00  -1.12482519433247E-13   6.93665362877113E-24
      1.36831006727531E-08   1.36829881902337E-08  -4.75866411257910E-19  -4.03956558719894E-01  -4.03956558719837E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64715503561797E-11   0.00000000000000E+00  -5.64715503561797E-11
      2.05175007737735E-18  -1.04442184096046E-02  -6.15094713234654E-03   0.00000000000000E+00   1.56369002408757E-13
     -7.55040053106140E-24  -1.36266730088799E-08  -1.36265166398775E-08  -1.57588366611944E-18
      4.86058924687077E-07
      0.00000000000000E+00  -1.20367120347324E-11   0.00000000000000E+00  -4.03049395281190E-14   5.04224241419278E-24
      1.20368391254185E-08   1.20367988204789E-08  -4.42611292899861E-19  -4.17289668938411E-01  -4.17289668938357E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31639372521608E-11   0.00000000000000E+00  -5.31639372521608E-11
      1.94542220287303E-18  -8.38610208147831E-03  -4.61044620536160E-03   0.00000000000000E+00   7.41839241711760E-14
     -5.69793226382073E-24  -1.19837090671510E-08  -1.19836348832268E-08  -1.50281090997317E-18
      4.88058924687077E-07
      0.00000000000000E+00  -1.14794900140944E-11   0.00000000000000E+00  -1.34706331472207E-14   4.11599387340059E-24
      1.14794936798266E-08   1.14794802091935E-08  -4.10142537806708E-19  -4.30355750115007E-01  -4.30355750114954E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27231463159806E-11   0.00000000000000E+00  -5.27231463159806E-11
      1.83997591024107E-18  -7.44476930905992E-03  -3.84456530243937E-03   0.00000000000000E+00   4.25336993055370E-14
     -4.73018571511892E-24  -1.14267995965768E-08  -1.14267570628775E-08  -1.42983337243436E-18
      4.90058924687077E-07
      0.00000000000000E+00  -1.12794521764564E-11   0.00000000000000E+00  -4.67939559636946E-15   3.54961293480473E-24
      1.12794765921547E-08   1.12794719127591E-08  -3.78549974765195E-19  -4.43158278940238E-01  -4.43158278940185E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31515641590910E-11   0.00000000000000E+00  -5.31515641590910E-11
      1.73367278192289E-18  -6.90522027685346E-03  -3.36816543087462E-03   0.00000000000000E+00   3.05976338493054E-14
     -4.10022399774392E-24  -1.12263509462339E-08  -1.12263203486001E-08  -1.35512280715769E-18
      4.92058924687077E-07
      0.00000000000000E+00  -1.11939447261162E-11   0.00000000000000E+00  -1.87652328671463E-15   3.15309039401562E-24
      1.11939552608503E-08   1.11939533843270E-08  -3.47895281045628E-19  -4.55701899350936E-01  -4.55701899350882E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.37915843520576E-11   0.00000000000000E+00  -5.37915843520576E-11
      1.62608961321877E-18  -6.53867904011723E-03  -3.02876822573257E-03   0.00000000000000E+00   2.53375787033097E-14
     -3.63311895060873E-24  -1.11401871375536E-08  -1.11401617999749E-08  -1.27819433217314E-18
      4.94058924687077E-07
      0.00000000000000E+00  -1.11481142022496E-11   0.00000000000000E+00  -9.15438594081663E-16   2.85550052177090E-24
      1.11481435703796E-08   1.11481426549410E-08  -3.18216749241007E-19  -4.67991475247155E-01  -4.67991475247100E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44260753845892E-11   0.00000000000000E+00  -5.44260753845892E-11
      1.51723746244959E-18  -6.26582133914444E-03  -2.77054234819248E-03   0.00000000000000E+00   2.23175784697988E-14
     -3.26619911368685E-24  -1.10937388971349E-08  -1.10937165795564E-08  -1.19902071320858E-18
      4.96058924687077E-07
      0.00000000000000E+00  -1.11189994205548E-11   0.00000000000000E+00  -5.22051719693371E-16   2.62328981866314E-24
      1.11189469507944E-08   1.11189464287427E-08  -2.89530762222959E-19  -4.80031661591980E-01  -4.80031661591925E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49771374997557E-11   0.00000000000000E+00  -5.49771374997557E-11
      1.40728318745008E-18  -6.05333000981352E-03  -2.56742201241047E-03   0.00000000000000E+00   2.01559957121424E-14
     -2.97026164525791E-24  -1.10639894472386E-08  -1.10639692912429E-08  -1.11775242522712E-18
      4.98058924687077E-07
      0.00000000000000E+00  -1.10984261994203E-11   0.00000000000000E+00  -3.21967060138752E-16   2.43727494241872E-24
      1.10984441168188E-08   1.10984437948517E-08  -2.61836399826800E-19  -4.91826386309112E-01  -4.91826386309057E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54120775909916E-11   0.00000000000000E+00  -5.54120775909916E-11
      1.29645903226810E-18  -5.88359302950762E-03  -2.40428049942463E-03   0.00000000000000E+00   1.84205836549428E-14
     -2.72777169743874E-24  -1.10430501378444E-08  -1.10430317172607E-08  -1.03462263244130E-18
      5.00058924687077E-07
      0.00000000000000E+00  -1.10832718177811E-11   0.00000000000000E+00  -2.02853663474788E-16   2.28521313966337E-24
      1.10832871506152E-08   1.10832869477616E-08  -2.35123196441371E-19  -5.03377352670005E-01  -5.03377352669949E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57096665455803E-11   0.00000000000000E+00  -5.57096665455803E-11
      1.18503969917694E-18  -5.74559456405022E-03  -2.27115005592406E-03   0.00000000000000E+00   1.69566130508572E-14
     -2.52662855965892E-24  -1.10275942378290E-08  -1.10275772812160E-08  -9.49916502735566E-19
      5.02058924687077E-07
      0.00000000000000E+00  -1.10716993808929E-11   0.00000000000000E+00  -1.27439501723895E-16   2.15885714898929E-24
      1.10716604293797E-08   1.10716603019402E-08  -2.09388637737316E-19  -5.14677981975105E-01  -5.14677981975049E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58267002382035E-11   0.00000000000000E+00  -5.58267002382035E-11
      1.07338629870053E-18  -5.63182708632645E-03  -2.16108154769466E-03   0.00000000000000E+00   1.56850252277949E-14
     -2.35806326430120E-24  -1.10158492867272E-08  -1.10158336017020E-08  -8.63997660963215E-19
      5.04058924687077E-07
      0.00000000000000E+00  -1.10622393729606E-11   0.00000000000000E+00  -8.35511681632581E-17   2.05261023872592E-24
      1.10622441997043E-08   1.10622441161532E-08  -1.84692769896660E-19  -5.25689829492099E-01  -5.25689829492043E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56009312960048E-11   0.00000000000000E+00  -5.56009312960048E-11
      9.62184436108520E-19  -5.53707261951021E-03  -2.06922170483575E-03   0.00000000000000E+00   1.45268336603675E-14
     -2.21584793722330E-24  -1.10066577116908E-08  -1.10066431848572E-08  -7.77491666211860E-19
      5.06058924687077E-07
      0.00000000000000E+00  -1.10537896571375E-11   0.00000000000000E+00  -7.08288217665497E-17   1.96284039214319E-24
      1.10538019435372E-08   1.10538018727084E-08  -1.61240424072114E-19  -5.36304055116016E-01  -5.36304055115962E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46584898924364E-11   0.00000000000000E+00  -5.46584898924364E-11
      8.52867456323647E-19  -5.45781204704251E-03  -1.99232332423580E-03   0.00000000000000E+00   1.33746570949268E-14
     -2.09587220063262E-24  -1.09991567574731E-08  -1.09991433828160E-08  -6.91627032251534E-19
      5.08058924687077E-07
      0.00000000000000E+00  -1.10453399413144E-11   0.00000000000000E+00  -8.27537924759155E-17   1.88723206440623E-24
      1.10453690792481E-08   1.10453689964943E-08  -1.39366876149137E-19  -5.46344496572482E-01  -5.46344496572429E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.26159127468023E-11   0.00000000000000E+00  -5.26159127468023E-11
      7.47635630830043E-19  -5.39166671679846E-03  -1.92819077416100E-03   0.00000000000000E+00   1.21490049868722E-14
     -1.99534011726134E-24  -1.09927652327525E-08  -1.09927530837475E-08  -6.08268754680905E-19
      5.10058924687077E-07
      0.00000000000000E+00  -1.10361554675936E-11   0.00000000000000E+00  -1.15257279895407E-16   1.82432173703025E-24
      1.10361808568673E-08   1.10361807416100E-08  -1.19525576447943E-19  -5.55571078174601E-01  -5.55571078174552E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.90924370545401E-11   0.00000000000000E+00  -4.90924370545401E-11
      6.49450756720963E-19  -5.33703478592050E-03  -1.87534305121483E-03   0.00000000000000E+00   1.07774954354685E-14
     -1.91239839841647E-24  -1.09870990820509E-08  -1.09870883045555E-08  -5.29925180273019E-19
      5.12058924687077E-07
      0.00000000000000E+00  -1.10254096333403E-11   0.00000000000000E+00  -1.70999137916816E-16   1.77337689336415E-24
      1.10254022325895E-08   1.10254020615904E-08  -1.02340404676758E-19  -5.63654451935556E-01  -5.63654451935512E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35650545016246E-11   0.00000000000000E+00  -4.35650545016246E-11
      5.62320647717714E-19  -5.29299146234324E-03  -1.83295373695254E-03   0.00000000000000E+00   9.17383167804171E-15
     -1.84616680498709E-24  -1.09818461809204E-08  -1.09818370070888E-08  -4.59980243040954E-19
      5.14058924687077E-07
      0.00000000000000E+00  -1.10120921464452E-11   0.00000000000000E+00  -2.54804570670657E-16   1.73439184556870E-24
      1.10120485004992E-08   1.10120482456946E-08  -8.86553373094908E-20  -5.70152446770842E-01  -5.70152446770807E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53814218743212E-11   0.00000000000000E+00  -3.53814218743212E-11
      4.91557803969071E-19  -5.25926633452099E-03  -1.80085717483539E-03   0.00000000000000E+00   7.22494746761737E-15
     -1.79677837575596E-24  -1.09766740487678E-08  -1.09766668238203E-08  -4.02902466659580E-19
      5.16058924687077E-07
      0.00000000000000E+00  -1.09951008700619E-11   0.00000000000000E+00  -3.67915522301224E-16   1.70808650851571E-24
      1.09951001326210E-08   1.09950997647055E-08  -7.95364089058325E-20  -5.74511982505929E-01  -5.74511982505905E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39140181035981E-11   0.00000000000000E+00  -2.39140181035981E-11
      4.43729767761875E-19  -5.23623781652427E-03  -1.77955531389439E-03   0.00000000000000E+00   4.81479326393445E-15
     -1.76539514070182E-24  -1.09711905613951E-08  -1.09711857466019E-08  -3.64193358856042E-19
      5.18058924687077E-07
      0.00000000000000E+00  -1.09737010462925E-11   0.00000000000000E+00  -5.09768478948503E-16   1.69599004850170E-24
      1.09737101037165E-08   1.09737095939480E-08  -7.62403909864749E-20  -5.76092797818935E-01  -5.76092797818926E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71230162927916E-12   0.00000000000000E+00  -8.71230162927916E-12
      4.26305164503316E-19  -5.22504629955982E-03  -1.77031349187657E-03   0.00000000000000E+00   1.83588926338980E-15
     -1.75439696961349E-24  -1.09649991282080E-08  -1.09649972923187E-08  -3.50064773516842E-19
      5.20058924687077E-07
      0.00000000000000E+00  -1.09471579172395E-11   0.00000000000000E+00  -6.75180955859791E-16   1.70070123520555E-24
      1.09471864748760E-08   1.09471857996950E-08  -8.01829055362023E-20  -5.74199417310382E-01  -5.74199417310392E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04074632910407E-11   0.00000000000000E+00   1.04074632910407E-11
      4.47120091085398E-19  -5.22782221095593E-03  -1.77542229129871E-03   0.00000000000000E+00  -1.82808922810824E-15
     -1.76792499622333E-24  -1.09575914348968E-08  -1.09575932629860E-08  -3.66937185549195E-19
      5.22058924687077E-07
      0.00000000000000E+00  -1.09148285697425E-11   0.00000000000000E+00  -6.19835102744289E-16   1.72653381014120E-24
      1.09147924996667E-08   1.09147918798316E-08  -9.29436320731400E-20  -5.68104872503244E-01  -5.68104872503277E-01
      0.00000000000000E+00   0.00000000000000E+00   3.33519202158375E-11   0.00000000000000E+00   3.33519202158375E-11
      5.13823931517073E-19  -5.24828592151778E-03  -1.79886367174545E-03   0.00000000000000E+00  -6.57517558567172E-15
     -1.81318781453047E-24  -1.09481372248718E-08  -1.09481438000474E-08  -4.20880299443932E-19
      5.24058924687078E-07
      0.00000000000000E+00  -1.08753353327432E-11   0.00000000000000E+00  -1.10169826919781E-15   1.78089899554990E-24
      1.08753171482816E-08   1.08753160465833E-08  -1.16330608612323E-19  -5.57058785999030E-01  -5.57058785999090E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97553333985515E-11   0.00000000000000E+00   5.97553333985515E-11
      6.33334598314176E-19  -5.29317027774017E-03  -1.84786734851711E-03   0.00000000000000E+00  -1.19064618733938E-14
     -1.90341249057807E-24  -1.09350594735200E-08  -1.09350713799819E-08  -5.17003989701853E-19
      5.26058924687078E-07
      0.00000000000000E+00  -1.08261983983372E-11   0.00000000000000E+00  -1.09790611498233E-15   1.87719497519663E-24
      1.08261835540916E-08   1.08261824561855E-08  -1.52501333065391E-19  -5.40287061117247E-01  -5.40287061117336E-01
      0.00000000000000E+00   0.00000000000000E+00   8.88852535371894E-11   0.00000000000000E+00   8.88852535371894E-11
      8.11105105388554E-19  -5.37554505853742E-03  -1.93654578963331E-03   0.00000000000000E+00  -1.93118490163484E-14
     -2.06487386475505E-24  -1.09150483978737E-08  -1.09150677097227E-08  -6.58603772323162E-19
      5.28058924687078E-07
      0.00000000000000E+00  -1.07611723243943E-11   0.00000000000000E+00  -1.90745708911595E-15   2.04102300422910E-24
      1.07611626358084E-08   1.07611607283513E-08  -2.04113471441899E-19  -5.17000139636319E-01  -5.17000139636438E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19353403525700E-10   0.00000000000000E+00   1.19353403525700E-10
      1.04981191243995E-18  -5.52310949208057E-03  -2.09499863021971E-03   0.00000000000000E+00  -2.83508248229715E-14
     -2.35589941807593E-24  -1.08804857810522E-08  -1.08805141318770E-08  -8.45698440998056E-19
      5.30058924687078E-07
      0.00000000000000E+00  -1.06630821450566E-11   0.00000000000000E+00  -3.58660483051450E-15   2.32355951492378E-24
      1.06630620099423E-08   1.06630584233374E-08  -2.74413146549158E-19  -4.86426563470144E-01  -4.86426563470293E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48635154108613E-10   0.00000000000000E+00   1.48635154108613E-10
      1.34708222065718E-18  -5.80154579633412E-03  -2.39512091185204E-03   0.00000000000000E+00  -4.06208319837203E-14
     -2.92839336106868E-24  -1.08116529566141E-08  -1.08116935774460E-08  -1.07266907410802E-18
      5.32058924687078E-07
      0.00000000000000E+00  -1.04765454837882E-11   0.00000000000000E+00  -5.27156865061586E-15   2.82262978839593E-24
      1.04765293516948E-08   1.04765240801262E-08  -3.66910763871737E-19  -4.47874752650992E-01  -4.47874752651164E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72771975140817E-10   0.00000000000000E+00   1.72771975140817E-10
      1.69262617093882E-18  -6.39113356975377E-03  -3.03587983970078E-03   0.00000000000000E+00  -6.04280362783054E-14
     -4.27429327382145E-24  -1.06492356272307E-08  -1.06492960552670E-08  -1.32571540706708E-18
      5.34058924687078E-07
      0.00000000000000E+00  -9.99656488714163E-12   0.00000000000000E+00  -1.77278019226916E-13   3.61341716907410E-24
      9.99664338411748E-09   9.99646610609825E-09  -4.83531079066462E-19  -4.00801626614194E-01  -4.00801626614382E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87969759775241E-10   0.00000000000000E+00   1.87969759775241E-10
      2.06856569048930E-18  -7.87641055983733E-03  -4.66757478818791E-03   0.00000000000000E+00   7.50330828763575E-14
     -8.39662967633623E-24  -1.01845108989564E-08  -1.01844358658735E-08  -1.58503461142284E-18
      5.36058924687078E-07
      0.00000000000000E+00  -8.48333099691042E-12   0.00000000000000E+00  -4.26300417480052E-14   3.53657727672060E-24
      8.48336785074466E-09   8.48332522070292E-09  -6.19533610912295E-19  -3.44923087955437E-01  -3.44923087955636E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98656688151074E-10   0.00000000000000E+00   1.98656688151074E-10
      2.46587906679145E-18  -1.22676295609964E-02  -9.53222885508127E-03   0.00000000000000E+00  -1.26728146800463E-13
     -2.36052697909691E-23  -8.68185518070717E-09  -8.68198190885399E-09  -1.84634545587915E-18
      5.38058924687078E-07
      0.00000000000000E+00  -4.87447573781507E-12   0.00000000000000E+00  -9.12036830372758E-14  -5.17214679008703E-24
      4.87455143687989E-09   4.87446023319685E-09  -7.61861293197023E-19  -2.80660634951241E-01  -2.80660634951464E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22189569073093E-10   0.00000000000000E+00   2.22189569073093E-10
      2.91025820493763E-18  -2.35760780992277E-02  -2.19703052197265E-02   0.00000000000000E+00  -1.95346824552616E-13
     -5.78454626884204E-23  -5.09645445544533E-09  -5.09664980226994E-09  -2.14839691174061E-18
      5.40058924687078E-07
      0.00000000000000E+00  -1.50239621124072E-12   0.00000000000000E+00  -8.61915985773391E-14  -2.54738592304009E-23
      1.50246111745118E-09   1.50237492585258E-09  -9.05738473293393E-19  -2.10106494885780E-01  -2.10106494886023E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43236222522200E-10   0.00000000000000E+00   2.43236222522200E-10
      3.39673064998203E-18  -4.12053236918522E-02  -4.06553481438529E-02   0.00000000000000E+00  -3.58144693918651E-13
     -8.19402810475560E-23  -1.74525300368078E-09  -1.74561114837478E-09  -2.49099217668864E-18
      5.42058924687078E-07
      0.00000000000000E+00  -2.54134387853227E-13   0.00000000000000E+00  -3.47693703987675E-14  -3.99300125375041E-23
      2.54136708691158E-10   2.54101939320719E-10  -1.05315535018288E-18  -1.37111247487715E-01  -1.37111247487954E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39674912224773E-10   0.00000000000000E+00   2.39674912224773E-10
      3.87608047443158E-18  -6.09278283120056E-02  -6.07722591590289E-02   0.00000000000000E+00  -6.00482760411625E-13
     -9.03058329476361E-23  -4.93176368784990E-10  -4.93776851545492E-10  -2.82292512424870E-18
      5.44058924687078E-07
      0.00000000000000E+00   1.07458342532806E-14   0.00000000000000E+00  -1.09807109642177E-14  -4.47952239576902E-23
     -1.07100752163225E-11  -1.07210559273315E-11  -1.18671004028872E-18  -7.14803450295647E-02  -7.14803450297708E-02
      0.00000000000000E+00   0.00000000000000E+00   2.06042664167327E-10   0.00000000000000E+00   2.06042664167327E-10
      4.28816580276623E-18  -8.08394597831987E-02  -8.07779219127780E-02   0.00000000000000E+00  -7.84566358161614E-13
     -9.73482500311474E-23  -1.94537041881736E-10  -1.95321608239995E-10  -3.10145576247752E-18
      5.46058924687078E-07
      0.00000000000000E+00   2.31448737762967E-14   0.00000000000000E+00  -3.02400552864384E-15  -4.58898954990695E-23
     -2.31380405956260E-11  -2.31410646012006E-11  -1.26681602746329E-18  -3.28133790875729E-02  -3.28133790877108E-02
      0.00000000000000E+00   0.00000000000000E+00   1.37859411018697E-10   0.00000000000000E+00   1.37859411018697E-10
      4.56388462480363E-18  -1.00510203916383E-01  -1.00474060977005E-01   0.00000000000000E+00  -6.41182474108505E-13
     -1.02294777311307E-22  -1.14077163943285E-10  -1.14718346417496E-10  -3.29706859734034E-18
      5.48058924687078E-07
      0.00000000000000E+00   2.29611843018817E-15   0.00000000000000E+00  -2.83086518939742E-16  -4.59746729691780E-23
     -2.31708048900099E-12  -2.31736357556591E-12  -1.30233962407410E-18  -1.67140046792280E-02  -1.67140046793115E-02
      0.00000000000000E+00   0.00000000000000E+00   8.34575951275141E-11   0.00000000000000E+00   8.34575951275141E-11
      4.73079981505865E-18  -1.19851394495664E-01  -1.19825830816005E-01   0.00000000000000E+00  -4.09455309846120E-13
     -1.05047968602978E-22  -8.07307762419972E-11  -8.11402315519484E-11  -3.42846019098455E-18
      5.50058924687078E-07
      0.00000000000000E+00  -1.38685553183365E-14   0.00000000000000E+00   4.28888021040619E-16  -4.54698676259263E-23
      1.38233034611027E-11   1.38237323490782E-11  -1.31625403578565E-18  -1.07795255949559E-02  -1.07795255950103E-02
      0.00000000000000E+00   0.00000000000000E+00   5.44136582077110E-11   0.00000000000000E+00   5.44136582077110E-11
      4.83962713147407E-18  -1.38827327381691E-01  -1.38805828980198E-01   0.00000000000000E+00  -3.00361730212793E-13
     -1.06921976735309E-22  -6.79370288264699E-11  -6.82373905567896E-11  -3.52337309568843E-18
      5.52058924687078E-07
      0.00000000000000E+00  -2.47980790460322E-14   0.00000000000000E+00   4.83364979280101E-16  -4.42249040107997E-23
      2.48059584811534E-11   2.48064418460885E-11  -1.32105192092817E-18  -8.52457952645746E-03  -8.52457952649697E-03
      0.00000000000000E+00   0.00000000000000E+00   3.95080192819864E-11   0.00000000000000E+00   3.95080192819864E-11
      4.91864317003805E-18  -1.57426342481559E-01  -1.57406080129929E-01   0.00000000000000E+00  -2.72137885434567E-13
     -1.08541703018114E-22  -6.40423232425320E-11  -6.43144611280751E-11  -3.59759124910988E-18
      5.54058924687078E-07
      0.00000000000000E+00  -3.27885711830871E-14   0.00000000000000E+00   4.11487110666405E-16  -4.18862675926966E-23
      3.27754763589157E-11   3.27758878459845E-11  -1.32205112841514E-18  -7.51582708474108E-03  -7.51582708477226E-03
      0.00000000000000E+00   0.00000000000000E+00   3.11765515263029E-11   0.00000000000000E+00   3.11765515263029E-11
      4.98099627309065E-18  -1.75648552057482E-01  -1.75628403870516E-01   0.00000000000000E+00  -2.73052661251507E-13
     -1.10107623200787E-22  -6.36793867109253E-11  -6.39524393722869E-11  -3.65894514467552E-18
      5.56058924687078E-07
      0.00000000000000E+00  -3.90340133131989E-14   0.00000000000000E+00   3.20811288638911E-16  -3.80338242919903E-23
      3.90132292036971E-11   3.90135500149477E-11  -1.32143185173604E-18  -6.95008495992042E-03  -6.95008495994643E-03
      0.00000000000000E+00   0.00000000000000E+00   2.60137774148760E-11   0.00000000000000E+00   2.60137774148760E-11
      5.03302382792041E-18  -1.93499180530434E-01  -1.93478693804691E-01   0.00000000000000E+00  -2.80711080408749E-13
     -1.11666596285240E-22  -6.47466163493041E-11  -6.50273274298246E-11  -3.71159197618437E-18
      5.58058924687078E-07
      0.00000000000000E+00  -4.41773185968204E-14   0.00000000000000E+00   2.53645151566502E-16  -3.22477796558368E-23
      4.42178285416257E-11   4.42180821867451E-11  -1.32012237167326E-18  -6.57085510444733E-03  -6.57085510446990E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25644107499335E-11   0.00000000000000E+00   2.25644107499335E-11
      5.07815264942028E-18  -2.10985435970835E-01  -2.10964396392830E-01   0.00000000000000E+00  -2.88116021740451E-13
     -1.13222091949109E-22  -6.64943769148239E-11  -6.67824929366776E-11  -3.75803027774701E-18
      5.60058924687078E-07
      0.00000000000000E+00  -4.87695554571967E-14   0.00000000000000E+00   2.09171735877202E-16  -2.41939844490869E-23
      4.87956329792783E-11   4.87958421509899E-11  -1.31854022297108E-18  -6.29040819075000E-03  -6.29040819077015E-03
      0.00000000000000E+00   0.00000000000000E+00   2.01503832955679E-11   0.00000000000000E+00   2.01503832955679E-11
      5.11845341601141E-18  -2.28115016009445E-01  -2.28093294871215E-01   0.00000000000000E+00  -2.93746759629529E-13
     -1.14768937264996E-22  -6.86524786868144E-11  -6.89462254465587E-11  -3.79991319304033E-18
      5.62058924687078E-07
      0.00000000000000E+00  -5.29944133687429E-14   0.00000000000000E+00   1.80827811872664E-16  -1.37457026264602E-23
      5.29925330308687E-11   5.29927138586668E-11  -1.31687884969366E-18  -6.07274355747312E-03  -6.07274355749153E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84069749521371E-11   0.00000000000000E+00   1.84069749521371E-11
      5.15526736591569E-18  -2.44895364426859E-01  -2.44872870461133E-01   0.00000000000000E+00  -2.97703852605125E-13
     -1.16302241819851E-22  -7.11019849580818E-11  -7.13996888108032E-11  -3.83838851622202E-18
      5.64058924687078E-07
      0.00000000000000E+00  -5.69437370686666E-14   0.00000000000000E+00   1.62866442656357E-16  -1.10556357687536E-24
      5.69557877755515E-11   5.69559506419930E-11  -1.31522619274669E-18  -5.89924104468089E-03  -5.89924104469800E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71124488938552E-11   0.00000000000000E+00   1.71124488938552E-11
      5.18949226370339E-18  -2.61333449862668E-01  -2.61310115268622E-01   0.00000000000000E+00  -3.00464554266513E-13
     -1.17819163004508E-22  -7.37679349814644E-11  -7.40683995358487E-11  -3.87426607095670E-18
      5.66058924687078E-07
      0.00000000000000E+00  -6.08012160313827E-14   0.00000000000000E+00   1.51333471356381E-16   1.28268178971883E-23
      6.07726891460890E-11   6.07728404795732E-11  -1.31361877143483E-18  -5.75840568034380E-03  -5.75840568035992E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61222736473879E-11   0.00000000000000E+00   1.61222736473879E-11
      5.22173681099817E-18  -2.77436134770437E-01  -2.77411909781444E-01   0.00000000000000E+00  -3.02532701541096E-13
     -1.19318967184756E-22  -7.65925814253010E-11  -7.68951141269614E-11  -3.90811803956334E-18
      5.68058924687078E-07
      0.00000000000000E+00  -6.44750055196838E-14   0.00000000000000E+00   1.43786660236889E-16   2.68919101124022E-23
      6.44970902578918E-11   6.44972340445790E-11  -1.31206823452912E-18  -5.64244685991156E-03  -5.64244685992690E-03
      0.00000000000000E+00   0.00000000000000E+00   1.53393881406381E-11   0.00000000000000E+00   1.53393881406381E-11
      5.25241558727945E-18  -2.93210794385834E-01  -2.93185642847822E-01   0.00000000000000E+00  -3.04351905809191E-13
     -1.20802477794887E-22  -7.95322702792868E-11  -7.98366221852168E-11  -3.94034735275033E-18
      5.70058924687079E-07
      0.00000000000000E+00  -6.81487950079849E-14   0.00000000000000E+00   1.38759100566326E-16   4.04123809605913E-23
      6.81642310322129E-11   6.81643697913539E-11  -1.31057476733861E-18  -5.54594463443534E-03  -5.54594463445003E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46966343569709E-11   0.00000000000000E+00   1.46966343569709E-11
      5.28180885599339E-18  -3.08664354731932E-01  -3.08638250546407E-01   0.00000000000000E+00  -3.06252118455750E-13
     -1.22271751853856E-22  -8.25547520297463E-11  -8.28610041483243E-11  -3.97123408865478E-18
      5.72058924687079E-07
      0.00000000000000E+00  -7.18225844962859E-14   0.00000000000000E+00   1.35323678957960E-16   5.28460349400251E-23
      7.17971244558592E-11   7.17972597795910E-11  -1.30913394288758E-18  -5.46523187955350E-03  -5.46523187956764E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41442571557229E-11   0.00000000000000E+00   1.41442571557229E-11
      5.31009737030483E-18  -3.23799233660608E-01  -3.23772159154153E-01   0.00000000000000E+00  -3.08373910536596E-13
     -1.23729097261818E-22  -8.56331430246540E-11  -8.59415169353143E-11  -4.00096342741725E-18
      5.74058924687079E-07
      0.00000000000000E+00  -7.54045292473795E-14   0.00000000000000E+00   1.32857107645559E-16   6.38523472143957E-23
      7.54093693021200E-11   7.54095021592915E-11  -1.30774034738199E-18  -5.39783650269455E-03  -5.39783650270820E-03
      0.00000000000000E+00   0.00000000000000E+00   1.36458576901476E-11   0.00000000000000E+00   1.36458576901476E-11
      5.33738908568513E-18  -3.38611907820450E-01  -3.38583852502879E-01   0.00000000000000E+00  -3.10739329905163E-13
     -1.25176518401127E-22  -8.87446205194089E-11  -8.90553598494392E-11  -4.02964873830314E-18
      5.76058924687079E-07
      0.00000000000000E+00  -7.89864739984730E-14   0.00000000000000E+00   1.31065878229963E-16   7.33071752947055E-23
      7.90110697259832E-11   7.90112007919348E-11  -1.30638814988225E-18  -5.34208514814275E-03  -5.34208514815594E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31873078627244E-11   0.00000000000000E+00   1.31873078627244E-11
      5.36376370141058E-18  -3.53108388221295E-01  -3.53079342870346E-01   0.00000000000000E+00  -3.13718584278811E-13
     -1.26617459654259E-22  -9.18847900702536E-11  -9.21985086546591E-11  -4.05737555152833E-18
      5.78058924687079E-07
      0.00000000000000E+00  -8.26602634867741E-14   0.00000000000000E+00   1.30046451193759E-16   8.12676792256141E-23
      8.26171047637443E-11   8.26172348102768E-11  -1.30506942674694E-18  -5.29698411848900E-03  -5.29698411850178E-03
      0.00000000000000E+00   0.00000000000000E+00   1.27824507393793E-11   0.00000000000000E+00   1.27824507393793E-11
      5.38932860288933E-18  -3.67331302798591E-01  -3.67301249143556E-01   0.00000000000000E+00  -3.18427145914184E-13
     -1.28060064715401E-22  -9.50812584036138E-11  -9.53996855496560E-11  -4.08425917614240E-18
      5.80058924687079E-07
      0.00000000000000E+00  -8.62422082378676E-14   0.00000000000000E+00   1.29810830731704E-16   8.79032181841300E-23
      8.62443211755834E-11   8.62444509865020E-11  -1.30377531410181E-18  -5.26219886055868E-03  -5.26219886057111E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24327636528228E-11   0.00000000000000E+00   1.24327636528228E-11
      5.41419413019498E-18  -3.81337699353992E-01  -3.81306613352547E-01   0.00000000000000E+00  -3.25397216555197E-13
     -1.29514228687685E-22  -9.83518174226404E-11  -9.86772146393251E-11  -4.11041881609317E-18
      5.82058924687079E-07
      0.00000000000000E+00  -8.99159977261687E-14   0.00000000000000E+00   1.29603296788574E-16   9.34146127169679E-23
      8.98893545736910E-11   8.98894841770812E-11  -1.30250220386160E-18  -5.23803697227898E-03  -5.23803697229106E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20721167027822E-11   0.00000000000000E+00   1.20721167027822E-11
      5.43833836360055E-18  -3.95106518102612E-01  -3.95074397608373E-01   0.00000000000000E+00  -3.32345184916759E-13
     -1.30979013037578E-22  -1.01629255694815E-10  -1.01961600879863E-10  -4.13583615973895E-18
      5.84058924687079E-07
      0.00000000000000E+00  -9.35897872144698E-14   0.00000000000000E+00   1.29416054805494E-16   9.80071331530853E-23
      9.35486638026756E-11   9.35487932188284E-11  -1.30124661194964E-18  -5.22555379887206E-03  -5.22555379888376E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16917201333667E-11   0.00000000000000E+00   1.16917201333667E-11
      5.46172180386728E-18  -4.08614217947378E-01  -4.08581064699048E-01   0.00000000000000E+00  -3.39201377047103E-13
     -1.32453061089889E-22  -1.04901311975015E-10  -1.05240513352195E-10  -4.16047519191764E-18
      5.86058924687079E-07
      0.00000000000000E+00  -9.72635767027708E-14   0.00000000000000E+00   1.29508887558332E-16   1.01871010349603E-22
      9.72248719328353E-11   9.72250014418247E-11  -1.30000279544376E-18  -5.22675931099633E-03  -5.22675931100763E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13000730149287E-11   0.00000000000000E+00   1.13000730149287E-11
      5.48432194989714E-18  -4.21854411579609E-01  -4.21820223812055E-01   0.00000000000000E+00  -3.46430515849586E-13
     -1.33936782800879E-22  -1.08178643940770E-10  -1.08525074456754E-10  -4.18431915445338E-18
      5.88058924687079E-07
      0.00000000000000E+00  -1.00937366191072E-13   0.00000000000000E+00   1.30192648169672E-16   1.05170822332605E-22
      1.00927154935107E-10   1.00927285127861E-10  -1.29876163328854E-18  -5.24516415136316E-03  -5.24516415137406E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08998493073794E-11   0.00000000000000E+00   1.08998493073794E-11
      5.50612164851190E-18  -4.34828541788683E-01  -4.34793314004184E-01   0.00000000000000E+00  -3.54137912891016E-13
     -1.35430740919475E-22  -1.11472996522214E-10  -1.11827134435240E-10  -4.20736001522335E-18
      5.90058924687079E-07
      0.00000000000000E+00  -1.04703000416580E-13   0.00000000000000E+00   1.31970745955412E-16   1.08046599560787E-22
      1.04676080948797E-10   1.04676212919651E-10  -1.29750780632062E-18  -5.28708422830029E-03  -5.28708422831077E-03
      0.00000000000000E+00   0.00000000000000E+00   1.04883791534561E-11   0.00000000000000E+00   1.04883791534561E-11
      5.52709840681881E-18  -4.47540667952192E-01  -4.47504389015379E-01   0.00000000000000E+00  -3.62189222663689E-13
     -1.36934556037419E-22  -1.14802402850307E-10  -1.15164592073108E-10  -4.22959060049818E-18
      5.92058924687079E-07
      0.00000000000000E+00  -1.08468634642089E-13   0.00000000000000E+00   1.36045481045243E-16   1.10624737439147E-22
      1.08516274282407E-10   1.08516410327999E-10  -1.29621302173301E-18  -5.36468158084220E-03  -5.36468158085226E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00564232854109E-11   0.00000000000000E+00   1.00564232854109E-11
      5.54721125338963E-18  -4.59995574904803E-01  -4.59958222534112E-01   0.00000000000000E+00  -3.70250895624414E-13
     -1.38446146656346E-22  -1.18202582717646E-10  -1.18572833613409E-10  -4.25099823165662E-18
      5.94058924687079E-07
      0.00000000000000E+00  -1.12509803079220E-13   0.00000000000000E+00   1.44797295985466E-16   1.13042988674497E-22
      1.12548534218670E-10   1.12548679016079E-10  -1.29481931627250E-18  -5.50347776927552E-03  -5.50347776928510E-03
      0.00000000000000E+00   0.00000000000000E+00   9.58060239856960E-12   0.00000000000000E+00   9.58060239856960E-12
      5.56637245818677E-18  -4.72198096485348E-01  -4.72159624011394E-01   0.00000000000000E+00  -3.77641827116999E-13
     -1.39960490660331E-22  -1.21751639587392E-10  -1.22129281414649E-10  -4.27155314191427E-18
      5.96058924687079E-07
      0.00000000000000E+00  -1.17010195202389E-13   0.00000000000000E+00   1.65128524220413E-16   1.15513200587864E-22
      1.17021440963290E-10   1.17021606091929E-10  -1.29319299434313E-18  -5.76320574709953E-03  -5.76320574710853E-03
      0.00000000000000E+00   0.00000000000000E+00   8.99890828947395E-12   0.00000000000000E+00   8.99890828947395E-12
      5.58437027476572E-18  -4.84152716428024E-01  -4.84113018409177E-01   0.00000000000000E+00  -3.82783022935248E-13
     -1.41466437043800E-22  -1.25637731358327E-10  -1.26020514381403E-10  -4.29117728042259E-18
      5.98058924687079E-07
      0.00000000000000E+00  -1.22612724172048E-13   0.00000000000000E+00   2.18481097171236E-16   1.18519384779796E-22
      1.22638954826483E-10   1.22639173307699E-10  -1.29097658381021E-18  -6.30512057677958E-03  -6.30512057678771E-03
      0.00000000000000E+00   0.00000000000000E+00   8.12510352611264E-12   0.00000000000000E+00   8.12510352611264E-12
      5.60062048181794E-18  -4.95862866175410E-01  -4.95821674080715E-01   0.00000000000000E+00  -3.81215836685233E-13
     -1.42936431277092E-22  -1.30383060996983E-10  -1.30764276833811E-10  -4.30964389800773E-18
      6.00058924687079E-07
      0.00000000000000E+00  -1.31797197892801E-13   0.00000000000000E+00   3.74818708565881E-16   1.23576437055486E-22
      1.31788405324737E-10   1.31788780143570E-10  -1.28703537004627E-18  -7.64369765674322E-03  -7.64369765674953E-03
      0.00000000000000E+00   0.00000000000000E+00   6.30881166682974E-12   0.00000000000000E+00   6.30881166682974E-12
      5.61323810515160E-18  -5.07328550002734E-01  -5.07285048138153E-01   0.00000000000000E+00  -3.57619805088544E-13
     -1.44287812811637E-22  -1.37739972005166E-10  -1.38097591810399E-10  -4.32620273510533E-18
      6.02058924687079E-07
      0.00000000000000E+00  -1.53748090085400E-13   0.00000000000000E+00   9.18906180752717E-16   1.36125981408488E-22
      1.53758866573798E-10   1.53759785480115E-10  -1.27741122756669E-18  -1.15644547164011E-02  -1.15644547164022E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18398077765734E-12   0.00000000000000E+00   1.18398077765734E-12
      5.61560606670692E-18  -5.18536330285230E-01  -5.18487522113439E-01   0.00000000000000E+00  -2.56945694311707E-13
     -1.45241647825159E-22  -1.54686820563315E-10  -1.54943766257772E-10  -4.33819483914023E-18
      6.04058924687079E-07
      0.00000000000000E+00  -2.16937269284178E-13   0.00000000000000E+00   2.48227564467810E-15   1.68502289272312E-22
      2.16923117566631E-10   2.16925599842444E-10  -1.25291055999882E-18  -2.20432924476072E-02  -2.20432924475955E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.16810657103522E-11   0.00000000000000E+00  -1.16810657103522E-11
      5.59224393528621E-18  -5.29426555544316E-01  -5.29361902764560E-01   0.00000000000000E+00   1.35743985905446E-14
     -1.45189305358078E-22  -2.05258108530537E-10  -2.05244534132092E-10  -4.33933337528740E-18
      6.06058924687079E-07
      0.00000000000000E+00  -3.54612530358261E-13   0.00000000000000E+00   4.76760593457049E-15   2.16165142403749E-22
      3.54601393395429E-10   3.54606161001579E-10  -1.21167181825727E-18  -3.92403378154087E-02  -3.92403378153821E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.65462380003549E-11   0.00000000000000E+00  -2.65462380003549E-11
      5.53915145928550E-18  -5.39864948877978E-01  -5.39761608665341E-01   0.00000000000000E+00   2.78342483845319E-13
     -1.44146712934037E-22  -3.28338265484926E-10  -3.28059923001224E-10  -4.32747964102823E-18
      6.07058924687079E-07
      0.00000000000000E+00  -4.56468343921408E-13   0.00000000000000E+00   6.41344751339716E-15   2.40417649876210E-22
      4.56486760606954E-10   4.56493174054708E-10  -1.18844607012132E-18  -4.86689322286629E-02  -4.86689322286311E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.17525794828773E-11   0.00000000000000E+00  -3.17525794828773E-11
      5.50739887980262E-18  -5.44937572254221E-01  -5.44803776849154E-01   0.00000000000000E+00   3.28889228364574E-13
     -1.43520979075364E-22  -4.25069483800053E-10  -4.24740594571832E-10  -4.31895280968131E-18
      6.08408924687079E-07
      0.00000000000000E+00  -6.43096849927102E-13   0.00000000000000E+00   8.16771573579167E-15   2.66256665463413E-22
      6.43107188403202E-10   6.43115356119204E-10  -1.15490126403090E-18  -6.20189464320401E-02  -6.20189464320037E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.63957046561028E-11   0.00000000000000E+00  -3.63957046561028E-11
      5.45826467851688E-18  -5.51454801368864E-01  -5.51263680768426E-01   0.00000000000000E+00   3.44805565112010E-13
     -1.42623364042960E-22  -6.07064457028070E-10  -6.06719651463101E-10  -4.30336341448599E-18
      6.10231424687079E-07
      0.00000000000000E+00  -1.00579171715963E-12   0.00000000000000E+00   1.10652860008040E-14   2.88168830731128E-22
      1.00582341212020E-09   1.00583447740649E-09  -1.10930501459975E-18  -8.01730474876441E-02  -8.01730474876036E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.05907185458762E-11   0.00000000000000E+00  -4.05907185458762E-11
      5.38428809396703E-18  -5.59461186076055E-01  -5.59157126249588E-01   0.00000000000000E+00   3.27303092327230E-13
     -1.41450979477106E-22  -9.65571061952802E-10  -9.65243758860617E-10  -4.27498307936728E-18
      6.12231424687079E-07
      0.00000000000000E+00  -1.59837396162259E-12   0.00000000000000E+00   1.57298628883414E-14   3.05261973231172E-22
      1.59834069413050E-09   1.59835642399370E-09  -1.06137163330947E-18  -9.98558259737839E-02  -9.98558259737391E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.48067102059742E-11   0.00000000000000E+00  -4.48067102059742E-11
      5.29467467355508E-18  -5.66934433135996E-01  -5.66445049170317E-01   0.00000000000000E+00   2.99386249172808E-13
     -1.40244752872487E-22  -1.55384910003676E-09  -1.55354971378772E-09  -4.23330304024560E-18
      6.14231424687079E-07
      0.00000000000000E+00  -2.45748963346179E-12   0.00000000000000E+00   2.21984255935319E-14   3.20467418445432E-22
      2.45743289110987E-09   2.45745508953579E-09  -1.01669692522348E-18  -1.19209635786565E-01  -1.19209635786515E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.96688080897073E-11   0.00000000000000E+00  -4.96688080897073E-11
      5.19533705737566E-18  -5.72604773677447E-01  -5.71846292530514E-01   0.00000000000000E+00   2.75689193026250E-13
     -1.39101987910345E-22  -2.40806197063897E-09  -2.40778628144608E-09  -4.17864013215218E-18
      6.16231424687079E-07
      0.00000000000000E+00  -3.64136829606681E-12   0.00000000000000E+00   3.01135218753259E-14   3.34142865326840E-22
      3.64134793608654E-09   3.64137804960875E-09  -9.75598442400438E-19  -1.38198352134718E-01  -1.38198352134663E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53826366000676E-11   0.00000000000000E+00  -5.53826366000676E-11
      5.08457178417553E-18  -5.75879181009744E-01  -5.74749544500356E-01   0.00000000000000E+00   2.62289260698420E-13
     -1.37981463522009E-22  -3.58625770226924E-09  -3.58599541300868E-09  -4.10897334177509E-18
      6.18231424687079E-07
      0.00000000000000E+00  -5.19391173382285E-12   0.00000000000000E+00   3.91182115689290E-14   3.45607709044310E-22
      5.19386872334713E-09   5.19390784155904E-09  -9.37825396300371E-19  -1.56810089567783E-01  -1.56810089567721E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.17401657331752E-11   0.00000000000000E+00  -6.17401657331752E-11
      4.96109145270918E-18  -5.76090678805673E-01  -5.74473969304743E-01   0.00000000000000E+00   2.67125439194284E-13
     -1.36806922057842E-22  -5.13243480126492E-09  -5.13216767582587E-09  -4.02326605640881E-18
      6.20231424687080E-07
      0.00000000000000E+00  -7.14359181526422E-12   0.00000000000000E+00   4.88270128840443E-14   3.54094782458130E-22
      7.14354356244369E-09   7.14359238945693E-09  -9.02845530338490E-19  -1.75044843867057E-01  -1.75044843866989E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82729672944522E-11   0.00000000000000E+00  -6.82729672944522E-11
      4.82454551812027E-18  -5.72528605778931E-01  -5.70299762085831E-01   0.00000000000000E+00   2.99601000562007E-13
     -1.35458059826121E-22  -7.07561902316289E-09  -7.07531942216247E-09  -3.92169998778178E-18
      6.22231424687080E-07
      0.00000000000000E+00  -9.51033884836498E-12   0.00000000000000E+00   5.90684938144303E-14   3.58960523391411E-22
      9.51026017921828E-09   9.51031924771245E-09  -8.70063359280341E-19  -1.92907781936611E-01  -1.92907781936537E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.44909415716022E-11   0.00000000000000E+00  -7.44909415716022E-11
      4.67556363497707E-18  -5.64455880443774E-01  -5.61483417107736E-01   0.00000000000000E+00   3.67036653390661E-13
     -1.33773683956519E-22  -9.43619534279411E-09  -9.43582830614085E-09  -3.80550027569673E-18
      6.24231424687080E-07
      0.00000000000000E+00  -1.23126136253038E-11   0.00000000000000E+00   6.96431521778429E-14   3.59639087255576E-22
      1.23125209264456E-08   1.23125905695981E-08  -8.38940823105694E-19  -2.10406090186603E-01  -2.10406090186523E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.00774414431847E-11   0.00000000000000E+00  -8.00774414431847E-11
      4.51540875209070E-18  -5.51112000899234E-01  -5.47258496503904E-01   0.00000000000000E+00   4.70167232584989E-13
     -1.31573725963740E-22  -1.22329832953874E-08  -1.22325131281549E-08  -3.67646792898501E-18
      6.26231424687080E-07
      0.00000000000000E+00  -1.55684177145734E-11   0.00000000000000E+00   8.09389886234161E-14   3.55484493442961E-22
      1.55683530756164E-08   1.55684340146054E-08  -8.09043361343050E-19  -2.27547468753567E-01  -2.27547468753482E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.49727652598177E-11   0.00000000000000E+00  -8.49727652598177E-11
      4.34546322157106E-18  -5.31714037535476E-01  -5.26836362477423E-01   0.00000000000000E+00   5.98365213283922E-13
     -1.28701596440511E-22  -1.54840596145587E-08  -1.54834612493455E-08  -3.53641986022801E-18
      6.28231424687080E-07
      0.00000000000000E+00  -1.92867519004202E-11   0.00000000000000E+00   9.23464431294372E-14   3.45559976699809E-22
      1.92866430967395E-08   1.92867354431830E-08  -7.80046648557365E-19  -2.44339375776719E-01  -2.44339375776630E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93426156377551E-11   0.00000000000000E+00  -8.93426156377551E-11
      4.16677799029555E-18  -5.05473791589633E-01  -4.99426056945479E-01   0.00000000000000E+00   7.31411977014061E-13
     -1.25073909208459E-22  -1.91981242395221E-08  -1.91973928275452E-08  -3.38673134173819E-18
      6.30231424687080E-07
      0.00000000000000E+00  -2.34514515090955E-11   0.00000000000000E+00   1.03379698436991E-13   3.28591407802618E-22
      2.34513321140768E-08   2.34514354937756E-08  -7.51723412419941E-19  -2.60788790261084E-01  -2.60788790260991E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.34312493698731E-11   0.00000000000000E+00  -9.34312493698731E-11
      3.97991549155581E-18  -4.71644347889357E-01  -4.64285789083685E-01   0.00000000000000E+00   8.45738658928781E-13
     -1.20703189180118E-22  -2.33588499830645E-08  -2.33580042444057E-08  -3.22819207913587E-18
      6.32231424687080E-07
      0.00000000000000E+00  -2.80099813509166E-11   0.00000000000000E+00   1.13139710126415E-13   3.03847550691825E-22
      2.80099282689639E-08   2.80100414086743E-08  -7.23910240528110E-19  -2.76902562379249E-01  -2.76902562379152E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.72919624401487E-11   0.00000000000000E+00  -9.72919624401487E-11
      3.78533156667551E-18  -4.29587984663368E-01  -4.20794380586572E-01   0.00000000000000E+00   9.29485341585662E-13
     -1.15636120197834E-22  -2.79136789315756E-08  -2.79127494462341E-08  -3.06142132614740E-18
      6.34231424687080E-07
      0.00000000000000E+00  -3.28747215465877E-11   0.00000000000000E+00   1.20751478299209E-13   2.73696787867238E-22
      3.28745963190219E-08   3.28747170705004E-08  -6.96465933810749E-19  -2.92688048569338E-01  -2.92688048569237E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00641538091596E-10   0.00000000000000E+00  -1.00641538091596E-10
      3.58404849049232E-18  -3.78847361557154E-01  -3.68522063554437E-01   0.00000000000000E+00   9.85868085105351E-13
     -1.09821204758445E-22  -3.27750614004938E-08  -3.27740755324088E-08  -2.88758255668157E-18
      6.36231424687080E-07
      0.00000000000000E+00  -3.78691465111958E-11   0.00000000000000E+00   1.24019501086623E-13   2.44879953405345E-22
      3.78690004516918E-08   3.78691244711932E-08  -6.69302426712854E-19  -3.08152250093333E-01  -3.08152250093229E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03619646374518E-10   0.00000000000000E+00  -1.03619646374518E-10
      3.37680919774328E-18  -3.19342454123328E-01  -3.07444406503538E-01   0.00000000000000E+00   9.97401545028910E-13
     -1.03026958803190E-22  -3.77665022263636E-08  -3.77655048248187E-08  -2.70750677103043E-18
      6.38231424687080E-07
      0.00000000000000E+00  -4.24607404584117E-11   0.00000000000000E+00   1.14105249009646E-13   2.20098442323381E-22
      4.24606424366962E-08   4.24607565419454E-08  -6.42552885018673E-19  -3.23297819410344E-01  -3.23297819410235E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08400932908318E-10   0.00000000000000E+00  -1.08400932908318E-10
      3.16000733192665E-18  -2.52063480079675E-01  -2.38720098649602E-01   0.00000000000000E+00   8.99792266101547E-13
     -9.49333444397321E-23  -4.23532554013031E-08  -4.23523556090371E-08  -2.51745444690798E-18
      6.40231424687080E-07
      0.00000000000000E+00  -4.56314044762899E-11   0.00000000000000E+00   7.89307999629321E-14   1.83182495954610E-22
      4.56313650655743E-08   4.56314439963745E-08  -6.16601760180374E-19  -3.38121292013813E-01  -3.38121292013695E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18101591363059E-10   0.00000000000000E+00  -1.18101591363059E-10
      2.92380414920053E-18  -1.79927995694973E-01  -1.65588517573171E-01   0.00000000000000E+00   6.86244009414051E-13
     -8.67349868329974E-23  -4.55140286490207E-08  -4.55133424050114E-08  -2.30720238902016E-18
      6.42231424687080E-07
      0.00000000000000E+00  -4.63241893290463E-11   0.00000000000000E+00   1.75017524906307E-14   1.20026780736131E-22
      4.63241623728057E-08   4.63241798745583E-08  -5.91506905009684E-19  -3.52628005012847E-01  -3.52628005012719E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28272308212164E-10   0.00000000000000E+00  -1.28272308212164E-10
      2.66725953277620E-18  -1.07840408184530E-01  -9.32857366173528E-02   0.00000000000000E+00   4.93708305861417E-13
     -7.76196782872675E-23  -4.61964012746519E-08  -4.61959075663461E-08  -2.07575262776652E-18
      6.44231424687080E-07
      0.00000000000000E+00  -3.87639897858087E-11   0.00000000000000E+00  -1.87195474437137E-13   5.30486906890678E-23
      3.87641225838610E-08   3.87639353883866E-08  -5.64883551666130E-19  -3.66858677946367E-01  -3.66858677946246E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20787422924207E-10   0.00000000000000E+00  -1.20787422924207E-10
      2.42568468692779E-18  -5.18759668409173E-02  -3.97008268514989E-02   0.00000000000000E+00   4.71423774376024E-13
     -4.66039034209774E-23  -3.86436193892367E-08  -3.86431479654624E-08  -1.86080113526166E-18
      6.46231424687080E-07
      0.00000000000000E+00  -2.47760363091024E-11   0.00000000000000E+00  -3.45597585676608E-13   2.05838845784308E-23
      2.47763485499532E-08   2.47760029523676E-08  -5.32945426844998E-19  -3.80872373637194E-01  -3.80872373637108E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.58629987445592E-11   0.00000000000000E+00  -8.58629987445592E-11
      2.25395868943867E-18  -2.42346391754730E-02  -1.64555961297178E-02   0.00000000000000E+00   4.66080770887073E-13
     -1.95806309255263E-23  -2.46906060343939E-08  -2.46901399536231E-08  -1.72101326259367E-18
      6.48231424687080E-07
      0.00000000000000E+00  -1.63517614782164E-11   0.00000000000000E+00  -2.07666993659788E-13   9.79136163371222E-24
      1.63519746081283E-08   1.63517669411347E-08  -4.99062051535278E-19  -3.94649629535317E-01  -3.94649629535254E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.30257322943071E-11   0.00000000000000E+00  -6.30257322943071E-11
      2.12790722485006E-18  -1.35246759148667E-02  -8.39262754270373E-03   0.00000000000000E+00   2.67210366864059E-13
     -1.01822563843248E-23  -1.62890084192072E-08  -1.62887412088404E-08  -1.62884517331478E-18
      6.50231424687080E-07
      0.00000000000000E+00  -1.29705893226586E-11   0.00000000000000E+00  -7.93621136136728E-14   6.16485275517160E-24
      1.29706666778070E-08   1.29705873156934E-08  -4.65361776481989E-19  -4.08166241342577E-01  -4.08166241342522E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.49028540384325E-11   0.00000000000000E+00  -5.49028540384325E-11
      2.01810151677319E-18  -9.59558269285506E-03  -5.52627151584064E-03   0.00000000000000E+00   1.18992106954874E-13
     -6.81002935429052E-24  -1.29158034537619E-08  -1.29156844616550E-08  -1.55273974029120E-18
      6.52231424687080E-07
      0.00000000000000E+00  -1.17954359100882E-11   0.00000000000000E+00  -2.86930031738570E-14   4.69101029106582E-24
      1.17954308664146E-08   1.17954021734114E-08  -4.32340574184713E-19  -4.21415395241372E-01  -4.21415395241319E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28562572660222E-11   0.00000000000000E+00  -5.28562572660222E-11
      1.91238900224115E-18  -8.02111732111217E-03  -4.32141999641313E-03   0.00000000000000E+00   6.07587392928809E-14
     -5.33759086217791E-24  -1.17426066748847E-08  -1.17425459161454E-08  -1.48004842805644E-18
      6.54231424687080E-07
      0.00000000000000E+00  -1.13955439242867E-11   0.00000000000000E+00  -9.59600195552390E-15   3.91557788644867E-24
      1.13955191125356E-08   1.13955095165336E-08  -4.00138451041497E-19  -4.34398380038278E-01  -4.34398380038225E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.28099858129248E-11   0.00000000000000E+00  -5.28099858129248E-11
      1.80676903061530E-18  -7.24828562355209E-03  -3.67456478196930E-03   0.00000000000000E+00   3.75644729434043E-14
     -4.49727030597478E-24  -1.13427370951937E-08  -1.13426995307207E-08  -1.40663057957380E-18
      6.56231424687080E-07
      0.00000000000000E+00  -1.12456533131640E-11   0.00000000000000E+00  -3.48379095744477E-15   3.41055209186283E-24
      1.12456704927325E-08   1.12456670089416E-08  -3.68834403931692E-19  -4.47119208481885E-01  -4.47119208481832E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.33444532659701E-11   0.00000000000000E+00  -5.33444532659701E-11
      1.70008012408336E-18  -6.77695817504683E-03  -3.25061435484921E-03   0.00000000000000E+00   2.85775299915404E-14
     -3.93815344250991E-24  -1.11923511332056E-08  -1.11923225556756E-08  -1.33124572015166E-18
      6.58231424687080E-07
      0.00000000000000E+00  -1.11769534497328E-11   0.00000000000000E+00  -3.18714517496229E-15   3.05010358666458E-24
      1.11769385728567E-08   1.11769353857115E-08  -3.38482752884374E-19  -4.59582655649995E-01  -4.59582655649941E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.39963415849413E-11   0.00000000000000E+00  -5.39963415849413E-11
      1.59208744091347E-18  -6.44510599377845E-03  -2.94062046805455E-03   0.00000000000000E+00   2.59595946028451E-14
     -3.50720439403706E-24  -1.11229650037212E-08  -1.11229390441266E-08  -1.25360468802910E-18
      6.60231424687080E-07
      0.00000000000000E+00  -1.11377357469451E-11   0.00000000000000E+00  -7.57853076930304E-16   2.84214569300752E-24
      1.11377322480634E-08   1.11377314902104E-08  -3.09114593385122E-19  -4.71793561246667E-01  -4.71793561246612E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.46099358052911E-11   0.00000000000000E+00  -5.46099358052911E-11
      1.48286756930289E-18  -6.19371445399279E-03  -2.70177315422615E-03   0.00000000000000E+00   2.15775011394145E-14
     -3.00912241798794E-24  -1.10831431319062E-08  -1.10831215544051E-08  -1.17375297591777E-18
      6.62231424687080E-07
      0.00000000000000E+00  -1.11118355310526E-11   0.00000000000000E+00  -4.46345900478330E-16   2.56076932389791E-24
      1.11117925021698E-08   1.11117920558239E-08  -2.80740250262414E-19  -4.83756430901345E-01  -4.83756430901290E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51271167487645E-11   0.00000000000000E+00  -5.51271167487645E-11
      1.37261333580536E-18  -5.99611575462910E-03  -2.51250870660978E-03   0.00000000000000E+00   1.95759786154646E-14
     -2.88900033927528E-24  -1.10566845150537E-08  -1.10566649390751E-08  -1.09187308554295E-18
      6.64231424687081E-07
      0.00000000000000E+00  -1.10931910493995E-11   0.00000000000000E+00  -2.78480507024212E-16   2.38639026729740E-24
      1.10932220288710E-08   1.10932217503905E-08  -2.53354743379626E-19  -4.95474759778638E-01  -4.95474759778582E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55214691819647E-11   0.00000000000000E+00  -5.55214691819647E-11
      1.26157039744143E-18  -5.83731380800861E-03  -2.35968066132619E-03   0.00000000000000E+00   1.79367996659899E-14
     -2.66071743028013E-24  -1.10377182180081E-08  -1.10377002812085E-08  -1.00821565406181E-18
      6.66231424687081E-07
      0.00000000000000E+00  -1.10793224940812E-11   0.00000000000000E+00  -1.75501036159183E-16   2.24313323208240E-24
      1.10793300135489E-08   1.10793298380479E-08  -2.26947217852881E-19  -5.06948775798052E-01  -5.06948775797996E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57699887841068E-11   0.00000000000000E+00  -5.57699887841068E-11
      1.15003041987322E-18  -5.70759763320954E-03  -2.23441854009041E-03   0.00000000000000E+00   1.65405588656037E-14
     -2.47060426728638E-24  -1.10235763898226E-08  -1.10235598492638E-08  -9.23083202020339E-19
      6.68231424687081E-07
      0.00000000000000E+00  -1.10685766598279E-11   0.00000000000000E+00  -1.10395964922257E-16   2.12357916330386E-24
      1.10685332465409E-08   1.10685331361450E-08  -2.01525745560761E-19  -5.18165940854079E-01  -5.18165940854023E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58080401734121E-11   0.00000000000000E+00  -5.58080401734121E-11
      1.03841433952640E-18  -5.60026170177938E-03  -2.13049523706618E-03   0.00000000000000E+00   1.53145771091741E-14
     -2.31085773602050E-24  -1.10127404105487E-08  -1.10127250959716E-08  -8.36888593965635E-19
      6.70231424687081E-07
      0.00000000000000E+00  -1.10595758755815E-11   0.00000000000000E+00  -7.64202762143952E-17   2.02281042074906E-24
      1.10595518348256E-08   1.10595517584053E-08  -1.77189053868406E-19  -5.29069094022646E-01  -5.29069094022591E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.54058654871989E-11   0.00000000000000E+00  -5.54058654871989E-11
      9.27602608551998E-19  -5.51067580055460E-03  -2.04361142862212E-03   0.00000000000000E+00   1.41708362029999E-14
     -2.17597266032001E-24  -1.10041600637543E-08  -1.10041458929181E-08  -7.50413554683592E-19
      6.72231424687081E-07
      0.00000000000000E+00  -1.10512180044957E-11   0.00000000000000E+00  -7.21064341693391E-17   1.93767662366678E-24
      1.10512057881759E-08   1.10512057160695E-08  -1.54187558782564E-19  -5.39526529581610E-01  -5.39526529581556E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.41603095588190E-11   0.00000000000000E+00  -5.41603095588190E-11
      8.19281989434360E-19  -5.43573650947125E-03  -1.97090859636712E-03   0.00000000000000E+00   1.30025859397810E-14
     -2.06233599826202E-24  -1.09970584090966E-08  -1.09970454065107E-08  -6.65094430651796E-19
      6.74231424687081E-07
      0.00000000000000E+00  -1.10425845991981E-11   0.00000000000000E+00  -9.24920573471952E-17   1.86615975115795E-24
      1.10426259252728E-08   1.10426258327807E-08  -1.32890567812608E-19  -5.49343616725933E-01  -5.49343616725881E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.17046969342948E-11   0.00000000000000E+00  -5.17046969342948E-11
      7.15872595565771E-19  -5.37333068562479E-03  -1.91043174390612E-03   0.00000000000000E+00   1.17431441673523E-14
     -1.96745482479524E-24  -1.09909328789906E-08  -1.09909211358464E-08  -5.82982027753162E-19
      6.76231424687081E-07
      0.00000000000000E+00  -1.10330327465286E-11   0.00000000000000E+00  -1.29581305388852E-16   1.80702696994057E-24
      1.10330453415797E-08   1.10330452119984E-08  -1.13797185103224E-19  -5.58256050192116E-01  -5.58256050192068E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.76251651787603E-11   0.00000000000000E+00  -4.76251651787603E-11
      6.20622265208250E-19  -5.32207108741386E-03  -1.86090480013479E-03   0.00000000000000E+00   1.03086658398501E-14
     -1.88977153132724E-24  -1.09854303554855E-08  -1.09854200468196E-08  -5.06825080105026E-19
      6.78231424687081E-07
      0.00000000000000E+00  -1.10215521543776E-11   0.00000000000000E+00  -1.93626135218812E-16   1.75977366560920E-24
      1.10215856518335E-08   1.10215854582073E-08  -9.75960569156426E-20  -5.65901080518248E-01  -5.65901080518207E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.13478449428145E-11   0.00000000000000E+00  -4.13478449428145E-11
      5.37926575322621E-19  -5.28124230813752E-03  -1.82170836072976E-03   0.00000000000000E+00   8.61120028143019E-15
     -1.82872176553146E-24  -1.09802462244648E-08  -1.09802376132645E-08  -4.40330518406977E-19
      6.80231424687081E-07
      0.00000000000000E+00  -1.10072243753733E-11   0.00000000000000E+00  -2.86858891878909E-16   1.72461643378040E-24
      1.10072258576343E-08   1.10072255707754E-08  -8.52016407580971E-20  -5.71800833717254E-01  -5.71800833717222E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.22097262918260E-11   0.00000000000000E+00  -3.22097262918260E-11
      4.73507122738969E-19  -5.25076863239728E-03  -1.79287954642915E-03   0.00000000000000E+00   6.53251981968966E-15
     -1.78475034197518E-24  -1.09750223770034E-08  -1.09750158444836E-08  -3.88305481980872E-19
      6.82231424687081E-07
      0.00000000000000E+00  -1.09889472726690E-11   0.00000000000000E+00  -4.09605247802256E-16   1.70251177108568E-24
      1.09889875929800E-08   1.09889871833747E-08  -7.77430351679263E-20  -5.75372024454084E-01  -5.75372024454064E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96237329883840E-11   0.00000000000000E+00  -1.96237329883840E-11
      4.34259656762201E-19  -5.23125023864529E-03  -1.77514183330951E-03   0.00000000000000E+00   3.95887936587634E-15
     -1.75936485292995E-24  -1.09693674092657E-08  -1.09693634503863E-08  -3.56516621594275E-19
      6.84231424687081E-07
      0.00000000000000E+00  -1.09660779331043E-11   0.00000000000000E+00  -6.83951201423412E-16   1.69527865580841E-24
      1.09660827790455E-08   1.09660820950943E-08  -7.65284460696930E-20  -5.75953995164863E-01  -5.75953995164860E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.21618640856007E-12   0.00000000000000E+00  -3.21618640856007E-12
      4.27827283945081E-19  -5.22409821441490E-03  -1.77003690774387E-03   0.00000000000000E+00   9.06594003526193E-16
     -1.75540628058435E-24  -1.09628668152797E-08  -1.09628659086857E-08  -3.51298837875388E-19
      6.86231424687081E-07
      0.00000000000000E+00  -1.09377897540444E-11   0.00000000000000E+00  -7.31384107263751E-16   1.70595133049235E-24
      1.09378360978193E-08   1.09378353664352E-08  -8.30210626280760E-20  -5.72839717172374E-01  -5.72839717172391E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71093946490594E-11   0.00000000000000E+00   1.71093946490594E-11
      4.62046073243200E-19  -5.23184349533589E-03  -1.78027811622244E-03   0.00000000000000E+00  -3.12148996066153E-15
     -1.77777105186755E-24  -1.09549416395943E-08  -1.09549447610842E-08  -3.79025010615123E-19
      6.88231424687081E-07
      0.00000000000000E+00  -1.09034398223287E-11   0.00000000000000E+00  -9.34550332073609E-16   1.73960294523898E-24
      1.09034245667806E-08   1.09034236322302E-08  -9.88613466774267E-20  -5.65294767314549E-01  -5.65294767314591E-01
      0.00000000000000E+00   0.00000000000000E+00   4.11773434237837E-11   0.00000000000000E+00   4.11773434237837E-11
      5.44400760090767E-19  -5.25892625340729E-03  -1.81062032790002E-03   0.00000000000000E+00  -7.92134167534610E-15
     -1.83509159959939E-24  -1.09445930543123E-08  -1.09446009756540E-08  -4.45539413413340E-19
      6.90231424687081E-07
      0.00000000000000E+00  -1.08613749326877E-11   0.00000000000000E+00  -2.79946992759004E-15   1.80507902502643E-24
      1.08613464153634E-08   1.08613436158935E-08  -1.25950174188958E-19  -5.52561437390319E-01  -5.52561437390388E-01
      0.00000000000000E+00   0.00000000000000E+00   6.85263955848720E-11   0.00000000000000E+00   6.85263955848720E-11
      6.81453551260511E-19  -5.31353899674241E-03  -1.86987462857161E-03   0.00000000000000E+00  -1.22962690723616E-14
     -1.94355576936096E-24  -1.09298577152093E-08  -1.09298700114784E-08  -5.55503377071555E-19
      6.92231424687081E-07
      0.00000000000000E+00  -1.08082886745817E-11   0.00000000000000E+00  -1.55101469203280E-15   1.91864343378399E-24
      1.08082607598930E-08   1.08082592088783E-08  -1.66583487222347E-19  -5.33859052393891E-01  -5.33859052393989E-01
      0.00000000000000E+00   0.00000000000000E+00   9.82629116639005E-11   0.00000000000000E+00   9.82629116639005E-11
      8.77979374588313E-19  -5.41199006034472E-03  -1.97568352854668E-03   0.00000000000000E+00  -2.15837714539287E-14
     -2.13630479504302E-24  -1.09065005367708E-08  -1.09065221205422E-08  -7.11395887365965E-19
      6.94231424687081E-07
      0.00000000000000E+00  -1.07357313321878E-11   0.00000000000000E+00  -1.41088704189519E-13   2.11188676377354E-24
      1.07357807751608E-08   1.07356396864566E-08  -2.23599608975337E-19  -5.08398553446819E-01  -5.08398553446947E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28703982666981E-10   0.00000000000000E+00   1.28703982666981E-10
      1.13538733992227E-18  -5.58994517655239E-03  -2.16688614122335E-03   0.00000000000000E+00   1.07070407291643E-13
     -2.49017509394769E-24  -1.08644507395309E-08  -1.08643436691236E-08  -9.11787730946936E-19
      6.96231424687081E-07
      0.00000000000000E+00  -1.06196395843575E-11   0.00000000000000E+00  -5.05076385474056E-15   2.44822807444566E-24
      1.06196482335866E-08   1.06196431828227E-08  -3.00399817582636E-19  -4.75425670439172E-01  -4.75425670439328E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56879401096185E-10   0.00000000000000E+00   1.56879401096185E-10
      1.44914614211464E-18  -5.93557279539982E-03  -2.54023009053735E-03   0.00000000000000E+00  -4.47487158010125E-14
     -3.21788451249592E-24  -1.07764778352031E-08  -1.07765225839189E-08  -1.14874632453201E-18
      6.98231424687081E-07
      0.00000000000000E+00  -1.03779960807645E-11   0.00000000000000E+00  -6.84973333958084E-15   3.03938632197460E-24
      1.03779963825568E-08   1.03779895328235E-08  -4.00325962447117E-19  -4.34287645816326E-01  -4.34287645816504E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78527478768533E-10   0.00000000000000E+00   1.78527478768533E-10
      1.80620109965171E-18  -6.70359453945595E-03  -3.37757438615877E-03   0.00000000000000E+00  -6.80023692778272E-14
     -5.06218000868554E-24  -1.05564490092227E-08  -1.05565170115920E-08  -1.40587513720459E-18
      7.00231424687081E-07
      0.00000000000000E+00  -9.69999823069852E-12   0.00000000000000E+00  -1.78562242214615E-14   3.84195876994491E-24
      9.70000337183777E-09   9.69998551561355E-09  -5.23941255290392E-19  -3.84502902343639E-01  -3.84502902343830E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91082425935312E-10   0.00000000000000E+00   1.91082425935312E-10
      2.18836595152233E-18  -8.75603667457665E-03  -5.63968635433841E-03   0.00000000000000E+00  -1.00848769962832E-13
     -1.11829844223803E-23  -9.89096709277888E-09  -9.89106794154885E-09  -1.66442469623194E-18
      7.02231424687081E-07
      0.00000000000000E+00  -7.58876325650911E-12   0.00000000000000E+00  -1.00113900315235E-13   2.36107382483808E-24
      7.58875663017454E-09   7.58865651627423E-09  -6.63344391666669E-19  -3.25929794533869E-01  -3.25929794534074E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04087093767467E-10   0.00000000000000E+00   2.04087093767467E-10
      2.59654013905727E-18  -1.48669896644176E-02  -1.24117483712010E-02   0.00000000000000E+00  -9.95932343694742E-14
     -3.27795982913300E-23  -7.79264401680729E-09  -7.79274361004169E-09  -1.93319574739060E-18
      7.04231424687081E-07
      0.00000000000000E+00  -3.61418225385339E-12   0.00000000000000E+00  -1.00453705254241E-13  -1.09690011828897E-23
      3.61433087508964E-09   3.61423042138438E-09  -8.05965792190909E-19  -2.59394731286625E-01  -2.59394731286855E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30798534754661E-10   0.00000000000000E+00   2.30798534754661E-10
      3.05813720856659E-18  -2.85688021864924E-02  -2.73573732462690E-02   0.00000000000000E+00  -2.31862064974138E-13
     -6.79904970210853E-23  -3.84479709407399E-09  -3.84502895613904E-09  -2.25217141637568E-18
      7.06231424687081E-07
      0.00000000000000E+00  -9.33234374765679E-13   0.00000000000000E+00  -6.94308089920729E-14  -3.11279422405456E-23
      9.33299378492745E-10   9.33229947683722E-10  -9.50977634126119E-19  -1.87614822559653E-01  -1.87614822559898E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44824698810470E-10   0.00000000000000E+00   2.44824698810470E-10
      3.54778660618753E-18  -4.72070167686763E-02  -4.68358575956924E-02   0.00000000000000E+00  -4.29308013533500E-13
     -8.52222370524699E-23  -1.17762533848057E-09  -1.17805464649419E-09  -2.59680897206141E-18
      7.08231424687081E-07
      0.00000000000000E+00  -1.16918350465182E-13   0.00000000000000E+00  -2.43900586238036E-14  -4.21969757687508E-23
      1.16984240736519E-10   1.16959850677853E-10  -1.09788726148158E-18  -1.15121298299342E-01  -1.15121298299575E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33319811553126E-10   0.00000000000000E+00   2.33319811553126E-10
      4.01442622929378E-18  -6.70899792710779E-02  -6.69796204025343E-02   0.00000000000000E+00  -6.75452314787251E-13
     -9.24818503547602E-23  -3.49604209916100E-10  -3.50279662230980E-10  -2.91653896781221E-18
      7.10231424687082E-07
      0.00000000000000E+00   2.51654579948623E-14   0.00000000000000E+00  -7.65681301804564E-15  -4.53187693696445E-23
     -2.51534820443286E-11  -2.51611388573919E-11  -1.21766799160945E-18  -5.63511765350918E-02  -5.63511765352787E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86919338698644E-10   0.00000000000000E+00   1.86919338698644E-10
      4.38826490669107E-18  -8.69440218914918E-02  -8.68930584991519E-02   0.00000000000000E+00  -7.77343549459639E-13
     -9.91919516822811E-23  -1.60980856291693E-10  -1.61758199841252E-10  -3.17059691508162E-18
      7.12231424687082E-07
      0.00000000000000E+00   1.68994316461849E-14   0.00000000000000E+00  -1.82972713645916E-15  -4.59860502773307E-23
     -1.68808418956529E-11  -1.68826716228354E-11  -1.28127885634527E-18  -2.61112910070613E-02  -2.61112910071793E-02
      0.00000000000000E+00   0.00000000000000E+00   1.17988690235066E-10   0.00000000000000E+00   1.17988690235066E-10
      4.62424228716121E-18  -1.06518932828529E-01  -1.06487078629773E-01   0.00000000000000E+00  -5.60677836821387E-13
     -1.03305445973836E-22  -1.00545340775306E-10  -1.01106018612231E-10  -3.34296343081593E-18
      7.14231424687082E-07
      0.00000000000000E+00  -3.30641053947096E-15   0.00000000000000E+00   5.46315756793124E-17  -4.58824241955310E-23
      3.35130651685248E-12   3.35136114838228E-12  -1.30815259718903E-18  -1.42152943226308E-02  -1.42152943227031E-02
      0.00000000000000E+00   0.00000000000000E+00   7.23040351513604E-11   0.00000000000000E+00   7.23040351513604E-11
      4.76885035746392E-18  -1.25749733318053E-01  -1.25725897724791E-01   0.00000000000000E+00  -3.62980244404274E-13
     -1.05678601212616E-22  -7.52924160552323E-11  -7.56553962997422E-11  -3.46069776027489E-18
      7.16231424687082E-07
      0.00000000000000E+00  -1.76341895438451E-14   0.00000000000000E+00   2.08788939826911E-15  -4.51774405914029E-23
      1.76463048337461E-11   1.76483927230992E-11  -1.31836318462927E-18  -9.85543940479998E-03  -9.85543940484875E-03
      0.00000000000000E+00   0.00000000000000E+00   4.87674727967261E-11   0.00000000000000E+00   4.87674727967261E-11
      4.86638530305738E-18  -1.44609809416456E-01  -1.44588885439509E-01   0.00000000000000E+00  -2.87700131744242E-13
     -1.07434180863282E-22  -6.61281653879740E-11  -6.64158655198256E-11  -3.54802211842810E-18
      7.18231424687082E-07
      0.00000000000000E+00  -2.74615764250505E-14   0.00000000000000E+00   4.73515340643733E-16  -4.36387053811443E-23
      2.75108926099797E-11   2.75113661252767E-11  -1.32162487978757E-18  -8.13544592995723E-03  -8.13544592999368E-03
      0.00000000000000E+00   0.00000000000000E+00   3.64520974820759E-11   0.00000000000000E+00   3.64520974820759E-11
      4.93928949802153E-18  -1.63092152514374E-01  -1.63072000781806E-01   0.00000000000000E+00  -2.70825693465739E-13
     -1.09027156390585E-22  -6.36926379137774E-11  -6.39634636073522E-11  -3.61766461823396E-18
      7.20231424687082E-07
      0.00000000000000E+00  -3.48091554016526E-14   0.00000000000000E+00   3.81672246329671E-16  -4.08788898461713E-23
      3.48446983578047E-11   3.48450800300101E-11  -1.32197359614099E-18  -7.31137285300227E-03  -7.31137285303161E-03
      0.00000000000000E+00   0.00000000000000E+00   2.93364692954991E-11   0.00000000000000E+00   2.93364692954991E-11
      4.99796243661253E-18  -1.81198951267206E-01  -1.81178730930958E-01   0.00000000000000E+00  -2.75201901913893E-13
     -1.10589152511786E-22  -6.39063474234850E-11  -6.41815493255095E-11  -3.67598884047154E-18
      7.22231424687082E-07
      0.00000000000000E+00  -4.06872185829343E-14   0.00000000000000E+00   2.97355739435824E-16  -3.64724922234626E-23
      4.07067211131296E-11   4.07070184688326E-11  -1.32107504567654E-18  -6.81881164316808E-03  -6.81881164319289E-03
      0.00000000000000E+00   0.00000000000000E+00   2.48071276650035E-11   0.00000000000000E+00   2.48071276650035E-11
      5.04757669194254E-18  -1.98936272387128E-01  -1.98915632322866E-01   0.00000000000000E+00  -2.83150936669399E-13
     -1.12147406606091E-22  -6.52309951970550E-11  -6.55141461338365E-11  -3.72650164626599E-18
      7.24231424687082E-07
      0.00000000000000E+00  -4.56468343921408E-14   0.00000000000000E+00   2.37805010981849E-16  -3.00150857770598E-23
      4.56837747508631E-11   4.56840125558441E-11  -1.31965093556879E-18  -6.47588761695137E-03  -6.47588761697310E-03
      0.00000000000000E+00   0.00000000000000E+00   2.17297423972646E-11   0.00000000000000E+00   2.17297423972646E-11
      5.09103617673706E-18  -2.16311590492720E-01  -2.16290352072544E-01   0.00000000000000E+00  -2.90053351499592E-13
     -1.13700840624983E-22  -6.71237016014945E-11  -6.74137549531078E-11  -3.77138524116827E-18
      7.26231424687082E-07
      0.00000000000000E+00  -5.01472265153096E-14   0.00000000000000E+00   1.99013351229408E-16  -2.12225173691147E-23
      5.01233604944771E-11   5.01235595078071E-11  -1.31803022267172E-18  -6.21752985066701E-03  -6.21752985068657E-03
      0.00000000000000E+00   0.00000000000000E+00   1.95529828795940E-11   0.00000000000000E+00   1.95529828795940E-11
      5.13014214249625E-18  -2.33332579218217E-01  -2.33310628034297E-01   0.00000000000000E+00  -2.95126922495926E-13
     -1.15243943466652E-22  -6.93814154647902E-11  -6.96765423874013E-11  -3.81211191982454E-18
      7.28231424687082E-07
      0.00000000000000E+00  -5.42802396896483E-14   0.00000000000000E+00   1.74399825071225E-16  -1.00580798654115E-23
      5.42359293057694E-11   5.42361037055844E-11  -1.31636532924424E-18  -6.01505759224813E-03  -6.01505759226610E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79673674477280E-11   0.00000000000000E+00   1.79673674477280E-11
      5.16607687739171E-18  -2.50006533849774E-01  -2.49983786697050E-01   0.00000000000000E+00  -2.98659460267514E-13
     -1.16772387448869E-22  -7.19048116929289E-11  -7.22034711533132E-11  -3.84971154814747E-18
      7.30231424687082E-07
      0.00000000000000E+00  -5.81377186523644E-14   0.00000000000000E+00   1.58762476288339E-16   3.13535138810289E-24
      5.81467004580636E-11   5.81468592205430E-11  -1.31472428575249E-18  -5.85266224477611E-03  -5.85266224479289E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67795720285891E-11   0.00000000000000E+00   1.67795720285891E-11
      5.19963602144889E-18  -2.66340321868494E-01  -2.66316717000116E-01   0.00000000000000E+00  -3.01154610938017E-13
     -1.18284016128096E-22  -7.46252766380752E-11  -7.49264312491315E-11  -3.88491173569639E-18
      7.32231424687082E-07
      0.00000000000000E+00  -6.19033528778730E-14   0.00000000000000E+00   1.48664360689201E-16   1.71873882828369E-23
      6.19303918355037E-11   6.19305404998816E-11  -1.31313390690541E-18  -5.72021724447745E-03  -5.72021724449331E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58620506435562E-11   0.00000000000000E+00   1.58620506435562E-11
      5.23136012273600E-18  -2.82340919974121E-01  -2.82316412287233E-01   0.00000000000000E+00  -3.03102489867452E-13
     -1.19778635041216E-22  -7.74894886534497E-11  -7.77925911434369E-11  -3.91822621583058E-18
      7.34231424687082E-07
      0.00000000000000E+00  -6.56689871033816E-14   0.00000000000000E+00   1.42018329292760E-16   3.11519763965117E-23
      6.56340145676857E-11   6.56341565860461E-11  -1.31160127936329E-18  -5.61075642492335E-03  -5.61075642493848E-03
      0.00000000000000E+00   0.00000000000000E+00   1.51285790054007E-11   0.00000000000000E+00   1.51285790054007E-11
      5.26161728074680E-18  -2.98015815027463E-01  -2.97990371773086E-01   0.00000000000000E+00  -3.04919033181125E-13
     -1.21257494151666E-22  -8.04578165581457E-11  -8.07627355914481E-11  -3.95001600138351E-18
      7.36231424687082E-07
      0.00000000000000E+00  -6.92509318544752E-14   0.00000000000000E+00   1.37563781209917E-16   4.43864011810096E-23
      6.92886321409865E-11   6.92887697048121E-11  -1.31012462607550E-18  -5.51945651482877E-03  -5.51945651484329E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45184383365003E-11   0.00000000000000E+00   1.45184383365003E-11
      5.29065415741980E-18  -3.13371061774977E-01  -3.13344659546882E-01   0.00000000000000E+00  -3.06882330440208E-13
     -1.22722859637574E-22  -8.35003257107493E-11  -8.38072080413122E-11  -3.98052953134430E-18
      7.38231424687082E-07
      0.00000000000000E+00  -7.29247213427762E-14   0.00000000000000E+00   1.34481934953181E-16   5.64055298180515E-23
      7.29140428037279E-11   7.29141772857193E-11  -1.30869895455590E-18  -5.44307989272026E-03  -5.44307989273425E-03
      0.00000000000000E+00   0.00000000000000E+00   1.39858465071073E-11   0.00000000000000E+00   1.39858465071073E-11
      5.31862585043401E-18  -3.28406905809959E-01  -3.28379529388120E-01   0.00000000000000E+00  -3.09073681608162E-13
     -1.24176918507648E-22  -8.65909501110938E-11  -8.69000237928262E-11  -4.00992689587811E-18
      7.40231424687082E-07
      0.00000000000000E+00  -7.65066660938698E-14   0.00000000000000E+00   1.32237245605763E-16   6.69367903930672E-23
      7.65219317085498E-11   7.65220639458624E-11  -1.30731879791992E-18  -5.37942714002065E-03  -5.37942714003415E-03
      0.00000000000000E+00   0.00000000000000E+00   1.35000807354099E-11   0.00000000000000E+00   1.35000807354099E-11
      5.34562601190483E-18  -3.43120353313756E-01  -3.43091993476059E-01   0.00000000000000E+00  -3.11562933438598E-13
     -1.25621841695614E-22  -8.97105817477084E-11  -9.00221446812726E-11  -4.03830721398491E-18
      7.42231424687082E-07
      0.00000000000000E+00  -8.00886108449633E-14   0.00000000000000E+00   1.30648938362513E-16   7.59171854792346E-23
      8.01228116221400E-11   8.01229422711543E-11  -1.30597799595817E-18  -5.32703905525642E-03  -5.32703905526948E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30545783349089E-11   0.00000000000000E+00   1.30545783349089E-11
      5.37173516857465E-18  -3.57524531412618E-01  -3.57495177692723E-01   0.00000000000000E+00  -3.14889019830015E-13
     -1.27062005657797E-22  -9.28626315861049E-11  -9.31775206060620E-11  -4.06575717261648E-18
      7.44231424687082E-07
      0.00000000000000E+00  -8.37624003332644E-14   0.00000000000000E+00   1.29928413405385E-16   8.34482354525947E-23
      8.37345189463304E-11   8.37346488748273E-11  -1.30466753728603E-18  -5.28513019012068E-03  -5.28513019013336E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26721100496792E-11   0.00000000000000E+00   1.26721100496792E-11
      5.39707938867401E-18  -3.71678687878674E-01  -3.71648317017570E-01   0.00000000000000E+00  -3.20455906784511E-13
     -1.28507695992512E-22  -9.60863030175944E-11  -9.64067589245074E-11  -4.09241185138798E-18
      7.46231424687082E-07
      0.00000000000000E+00  -8.73443450843579E-14   0.00000000000000E+00   1.29761766815966E-16   8.97147921474388E-23
      8.73680231299109E-11   8.73681528917675E-11  -1.30338018648540E-18  -5.25355934838969E-03  -5.25355934840201E-03
      0.00000000000000E+00   0.00000000000000E+00   1.23240355526163E-11   0.00000000000000E+00   1.23240355526163E-11
      5.42172745977924E-18  -3.85615431056263E-01  -3.85584025363948E-01   0.00000000000000E+00  -3.27587868106137E-13
     -1.29965440190406E-22  -9.93646005761480E-11  -9.96921884443841E-11  -4.11834727329385E-18
      7.48231424687082E-07
      0.00000000000000E+00  -9.10181345726590E-14   0.00000000000000E+00   1.29529469935651E-16   9.49210137872699E-23
      9.10175233394533E-11   9.10176528690182E-11  -1.30211294702567E-18  -5.23285107798868E-03  -5.23285107800064E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19563077934739E-11   0.00000000000000E+00   1.19563077934739E-11
      5.44564007536619E-18  -3.99305168815854E-01  -3.99272729458671E-01   0.00000000000000E+00  -3.34442961966229E-13
     -1.31433111754430E-22  -1.02639517700395E-10  -1.02973960662492E-10  -4.14352712834053E-18
      7.50231424687082E-07
      0.00000000000000E+00  -9.46919240609601E-14   0.00000000000000E+00   1.29402252598365E-16   9.92694324322663E-23
      9.46815015904901E-11   9.46816309928419E-11  -1.30086173234934E-18  -5.22432344727315E-03  -5.22432344728473E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15717693363350E-11   0.00000000000000E+00   1.15717693363350E-11
      5.46878361403886E-18  -4.12730441417687E-01  -4.12696969144726E-01   0.00000000000000E+00  -3.41382399120414E-13
     -1.32910067310330E-22  -1.05912017929924E-10  -1.06253400329177E-10  -4.16792188168951E-18
      7.52231424687082E-07
      0.00000000000000E+00  -9.83657135492612E-14   0.00000000000000E+00   1.29638108240399E-16   1.02942891921316E-22
      9.83643849662343E-11   9.83645146044455E-11  -1.29961992356040E-18  -5.23036671809312E-03  -5.23036671810430E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11774588601677E-11   0.00000000000000E+00   1.11774588601677E-11
      5.49113853175920E-18  -4.25888157143287E-01  -4.25853649091723E-01   0.00000000000000E+00  -3.48761630197148E-13
     -1.34396916729588E-22  -1.09193211834282E-10  -1.09541973464613E-10  -4.19151860819880E-18
      7.54231424687083E-07
      0.00000000000000E+00  -1.02039503037562E-13   0.00000000000000E+00   1.30581897737880E-16   1.06097809154993E-22
      1.02078090704217E-10   1.02078221286221E-10  -1.29837691256341E-18  -5.25516475175920E-03  -5.25516475176998E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07742915016288E-11   0.00000000000000E+00   1.07742915016288E-11
      5.51268711476246E-18  -4.38780911276611E-01  -4.38745360541653E-01   0.00000000000000E+00  -3.56598195494400E-13
     -1.35894022113287E-22  -1.12495914592219E-10  -1.12852512787849E-10  -4.21431020219904E-18
      7.56231424687083E-07
      0.00000000000000E+00  -1.05805137263071E-13   0.00000000000000E+00   1.32889784603330E-16   1.08868362763395E-22
      1.05848707221275E-10   1.05848840111169E-10  -1.29711438461813E-18  -5.30638559260723E-03  -5.30638559261759E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03579135904295E-11   0.00000000000000E+00   1.03579135904295E-11
      5.53340294194331E-18  -4.51413104789409E-01  -4.51376497620101E-01   0.00000000000000E+00  -3.64699510094582E-13
     -1.37400564619742E-22  -1.15842054191367E-10  -1.16206753701599E-10  -4.23628855732518E-18
      7.58231424687083E-07
      0.00000000000000E+00  -1.09754460962994E-13   0.00000000000000E+00   1.38095963624537E-16   1.11380789923855E-22
      1.09733236927634E-10   1.09733375023709E-10  -1.29579744411769E-18  -5.39916265582915E-03  -5.39916265583906E-03
      0.00000000000000E+00   0.00000000000000E+00   9.91597810306575E-12   0.00000000000000E+00   9.91597810306575E-12
      5.55323489814944E-18  -4.63789585169392E-01  -4.63751893748289E-01   0.00000000000000E+00  -3.72652099978699E-13
     -1.38913734839554E-22  -1.19276701026657E-10  -1.19649353126775E-10  -4.25743745403175E-18
      7.60231424687083E-07
      0.00000000000000E+00  -1.13887474137333E-13   0.00000000000000E+00   1.49325843034113E-16   1.13785872534695E-22
      1.13863311486197E-10   1.13863460812154E-10  -1.29435210270319E-18  -5.56624419403261E-03  -5.56624419404203E-03
      0.00000000000000E+00   0.00000000000000E+00   9.41720437272179E-12   0.00000000000000E+00   9.41720437272179E-12
      5.57206930689489E-18  -4.75915122597416E-01  -4.75876287495646E-01   0.00000000000000E+00  -3.79588966365983E-13
     -1.40427126433967E-22  -1.22901076218369E-10  -1.23280665184875E-10  -4.27771720419170E-18
      7.62231424687083E-07
      0.00000000000000E+00  -1.18571555734917E-13   0.00000000000000E+00   1.76141264427895E-16   1.16346198918904E-22
      1.18575822006469E-10   1.18575998147850E-10  -1.29260038617177E-18  -5.88741662429798E-03  -5.88741662430676E-03
      0.00000000000000E+00   0.00000000000000E+00   8.77587774353155E-12   0.00000000000000E+00   8.77587774353155E-12
      5.58962106238195E-18  -4.87793985543434E-01  -4.87753868208588E-01   0.00000000000000E+00  -3.83382390777672E-13
     -1.41926250527828E-22  -1.26968493500461E-10  -1.27351875891381E-10  -4.29702067621018E-18
      7.64231424687083E-07
      0.00000000000000E+00  -1.24816997865029E-13   0.00000000000000E+00   2.50533954505570E-16   1.19730960366737E-22
      1.24876240180817E-10   1.24876490714891E-10  -1.29004107566168E-18  -6.58926422470603E-03  -6.58926422471375E-03
      0.00000000000000E+00   0.00000000000000E+00   7.72231232877676E-12   0.00000000000000E+00   7.72231232877676E-12
      5.60506568703950E-18  -4.99428959918600E-01  -4.99387190016186E-01   0.00000000000000E+00  -3.77633381379371E-13
     -1.43373272080332E-22  -1.32221169662146E-10  -1.32598803043669E-10  -4.31502461137782E-18
      7.66231424687083E-07
      0.00000000000000E+00  -1.36389434753177E-13   0.00000000000000E+00   4.77422054520030E-16   1.26186184472044E-22
      1.36370081034846E-10   1.36370558457026E-10  -1.28500495748025E-18  -8.42865939024022E-03  -8.42865939024550E-03
      0.00000000000000E+00   0.00000000000000E+00   5.27858859596328E-12   0.00000000000000E+00   5.27858859596328E-12
      5.61562286423143E-18  -5.10817682576986E-01  -5.10773062045295E-01   0.00000000000000E+00  -3.39347721931619E-13
     -1.44647976059797E-22  -1.41309799330914E-10  -1.41649147052990E-10  -4.33061790675118E-18
      7.68231424687083E-07
      0.00000000000000E+00  -1.66973732243284E-13   0.00000000000000E+00   1.26667471780014E-15   1.43454755705687E-22
      1.66949071969912E-10   1.66950338644773E-10  -1.27189506907623E-18  -1.39142142415171E-02  -1.39142142415153E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.84952751468655E-12   0.00000000000000E+00  -1.84952751468655E-12
      5.61192380920206E-18  -5.21937259696111E-01  -5.21885252123229E-01   0.00000000000000E+00  -1.92771590494151E-13
     -1.45360507859615E-22  -1.64908039539448E-10  -1.65100811130087E-10  -4.34002874012583E-18
      7.70231424687083E-07
      0.00000000000000E+00  -2.50460598364925E-13   0.00000000000000E+00   3.16975526368848E-15   1.82795312798414E-22
      2.50469199935689E-10   2.50472369691135E-10  -1.24157603246420E-18  -2.68450306295619E-02  -2.68450306295452E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.67318149981389E-11   0.00000000000000E+00  -1.67318149981389E-11
      5.57846017920578E-18  -5.32705487568820E-01  -5.32631858480877E-01   0.00000000000000E+00   1.13494905232453E-13
     -1.44938039649402E-22  -2.33854049598083E-10  -2.33740554692996E-10  -4.33688414674158E-18
      7.72231424687083E-07
      0.00000000000000E+00  -4.15689280601266E-13   0.00000000000000E+00   5.48534197686382E-15   2.29931175532350E-22
      4.15692972114771E-10   4.15698457456978E-10  -1.19700913378025E-18  -4.51917880314917E-02  -4.51917880314619E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.98199841836866E-11   0.00000000000000E+00  -2.98199841836866E-11
      5.51882021083841E-18  -5.42967446663538E-01  -5.42845893153505E-01   0.00000000000000E+00   3.17342584672873E-13
     -1.43742415152785E-22  -3.86195815857821E-10  -3.85878473273292E-10  -4.32181107705815E-18
      7.74231424687083E-07
      0.00000000000000E+00  -6.91499026435469E-13   0.00000000000000E+00   8.15159345594523E-15   2.65216354509302E-22
      6.91466377224987E-10   6.91474528818708E-10  -1.14730127636485E-18  -6.50357015258132E-02  -6.50357015257764E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.68152762798535E-11   0.00000000000000E+00  -3.68152762798535E-11
      5.44518965827870E-18  -5.52506977202979E-01  -5.52300755087336E-01   0.00000000000000E+00   3.47840900011450E-13
     -1.42401569686278E-22  -6.55007093438723E-10  -6.54659252538854E-10  -4.29788838191385E-18
      7.76231424687083E-07
      0.00000000000000E+00  -1.12427142815733E-12   0.00000000000000E+00   1.18856512199286E-14   2.88956565787855E-22
      1.12423317240136E-09   1.12424505805287E-09  -1.09766898285793E-18  -8.49114178029533E-02  -8.49114178029120E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.13426199023728E-11   0.00000000000000E+00  -4.13426199023728E-11
      5.36250441847395E-18  -5.61029109537947E-01  -5.60687985704790E-01   0.00000000000000E+00   3.23073701421304E-13
     -1.41124961040662E-22  -1.08322551185178E-09  -1.08290243815050E-09  -4.26483543561602E-18
      7.78231424687083E-07
      0.00000000000000E+00  -1.77453216758662E-12   0.00000000000000E+00   1.71301310711575E-14   3.07247865368277E-22
      1.77451979106472E-09   1.77453692119609E-09  -1.05043920393618E-18  -1.04518997019419E-01  -1.04518997019373E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57606086182024E-11   0.00000000000000E+00  -4.57606086182024E-11
      5.27098320123755E-18  -5.68131820611238E-01  -5.67587237703762E-01   0.00000000000000E+00   2.94294409029507E-13
     -1.39930798803771E-22  -1.72907060698678E-09  -1.72877631257789E-09  -4.22054399730137E-18
      7.80231424687083E-07
      0.00000000000000E+00  -2.70620518181978E-12   0.00000000000000E+00   2.39662395326278E-14   3.23011491413784E-22
      2.70621464354992E-09   2.70623860978978E-09  -1.00659814279268E-18  -1.23786913545731E-01  -1.23786913545680E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08720340389660E-11   0.00000000000000E+00  -5.08720340389660E-11
      5.16923913315962E-18  -5.73298557402864E-01  -5.72462084416361E-01   0.00000000000000E+00   2.71853012182918E-13
     -1.38795284921301E-22  -2.65563842876285E-09  -2.65536657575081E-09  -4.16264099036694E-18
      7.82231424687083E-07
      0.00000000000000E+00  -3.97467284739293E-12   0.00000000000000E+00   3.21776518086215E-14   3.36644893649689E-22
      3.97467851968486E-09   3.97471069733701E-09  -9.66316119687435E-19  -1.42685705030586E-01  -1.42685705030529E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68008361409630E-11   0.00000000000000E+00  -5.68008361409630E-11
      5.05563746087769E-18  -5.75915619542495E-01  -5.74681423914254E-01   0.00000000000000E+00   2.61598373373162E-13
     -1.37669050853825E-22  -3.91817145956928E-09  -3.91790986119604E-09  -4.08932134119025E-18
      7.84231424687083E-07
      0.00000000000000E+00  -5.61979578025415E-12   0.00000000000000E+00   4.13686331819353E-14   3.47657660949876E-22
      5.61975805908946E-09   5.61979942772299E-09  -9.29253673123650E-19  -1.61206932660968E-01  -1.61206932660905E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.32659942886704E-11   0.00000000000000E+00  -6.32659942886704E-11
      4.92910547230035E-18  -5.75303209357608E-01  -5.73552815844216E-01   0.00000000000000E+00   2.71938927472352E-13
     -1.36465270822539E-22  -5.55680537236165E-09  -5.55653343343432E-09  -3.99985179917670E-18
      7.86231424687083E-07
      0.00000000000000E+00  -7.66719866208433E-12   0.00000000000000E+00   5.12344670272606E-14   3.55423085241414E-22
      7.66713169564749E-09   7.66718293011487E-09  -8.94846214158478E-19  -1.79352151631694E-01  -1.79352151631624E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97760434760292E-11   0.00000000000000E+00  -6.97760434760292E-11
      4.78955338534829E-18  -5.70743546419543E-01  -5.68350232587922E-01   0.00000000000000E+00   3.12053214505815E-13
     -1.35052679713584E-22  -7.59771893985321E-09  -7.59740688663884E-09  -3.89470717118982E-18
      7.88231424687083E-07
      0.00000000000000E+00  -1.01358933534854E-11   0.00000000000000E+00   6.15654837623181E-14   3.59379713392856E-22
      1.01357982887247E-08   1.01358598542088E-08  -8.62502736448591E-19  -1.97127175253554E-01  -1.97127175253478E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.58707436851849E-11   0.00000000000000E+00  -7.58707436851849E-11
      4.63781189797792E-18  -5.61494243405957E-01  -5.58325151385287E-01   0.00000000000000E+00   3.88095187923626E-13
     -1.33262771734971E-22  -1.00603772057115E-08  -1.00599891105237E-08  -3.77530916152933E-18
      7.90231424687083E-07
      0.00000000000000E+00  -1.30444324913734E-11   0.00000000000000E+00   7.23875581509841E-14   3.58985422256880E-22
      1.30443849637752E-08   1.30444573513337E-08  -8.31706456962420E-19  -2.14539402684707E-01  -2.14539402684626E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.12928981601125E-11   0.00000000000000E+00  -8.12928981601125E-11
      4.47522610165770E-18  -5.46789295869356E-01  -5.42705610554219E-01   0.00000000000000E+00   4.98290840784034E-13
     -1.30916721233732E-22  -1.29636627440142E-08  -1.29631644531736E-08  -3.64351964469528E-18
      7.92231424687083E-07
      0.00000000000000E+00  -1.64099910416060E-11   0.00000000000000E+00   8.36417922978844E-14   3.53555300715199E-22
      1.64098690167182E-08   1.64099526585108E-08  -8.02048720602092E-19  -2.31596522357159E-01  -2.31596522357073E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.60447648716952E-11   0.00000000000000E+00  -8.60447648716952E-11
      4.30313657191431E-18  -5.25842248567010E-01  -5.20699796398261E-01   0.00000000000000E+00   6.29705536328214E-13
     -1.27871230792164E-22  -1.63245375991753E-08  -1.63239078936391E-08  -3.50108785131221E-18
      7.94231424687083E-07
      0.00000000000000E+00  -2.02367938620948E-11   0.00000000000000E+00   9.50280851569819E-14   3.42065822667616E-22
      2.02367423098009E-08   2.02368373378864E-08  -7.73229784155547E-19  -2.48305880527245E-01  -2.48305880527155E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.03287721663528E-11   0.00000000000000E+00  -9.03287721663528E-11
      4.12247902758160E-18  -4.97869592305591E-01  -4.91522836306542E-01   0.00000000000000E+00   7.60079328982071E-13
     -1.24065840095853E-22  -2.01472686450489E-08  -2.01465085657201E-08  -3.34924924342605E-18
      7.96231424687083E-07
      0.00000000000000E+00  -2.45009613211659E-11   0.00000000000000E+00   1.05840368103012E-13   3.23240574677393E-22
      2.45008454274902E-08   2.45009512678586E-08  -7.45041160128939E-19  -2.64674373358341E-01  -2.64674373358247E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.43710667351681E-11   0.00000000000000E+00  -9.43710667351681E-11
      3.93373689411126E-18  -4.62144163545696E-01  -4.54455237684087E-01   0.00000000000000E+00   8.67447030363326E-13
     -1.19530236886349E-22  -2.44074476481537E-08  -2.44065802011234E-08  -3.18869573398232E-18
      7.98231424687083E-07
      0.00000000000000E+00  -2.91414166685762E-11   0.00000000000000E+00   1.15171269921771E-13   2.96818162052646E-22
      2.91412680543719E-08   2.91413832256421E-08  -7.17327474792337E-19  -2.80708932016503E-01  -2.80708932016405E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81391321481908E-11   0.00000000000000E+00  -9.81391321481908E-11
      3.73745862981488E-18  -4.18063980896962E-01  -4.08914187920212E-01   0.00000000000000E+00   9.44375083014701E-13
     -1.14298648884540E-22  -2.90441884685768E-08  -2.90432440934939E-08  -3.02013115502255E-18
      8.00231424687084E-07
      0.00000000000000E+00  -3.40595186565648E-11   0.00000000000000E+00   1.22087665038187E-13   2.66315336292050E-22
      3.40594361134530E-08   3.40595582011183E-08  -6.89952011288815E-19  -2.96417019799701E-01  -2.96417019799600E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01332781204284E-10   0.00000000000000E+00  -1.01332781204284E-10
      3.53479306740631E-18  -3.65231736341291E-01  -3.54533329557284E-01   0.00000000000000E+00   9.93773697865111E-13
     -1.08281041515768E-22  -3.39592191936118E-08  -3.39582254199140E-08  -2.84484105611750E-18
      8.02231424687084E-07
      0.00000000000000E+00  -3.90274004921199E-11   0.00000000000000E+00   1.23376565297180E-13   2.38756078349375E-22
      3.90272683608659E-08   3.90273917374314E-08  -6.62862004386713E-19  -3.11805033824545E-01  -3.11805033824440E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04451471237135E-10   0.00000000000000E+00  -1.04451471237135E-10
      3.32589012493204E-18  -3.03735849861499E-01  -2.91473095370517E-01   0.00000000000000E+00   9.85676985907958E-13
     -1.01196898516788E-22  -3.89239259431801E-08  -3.89229402661943E-08  -2.66302812054533E-18
      8.04231424687084E-07
      0.00000000000000E+00  -4.33751466620498E-11   0.00000000000000E+00   1.08075666194274E-13   2.13297452912007E-22
      4.33750475530371E-08   4.33751556287035E-08  -6.36265123968264E-19  -3.26873959915812E-01  -3.26873959915702E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10217220463639E-10   0.00000000000000E+00  -1.10217220463639E-10
      3.10545568400477E-18  -2.34983306810511E-01  -2.21352356636433E-01   0.00000000000000E+00   8.55396000424043E-13
     -9.28379112276981E-23  -4.32657938042402E-08  -4.32649384082399E-08  -2.46919056003650E-18
      8.06231424687084E-07
      0.00000000000000E+00  -4.60848419438835E-11   0.00000000000000E+00   6.75060228488604E-14   1.69702644323056E-22
      4.60847485522328E-08   4.60848160582559E-08  -6.10540030758980E-19  -3.41620389334888E-01  -3.41620389334768E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20881927001825E-10   0.00000000000000E+00  -1.20881927001825E-10
      2.86369183000112E-18  -1.62296969922008E-01  -1.47815488272548E-01   0.00000000000000E+00   6.31243627480951E-13
     -8.51594125026162E-23  -4.59645653748814E-08  -4.59639341312540E-08  -2.25315179924214E-18
      8.08231424687084E-07
      0.00000000000000E+00  -4.56258019473203E-11   0.00000000000000E+00  -1.13709097004863E-14   1.02561974477142E-22
      4.56257599265356E-08   4.56257485556260E-08  -5.85521725934288E-19  -3.56054808870700E-01  -3.56054808870571E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29391749927485E-10   0.00000000000000E+00  -1.29391749927485E-10
      2.60490833014615E-18  -9.19107244867381E-02  -7.75764303439371E-02   0.00000000000000E+00   4.68113177159352E-13
     -7.27467514312660E-23  -4.54968249188757E-08  -4.54963568056986E-08  -2.01938660421186E-18
      8.10231424687084E-07
      0.00000000000000E+00  -3.53385484669168E-11   0.00000000000000E+00  -8.61696471458692E-14   4.20038079423748E-23
      3.53387550605245E-08   3.53386688908774E-08  -5.57650793846874E-19  -3.70231316993647E-01  -3.70231316993533E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13362595976338E-10   0.00000000000000E+00  -1.13362595976338E-10
      2.37818313819347E-18  -4.29267553682168E-02  -3.18285067524112E-02   0.00000000000000E+00   3.16231373773161E-13
     -3.73096276865501E-23  -3.52256225262748E-08  -3.52253062949011E-08  -1.82053234434660E-18
      8.12231424687084E-07
      0.00000000000000E+00  -2.21256727275048E-11   0.00000000000000E+00  -3.26279073199348E-13   1.67895511699769E-23
      2.21259633696842E-08   2.21256370906110E-08  -5.24887137820571E-19  -3.84191667951031E-01  -3.84191667950953E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.85539924395017E-11   0.00000000000000E+00  -7.85539924395017E-11
      2.22107515331447E-18  -2.06181605957643E-02  -1.36718542055180E-02   0.00000000000000E+00   4.25276441099602E-13
     -1.63096747082122E-23  -2.20475083746126E-08  -2.20470830981715E-08  -1.69618801549390E-18
      8.14231424687084E-07
      0.00000000000000E+00  -1.52073760526107E-11   0.00000000000000E+00  -1.65356081394892E-13   8.54860150921007E-24
      1.52074798426151E-08   1.52073144865337E-08  -4.90950700613489E-19  -3.97907980457839E-01  -3.97907980457779E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01274851398822E-11   0.00000000000000E+00  -6.01274851398822E-11
      2.10082018303470E-18  -1.22043233771943E-02  -7.43194191247508E-03   0.00000000000000E+00   2.17890497056350E-13
     -9.04142398687070E-24  -1.51474048918909E-08  -1.51471870013938E-08  -1.60986948242121E-18
      8.16231424687084E-07
      0.00000000000000E+00  -1.25634416026176E-11   0.00000000000000E+00  -6.49114621905760E-14   5.69936274295057E-24
      1.25635221693618E-08   1.25634572578996E-08  -4.57391570384118E-19  -4.11360775461217E-01  -4.11360775461163E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.40791458529048E-11   0.00000000000000E+00  -5.40791458529048E-11
      1.99266189132889E-18  -9.09104231205655E-03  -5.14974301851016E-03   0.00000000000000E+00   1.02223362624878E-13
     -6.37218262273360E-24  -1.25094803354093E-08  -1.25093781120467E-08  -1.53527032094478E-18
      8.18231424687084E-07
      0.00000000000000E+00  -1.16582198727002E-11   0.00000000000000E+00  -2.19960414057597E-14   4.46420064086002E-24
      1.16582473739669E-08   1.16582253779255E-08  -4.24557478156683E-19  -4.24545966324256E-01  -4.24545966324203E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27421943623098E-11   0.00000000000000E+00  -5.27421943623098E-11
      1.88717750260427E-18  -7.79141595619810E-03  -4.13490212201262E-03   0.00000000000000E+00   5.28913261936884E-14
     -5.09959122551713E-24  -1.16055360748894E-08  -1.16054831835632E-08  -1.46262002444759E-18
      8.20231424687084E-07
      0.00000000000000E+00  -1.13464988346179E-11   0.00000000000000E+00  -7.42516391300180E-15   3.77502101954031E-24
      1.13464898553898E-08   1.13464824302258E-08  -3.92564085909805E-19  -4.37465807937654E-01  -4.37465807937601E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.29108893160630E-11   0.00000000000000E+00  -5.29108893160630E-11
      1.78135572397215E-18  -7.11704092867609E-03  -3.55879825516735E-03   0.00000000000000E+00   3.46329357043169E-14
     -4.35559465413283E-24  -1.12936061738455E-08  -1.12935715409098E-08  -1.38879163806234E-18
      8.22231424687084E-07
      0.00000000000000E+00  -1.12247127130807E-11   0.00000000000000E+00  -2.76009283957573E-15   3.31527284968093E-24
      1.12247767565997E-08   1.12247739965068E-08  -3.61483876779409E-19  -4.50124602451690E-01  -4.50124602451636E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34982495360109E-11   0.00000000000000E+00  -5.34982495360109E-11
      1.67435922490013E-18  -6.68795920638699E-03  -3.16824614733334E-03   0.00000000000000E+00   2.72604785352989E-14
     -3.82710059006149E-24  -1.11713030074494E-08  -1.11712757469708E-08  -1.31287534812072E-18
      8.24231424687084E-07
      0.00000000000000E+00  -1.11657483917934E-11   0.00000000000000E+00  -1.23288983469498E-15   2.97896144789425E-24
      1.11657709332923E-08   1.11657697004024E-08  -3.31365583283711E-19  -4.62527182008336E-01  -4.62527182008282E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.41496684712793E-11   0.00000000000000E+00  -5.41496684712793E-11
      1.56605988795757E-18  -6.37892941630537E-03  -2.87801030587583E-03   0.00000000000000E+00   2.35152073898385E-14
     -3.42015095977558E-24  -1.11116435471385E-08  -1.11116200319311E-08  -1.23469430467386E-18
      8.26231424687084E-07
      0.00000000000000E+00  -1.11306637021802E-11   0.00000000000000E+00  -6.61757389753119E-16   2.72048261869767E-24
      1.11306247735767E-08   1.11306241118193E-08  -3.02234984714104E-19  -4.74678341911390E-01  -4.74678341911335E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47436797053521E-11   0.00000000000000E+00  -5.47436797053521E-11
      1.45657252854686E-18  -6.14222325720642E-03  -2.65256306031816E-03   0.00000000000000E+00   2.10546913901299E-14
     -3.09510543053353E-24  -1.10759014868053E-08  -1.10758804321139E-08  -1.15433754383276E-18
      8.28231424687084E-07
      0.00000000000000E+00  -1.11067840705062E-11   0.00000000000000E+00  -3.97491944737706E-16   2.51564148456411E-24
      1.11068066775140E-08   1.11068062800221E-08  -2.74098154279197E-19  -4.86582430152633E-01  -4.86582430152578E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52333110741246E-11   0.00000000000000E+00  -5.52333110741246E-11
      1.34610590639861E-18  -5.95501568903098E-03  -2.47301264690513E-03   0.00000000000000E+00   1.91567527679921E-14
     -2.83046298729097E-24  -1.10515921257007E-08  -1.10515729689480E-08  -1.07200775211942E-18
      8.30231424687084E-07
      0.00000000000000E+00  -1.10895172599112E-11   0.00000000000000E+00  -2.49421514830993E-16   2.34961148103605E-24
      1.10895404624918E-08   1.10895402130702E-08  -2.46947616767000E-19  -4.98242474661963E-01  -4.98242474661907E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55952457365146E-11   0.00000000000000E+00  -5.55952457365146E-11
      1.23491541492559E-18  -5.80392117912905E-03  -2.32747092763817E-03   0.00000000000000E+00   1.75835464296593E-14
     -2.61208551022021E-24  -1.10339625508802E-08  -1.10339449673337E-08  -9.87967798158585E-19
      8.32231424687084E-07
      0.00000000000000E+00  -1.10764753072277E-11   0.00000000000000E+00  -1.56978549575412E-16   2.21259084861561E-24
      1.10765120457736E-08   1.10765118887951E-08  -2.20773719845360E-19  -5.09657017054919E-01  -5.09657017054863E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58024782554903E-11   0.00000000000000E+00  -5.58024782554903E-11
      1.12331045841460E-18  -5.68008309021841E-03  -2.20780181854925E-03   0.00000000000000E+00   1.62342877375590E-14
     -2.42986462213606E-24  -1.10207256448273E-08  -1.10207094105396E-08  -9.02536738569245E-19
      8.34231424687084E-07
      0.00000000000000E+00  -1.10662805413977E-11   0.00000000000000E+00  -9.94446098324494E-17   2.09790355904692E-24
      1.10662642034521E-08   1.10662641040075E-08  -1.95597682805261E-19  -5.20806734295046E-01  -5.20806734294990E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.57649234327809E-11   0.00000000000000E+00  -5.57649234327809E-11
      1.01178061154904E-18  -5.57735037056963E-03  -2.10828498420377E-03   0.00000000000000E+00   1.50372719849309E-14
     -2.27648567482382E-24  -1.10105142178467E-08  -1.10104991805747E-08  -8.16182928743780E-19
      8.36231424687084E-07
      0.00000000000000E+00  -1.10575552913630E-11   0.00000000000000E+00  -7.29982924270711E-17   2.00111423168900E-24
      1.10575288476985E-08   1.10575287747002E-08  -1.71553983141113E-19  -5.31617194368733E-01  -5.31617194368678E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.51960227642493E-11   0.00000000000000E+00  -5.51960227642493E-11
      9.01388566020544E-19  -5.49150978715398E-03  -2.02501649405672E-03   0.00000000000000E+00   1.38959821390065E-14
     -2.14696922915429E-24  -1.10023466479181E-08  -1.10023327519360E-08  -7.29834582879431E-19
      8.38231424687084E-07
      0.00000000000000E+00  -1.10491974202771E-11   0.00000000000000E+00  -7.47757231503779E-17   1.91939707151439E-24
      1.10491918011191E-08   1.10491917263434E-08  -1.48925247613704E-19  -5.41940143760455E-01  -5.41940143760402E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36898060561817E-11   0.00000000000000E+00  -5.36898060561817E-11
      7.94008953908181E-19  -5.41973817142237E-03  -1.95539642160485E-03   0.00000000000000E+00   1.27105987120392E-14
     -2.03802346098943E-24  -1.09955146308859E-08  -1.09955019202872E-08  -6.45083706294475E-19
      8.40231424687084E-07
      0.00000000000000E+00  -1.10404721702424E-11   0.00000000000000E+00  -9.80320330409986E-17   1.85093876151448E-24
      1.10404392917038E-08   1.10404391936718E-08  -1.28108251720173E-19  -5.51566024692184E-01  -5.51566024692133E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08843288481986E-11   0.00000000000000E+00  -5.08843288481986E-11
      6.92240296211784E-19  -5.36010893499046E-03  -1.89764032608468E-03   0.00000000000000E+00   1.14148894020686E-14
     -1.94737859722495E-24  -1.09895662797130E-08  -1.09895548648236E-08  -5.64132044491611E-19
      8.42231424687084E-07
      0.00000000000000E+00  -1.10304610938868E-11   0.00000000000000E+00  -1.42827173961810E-16   1.79468141441622E-24
      1.10304867657763E-08   1.10304866229492E-08  -1.09642373083838E-19  -5.60209399617054E-01  -5.60209399617008E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63309853809479E-11   0.00000000000000E+00  -4.63309853809479E-11
      5.99578325449888E-19  -5.31139711195639E-03  -1.85062908041245E-03   0.00000000000000E+00   9.92774475387734E-15
     -1.87371010892992E-24  -1.09841655653130E-08  -1.09841556375682E-08  -4.89935952366050E-19
      8.44231424687085E-07
      0.00000000000000E+00  -1.10184294333126E-11   0.00000000000000E+00  -2.13451980897833E-16   1.75029606887962E-24
      1.10184188543077E-08   1.10184186408557E-08  -9.42697245948944E-20  -5.67480088088508E-01  -5.67480088088469E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94211187798001E-11   0.00000000000000E+00  -3.94211187798001E-11
      5.20736087890287E-19  -5.27304602138513E-03  -1.81390269225116E-03   0.00000000000000E+00   8.14810170240251E-15
     -1.81669871419085E-24  -1.09790056701776E-08  -1.09789975220759E-08  -4.26466363295393E-19
      8.46231424687085E-07
      0.00000000000000E+00  -1.10031832069361E-11   0.00000000000000E+00  -3.09006996677629E-16   1.71817313661568E-24
      1.10031997695262E-08   1.10031994605192E-08  -8.29592776365720E-20  -5.72872870820596E-01  -5.72872870820567E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.94950900000725E-11   0.00000000000000E+00  -2.94950900000725E-11
      4.61745907890142E-19  -5.24513366893522E-03  -1.78765772539535E-03   0.00000000000000E+00   5.95435199684642E-15
     -1.77703478272564E-24  -1.09737103248711E-08  -1.09737043705191E-08  -3.78786630253570E-19
      8.48231424687085E-07
      0.00000000000000E+00  -1.09838958121225E-11   0.00000000000000E+00  -4.43454540331016E-16   1.69946121437034E-24
      1.09838939516205E-08   1.09838935081660E-08  -7.68870892521793E-20  -5.75782714837896E-01  -5.75782714837880E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60071226281688E-11   0.00000000000000E+00  -1.60071226281688E-11
      4.29731662633805E-19  -5.22844171215719E-03  -1.77279865979983E-03   0.00000000000000E+00   3.24896740391702E-15
     -1.75651281608666E-24  -1.09678896345052E-08  -1.09678863855378E-08  -3.52844573381626E-19
      8.50231424687085E-07
      0.00000000000000E+00  -1.09597406462370E-11   0.00000000000000E+00  -5.97983878634157E-16   1.69622849698060E-24
      1.09597540428853E-08   1.09597534449015E-08  -7.73999049166618E-20  -5.75535140159369E-01  -5.75535140159371E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35170091908851E-12   0.00000000000000E+00   1.35170091908851E-12
      4.32435064471982E-19  -5.22461207613470E-03  -1.77110559394468E-03   0.00000000000000E+00  -9.27694460448582E-17
     -1.75838087265245E-24  -1.09611050530511E-08  -1.09611051458205E-08  -3.55035159555320E-19
      8.52231424687085E-07
      0.00000000000000E+00  -1.09300747961189E-11   0.00000000000000E+00  -7.77517686645355E-16   1.71190377585009E-24
      1.09301005991131E-08   1.09300998215954E-08  -8.59996203785329E-20  -5.71415373063704E-01  -5.71415373063727E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26101290853343E-11   0.00000000000000E+00   2.26101290853343E-11
      4.77655322642651E-19  -5.23653985031514E-03  -1.78567867406166E-03   0.00000000000000E+00  -4.19422846429961E-15
     -1.78823533816641E-24  -1.09527057564523E-08  -1.09527099506808E-08  -3.91655702264118E-19
      8.54231424687085E-07
      0.00000000000000E+00  -1.08939798143964E-11   0.00000000000000E+00  -1.33047189682630E-15   1.75226767375392E-24
      1.08940085691676E-08   1.08940072386957E-08  -1.04379973381896E-19  -5.62683387809959E-01  -5.62683387810007E-01
      0.00000000000000E+00   0.00000000000000E+00   4.75276366964041E-11   0.00000000000000E+00   4.75276366964041E-11
      5.72710596035459E-19  -5.26934705399856E-03  -1.82200721573622E-03   0.00000000000000E+00  -8.90933275343073E-15
     -1.85606727287857E-24  -1.09415259660593E-08  -1.09415348753921E-08  -4.68330622653562E-19
      8.56231424687085E-07
      0.00000000000000E+00  -1.08497106510623E-11   0.00000000000000E+00  -1.26265244423375E-15   1.82752436252073E-24
      1.08496761381596E-08   1.08496748755071E-08  -1.34523898136658E-19  -5.48575650038237E-01  -5.48575650038313E-01
      0.00000000000000E+00   0.00000000000000E+00   7.55587846552004E-11   0.00000000000000E+00   7.55587846552004E-11
      7.23828165345859E-19  -5.33264497894154E-03  -1.89044214218984E-03   0.00000000000000E+00  -1.55885043215006E-14
     -1.98096727375701E-24  -1.09252180716580E-08  -1.09252336601623E-08  -5.89304267209200E-19
      8.58231424687085E-07
      0.00000000000000E+00  -1.07930424482053E-11   0.00000000000000E+00  -2.49706329944279E-14   1.95669217537611E-24
      1.07929721154464E-08   1.07929471448134E-08  -1.78846490407434E-19  -5.28307206275026E-01  -5.28307206275131E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05659484471187E-10   0.00000000000000E+00   1.05659484471187E-10
      9.35147134288233E-19  -5.44597089966060E-03  -2.01215133508821E-03   0.00000000000000E+00  -4.88439394396386E-16
     -2.20306014850813E-24  -1.08986061408452E-08  -1.08986066292846E-08  -7.56300643880799E-19
      8.60231424687085E-07
      0.00000000000000E+00  -1.07132293715720E-11   0.00000000000000E+00  -2.56115399927864E-15   2.17715688564948E-24
      1.07131875480643E-08   1.07131849869103E-08  -2.40331740643475E-19  -5.01092278263514E-01  -5.01092278263649E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35879680272045E-10   0.00000000000000E+00   1.35879680272045E-10
      1.20690649483232E-18  -5.65321511973517E-03  -2.23501443772392E-03   0.00000000000000E+00  -3.47250252643048E-14
     -2.61892408616506E-24  -1.08490299421571E-08  -1.08490646671824E-08  -9.66574754188847E-19
      8.62231424687085E-07
      0.00000000000000E+00  -1.05782176078769E-11   0.00000000000000E+00  -3.88135278475569E-15   2.56358118207347E-24
      1.05781936325852E-08   1.05781897512324E-08  -3.22469546523012E-19  -4.66194740442608E-01  -4.66194740442770E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62886629438680E-10   0.00000000000000E+00   1.62886629438680E-10
      1.53267975370968E-18  -6.06669537546415E-03  -2.68252225936580E-03   0.00000000000000E+00  -5.09009189217838E-14
     -3.51036090007979E-24  -1.07410254797521E-08  -1.07410763806711E-08  -1.21021020718667E-18
      8.64231424687085E-07
      0.00000000000000E+00  -1.02754973540409E-11   0.00000000000000E+00  -6.10163751145541E-14   3.23190218820540E-24
      1.02755624886924E-08   1.02755014723173E-08  -4.28303328221863E-19  -4.22996682103117E-01  -4.22996682103299E-01
      0.00000000000000E+00   0.00000000000000E+00   1.82342215551440E-10   0.00000000000000E+00   1.82342215551440E-10
      1.89736418481256E-18  -7.02466919069430E-03  -3.72972296993044E-03   0.00000000000000E+00  -2.22216688087842E-14
     -5.92026846687118E-24  -1.04578214661999E-08  -1.04578436878687E-08  -1.46906085659070E-18
      8.66231424687085E-07
      0.00000000000000E+00  -9.37652106625361E-12   0.00000000000000E+00  -3.10002214061123E-14   3.92544029802857E-24
      9.37657385053185E-09   9.37654285031045E-09  -5.56897517947826E-19  -3.71073391418093E-01  -3.71073391418286E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93379961936982E-10   0.00000000000000E+00   1.93379961936982E-10
      2.28412410868653E-18  -9.69808336470568E-03  -6.68291553318942E-03   0.00000000000000E+00  -1.03076174207434E-13
     -1.48910228211358E-23  -9.56981973607321E-09  -9.56992281224743E-09  -1.72722659073870E-18
      8.68231424687085E-07
      0.00000000000000E+00  -6.72018757673752E-12   0.00000000000000E+00  -6.73977323975322E-14   6.51603133396954E-25
      6.72029828554689E-09   6.72023088781449E-09  -6.97941403371267E-19  -3.10435330235662E-01  -3.10435330235872E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09665309836617E-10   0.00000000000000E+00   2.09665309836617E-10
      2.70345472835976E-18  -1.74761363927000E-02  -1.52927664152571E-02   0.00000000000000E+00  -1.59943481822752E-13
     -4.09527639783790E-23  -6.92973625416925E-09  -6.92989619765111E-09  -2.00551332498850E-18
      8.70231424687085E-07
      0.00000000000000E+00  -2.73807530563079E-12   0.00000000000000E+00  -1.00837453128341E-13  -1.60855792516568E-23
      2.73817542511014E-09   2.73807458765700E-09  -8.40814138490040E-19  -2.42303264633730E-01  -2.42303264633966E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36489838430876E-10   0.00000000000000E+00   2.36489838430876E-10
      3.17643440522151E-18  -3.28264032830149E-02  -3.18892278986718E-02   0.00000000000000E+00  -2.69481296260782E-13
     -7.42556464828626E-23  -2.97429494479154E-09  -2.97456442608787E-09  -2.33562026673147E-18
      8.72231424687085E-07
      0.00000000000000E+00  -6.17104789297372E-13   0.00000000000000E+00  -5.58530114450900E-14  -3.48536783441122E-23
      6.17200976115566E-10   6.17145123104086E-10  -9.86838616792465E-19  -1.69833496236024E-01  -1.69833496236268E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44364936061733E-10   0.00000000000000E+00   2.44364936061733E-10
      3.66516427734498E-18  -5.19979200287158E-02  -5.17264922457845E-02   0.00000000000000E+00  -4.88394558640255E-13
     -8.71526272911624E-23  -8.61021664607092E-10  -8.61510059165819E-10  -2.67832566055251E-18
      8.74231424687085E-07
      0.00000000000000E+00  -5.06064502013472E-14   0.00000000000000E+00  -1.83947329604941E-14  -4.34241311258732E-23
      5.06626662045041E-11   5.06442714715002E-11  -1.13152805274357E-18  -9.85916000308644E-02  -9.85916000310905E-02
      0.00000000000000E+00   0.00000000000000E+00   2.26108751627543E-10   0.00000000000000E+00   2.26108751627543E-10
      4.11738178060006E-18  -7.19288415879423E-02  -7.18416479977098E-02   0.00000000000000E+00  -7.27699397946588E-13
     -9.42383345680636E-23  -2.76025323701002E-10  -2.76753023099043E-10  -2.98585372785649E-18
      8.76231424687085E-07
      0.00000000000000E+00   2.79208001110881E-14   0.00000000000000E+00  -5.67328850005560E-15  -4.55912938494044E-23
     -2.78990100802420E-11  -2.79046833687877E-11  -1.23791447661298E-18  -4.65548394062217E-02  -4.65548394063915E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69864644933441E-10   0.00000000000000E+00   1.69864644933441E-10
      4.45711107046694E-18  -9.17247860804502E-02  -9.16800603357779E-02   0.00000000000000E+00  -7.44130738851293E-13
     -1.00434514034951E-22  -1.41215830825701E-10  -1.41959961564653E-10  -3.21919659385397E-18
      8.78231424687085E-07
      0.00000000000000E+00   1.16642816253559E-14   0.00000000000000E+00  -1.12173458157752E-15  -4.60144344450751E-23
     -1.16019537177640E-11  -1.16030754523916E-11  -1.29020973535242E-18  -2.20650994475001E-02  -2.20650994476044E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04257381706860E-10   0.00000000000000E+00   1.04257381706860E-10
      4.66562583388066E-18  -1.11220207406387E-01  -1.11191016043991E-01   0.00000000000000E+00  -5.01051016950405E-13
     -1.03984653613410E-22  -9.21532552374138E-11  -9.26543062544682E-11  -3.37541609852824E-18
      8.80231424687085E-07
      0.00000000000000E+00  -7.34757897660214E-15   0.00000000000000E+00   2.44473906199644E-16  -4.57717716163511E-23
      7.36206849737462E-12   7.36231297123505E-12  -1.31165081869759E-18  -1.27319502018479E-02  -1.27319502019130E-02
      0.00000000000000E+00   0.00000000000000E+00   6.50394840699431E-11   0.00000000000000E+00   6.50394840699431E-11
      4.79570480202055E-18  -1.30362481636814E-01  -1.30339671152608E-01   0.00000000000000E+00  -3.35196432237243E-13
     -1.06135826189767E-22  -7.20666006088345E-11  -7.24017970411779E-11  -3.48405398332296E-18
      8.82231424687085E-07
      0.00000000000000E+00  -2.03895316600709E-14   0.00000000000000E+00   4.55871415308164E-16  -4.48950203812792E-23
      2.03597343410615E-11   2.03601902124319E-11  -1.31957790788688E-18  -9.29449034696069E-03  -9.29449034700575E-03
      0.00000000000000E+00   0.00000000000000E+00   4.50575679044800E-11   0.00000000000000E+00   4.50575679044800E-11
      4.88581993782951E-18  -1.49131029357186E-01  -1.49110419347393E-01   0.00000000000000E+00  -2.78886552873052E-13
     -1.07828077096701E-22  -6.51388715639313E-11  -6.54177581169122E-11  -3.56624202994263E-18
      8.84231424687085E-07
      0.00000000000000E+00  -2.94821606436161E-14   0.00000000000000E+00   4.54384240277748E-16  -4.30968173349400E-23
      2.94725333066325E-11   2.94729876908297E-11  -1.32188913654077E-18  -7.88558128044760E-03  -7.88558128048198E-03
      0.00000000000000E+00   0.00000000000000E+00   3.43845593837649E-11   0.00000000000000E+00   3.43845593837649E-11
      4.95458905659704E-18  -1.67521803170006E-01  -1.67501684832541E-01   0.00000000000000E+00  -2.71006615928137E-13
     -1.09407162822322E-22  -6.35865404585570E-11  -6.38575470745945E-11  -3.63269992005627E-18
      8.86231424687085E-07
      0.00000000000000E+00  -3.63705159341806E-14   0.00000000000000E+00   3.59103090593175E-16  -3.99769230073700E-23
      3.63753910664736E-11   3.63757501695242E-11  -1.32183254296181E-18  -7.17167847928037E-03  -7.17167847930843E-03
      0.00000000000000E+00   0.00000000000000E+00   2.80574183634746E-11   0.00000000000000E+00   2.80574183634746E-11
      5.01070389332399E-18  -1.85538275043525E-01  -1.85517975459896E-01   0.00000000000000E+00  -2.77091892025928E-13
     -1.10967574880102E-22  -6.41560766408616E-11  -6.44331685329985E-11  -3.68887135036218E-18
      8.88231424687085E-07
      0.00000000000000E+00  -4.19730449038397E-14   0.00000000000000E+00   2.80638773287646E-16  -3.51072215761497E-23
      4.19802488920958E-11   4.19805295308340E-11  -1.32076064932231E-18  -6.72534931314362E-03  -6.72534931316758E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39534769168484E-11   0.00000000000000E+00   2.39534769168484E-11
      5.05861084715769E-18  -2.03187013874761E-01  -2.03166241560652E-01   0.00000000000000E+00  -2.84987064211156E-13
     -1.12525119994404E-22  -6.56490193833587E-11  -6.59340064476824E-11  -3.73785019783538E-18
      8.90231424687086E-07
      0.00000000000000E+00  -4.68408159758386E-14   0.00000000000000E+00   2.26735944490899E-16  -2.81018664525153E-23
      4.68011969216296E-11   4.68014236575460E-11  -1.31926761420659E-18  -6.40685482613245E-03  -6.40685482615358E-03
      0.00000000000000E+00   0.00000000000000E+00   2.11328963003867E-11   0.00000000000000E+00   2.11328963003867E-11
      5.10087663975846E-18  -2.20475624666221E-01  -2.20454222271854E-01   0.00000000000000E+00  -2.91451180503748E-13
     -1.14076550323475E-22  -6.76428687773143E-11  -6.79343199579322E-11  -3.78160902555187E-18
      8.92231424687086E-07
      0.00000000000000E+00  -5.11575186245924E-14   0.00000000000000E+00   1.91909940882561E-16  -1.87247924985270E-23
      5.11459509958984E-11   5.11461429058206E-11  -1.31762644092690E-18  -6.16400095835471E-03  -6.16400095837384E-03
      0.00000000000000E+00   0.00000000000000E+00   1.91224315868416E-11   0.00000000000000E+00   1.91224315868416E-11
      5.13912150293215E-18  -2.37411722782939E-01  -2.37389585112115E-01   0.00000000000000E+00  -2.96108518058649E-13
     -1.15616418289441E-22  -6.99724659744886E-11  -7.02685744926628E-11  -3.82149506200525E-18
      8.94231424687086E-07
      0.00000000000000E+00  -5.51986870617236E-14   0.00000000000000E+00   1.69936461018286E-16  -7.01780914647892E-24
      5.52004133539421E-11   5.52005832903961E-11  -1.31596318342334E-18  -5.97242337809735E-03  -5.97242337811500E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76481249006893E-11   0.00000000000000E+00   1.76481249006893E-11
      5.17441775273353E-18  -2.54002482020621E-01  -2.53979531621919E-01   0.00000000000000E+00  -2.99341588117238E-13
     -1.17140899311040E-22  -7.25493666028513E-11  -7.28487081910857E-11  -3.85845456931019E-18
      8.96231424687086E-07
      0.00000000000000E+00  -5.90561660244397E-14   0.00000000000000E+00   1.55870204718594E-16   6.51644525418516E-24
      5.90747903942709E-11   5.90749462644821E-11  -1.31433300139555E-18  -5.81807980485452E-03  -5.81807980487105E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65357973343594E-11   0.00000000000000E+00   1.65357973343594E-11
      5.20748934740224E-18  -2.70254728998373E-01  -2.70230908576386E-01   0.00000000000000E+00  -3.01660820225492E-13
     -1.18648363718469E-22  -7.53090827784969E-11  -7.56107435988411E-11  -3.89315634600669E-18
      8.98231424687086E-07
      0.00000000000000E+00  -6.28218002499483E-14   0.00000000000000E+00   1.46791745456139E-16   2.06115510006077E-23
      6.28354446076270E-11   6.28355913993931E-11  -1.31275647282358E-18  -5.69175974050463E-03  -5.69175974052030E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56696893247441E-11   0.00000000000000E+00   1.56696893247441E-11
      5.23882872605173E-18  -2.86175571292042E-01  -2.86150839114136E-01   0.00000000000000E+00  -3.03542305984490E-13
     -1.20138987267139E-22  -7.82017384180325E-11  -7.85052807241371E-11  -3.92607225322815E-18
      9.00231424687086E-07
      0.00000000000000E+00  -6.64955897382494E-14   0.00000000000000E+00   1.40770454383774E-16   3.44534004941116E-23
      6.65247773626447E-11   6.65249181331335E-11  -1.31123780222734E-18  -5.58707942363813E-03  -5.58707942365310E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49710575382499E-11   0.00000000000000E+00   1.49710575382499E-11
      5.26877084112823E-18  -3.01772467136619E-01  -3.01746792919443E-01   0.00000000000000E+00  -3.05376041062632E-13
     -1.21614345080426E-22  -8.11905996301995E-11  -8.14959756713838E-11  -3.95753303890089E-18
      9.02231424687086E-07
      0.00000000000000E+00  -7.01693792265504E-14   0.00000000000000E+00   1.36712197852082E-16   4.74298013070373E-23
      7.01708579918023E-11   7.01709947040476E-11  -1.30977403475478E-18  -5.49965040414504E-03  -5.49965040415943E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43834959638590E-11   0.00000000000000E+00   1.43834959638590E-11
      5.29753783305595E-18  -3.17050449213092E-01  -3.17023811600671E-01   0.00000000000000E+00  -3.07393965109847E-13
     -1.23076788807638E-22  -8.42470967026740E-11  -8.45544906679069E-11  -3.98776379830116E-18
      9.04231424687086E-07
      0.00000000000000E+00  -7.37513239776440E-14   0.00000000000000E+00   1.33871271665327E-16   5.91043642079081E-23
      7.37911101021544E-11   7.37912439734851E-11  -1.30835992893095E-18  -5.42653343689940E-03  -5.42653343691326E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38642694212825E-11   0.00000000000000E+00   1.38642694212825E-11
      5.32526637189851E-18  -3.32008057595035E-01  -3.31980443205806E-01   0.00000000000000E+00  -3.09639661102427E-13
     -1.24528390637566E-22  -8.73458737335400E-11  -8.76555133947670E-11  -4.01690644296757E-18
      9.06231424687086E-07
      0.00000000000000E+00  -7.74251134659451E-14   0.00000000000000E+00   1.31776611913053E-16   6.92577929249369E-23
      7.73962482321340E-11   7.73963800088151E-11  -1.30698994032708E-18  -5.36572307022001E-03  -5.36572307023339E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33880841333859E-11   0.00000000000000E+00   1.33880841333859E-11
      5.35204254016528E-18  -3.46644298957255E-01  -3.46615699002969E-01   0.00000000000000E+00  -3.12264651932905E-13
     -1.25971636922633E-22  -9.04721994901427E-11  -9.07844641422016E-11  -4.04505259983820E-18
      9.08231424687086E-07
      0.00000000000000E+00  -8.10070582170386E-14   0.00000000000000E+00   1.30383657575977E-16   7.78720845073403E-23
      8.09978234298924E-11   8.09979538136278E-11  -1.30565748452792E-18  -5.31592512674198E-03  -5.31592512675494E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29546260802900E-11   0.00000000000000E+00   1.29546260802900E-11
      5.37795179232586E-18  -3.60980116885138E-01  -3.60950519037642E-01   0.00000000000000E+00  -3.15964711091949E-13
     -1.27411905493903E-22  -9.36366151826984E-11  -9.39525798939178E-11  -4.07229430779795E-18
      9.10231424687086E-07
      0.00000000000000E+00  -8.45890029681321E-14   0.00000000000000E+00   1.29873452987507E-16   8.50780451739619E-23
      8.46147426489623E-11   8.46148725225003E-11  -1.30435302169316E-18  -5.27651554090747E-03  -5.27651554092006E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25878864387462E-11   0.00000000000000E+00   1.25878864387462E-11
      5.40312756520336E-18  -3.75082719939793E-01  -3.75052098356679E-01   0.00000000000000E+00  -3.22167620742302E-13
     -1.28860508668014E-22  -9.68805913403758E-11  -9.72027589612470E-11  -4.09877454351020E-18
      9.12231424687086E-07
      0.00000000000000E+00  -8.82627924564332E-14   0.00000000000000E+00   1.29710093974146E-16   9.10681538056914E-23
      8.82526431425982E-11   8.82527728527832E-11  -1.30307081957673E-18  -5.24750630862110E-03  -5.24750630863334E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22368904767544E-11   0.00000000000000E+00   1.22368904767544E-11
      5.42760134615687E-18  -3.88962263077519E-01  -3.88930606201940E-01   0.00000000000000E+00  -3.29277893996770E-13
     -1.30320862224855E-22  -1.00160385435409E-10  -1.00489663329537E-10  -4.12453052658013E-18
      9.14231424687086E-07
      0.00000000000000E+00  -9.19365819447343E-14   0.00000000000000E+00   1.29478342122716E-16   9.60480526557458E-23
      9.19055626439299E-11   9.19056921223680E-11  -1.30180792680093E-18  -5.22960098182087E-03  -5.22960098183274E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18641281988306E-11   0.00000000000000E+00   1.18641281988306E-11
      5.45132960255453E-18  -4.02588676527973E-01  -4.02555986499843E-01   0.00000000000000E+00  -3.36099155506593E-13
     -1.31790765850398E-22  -1.03433721165561E-10  -1.03769820321199E-10  -4.14952167575360E-18
      9.16231424687086E-07
      0.00000000000000E+00  -9.56103714330353E-14   0.00000000000000E+00   1.29417228690782E-16   1.00216810979982E-22
      9.55735021570129E-11   9.55736315743418E-11  -1.30055971609678E-18  -5.22434118014999E-03  -5.22434118016146E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14768210990339E-11   0.00000000000000E+00   1.14768210990339E-11
      5.47428324475260E-18  -4.15948965746985E-01  -4.15915242430824E-01   0.00000000000000E+00  -3.43128150490470E-13
     -1.33270053768615E-22  -1.06707324522752E-10  -1.07050452673375E-10  -4.17372352865581E-18
      9.18231424687086E-07
      0.00000000000000E+00  -9.92841609213364E-14   0.00000000000000E+00   1.29786593577510E-16   1.03751011367178E-22
      9.92624026553833E-11   9.92625324420807E-11  -1.29931879100125E-18  -5.23446169967796E-03  -5.23446169968904E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10804739706013E-11   0.00000000000000E+00   1.10804739706013E-11
      5.49644419269380E-18  -4.29042018741419E-01  -4.29007258396251E-01   0.00000000000000E+00  -3.50626076357052E-13
     -1.34759394980646E-22  -1.09992380336190E-10  -1.10343006412682E-10  -4.19712540169255E-18
      9.20231424687086E-07
      0.00000000000000E+00  -1.02957950409637E-13   0.00000000000000E+00   1.30981247314571E-16   1.06800928629801E-22
      1.02986757247021E-10   1.02986888228375E-10  -1.29807314032776E-18  -5.26478202625158E-03  -5.26478202626225E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06747159115060E-11   0.00000000000000E+00   1.06747159115060E-11
      5.51779362451681E-18  -4.41871088538173E-01  -4.41835282974823E-01   0.00000000000000E+00  -3.58551537985968E-13
     -1.36258925312842E-22  -1.13303052601759E-10  -1.13661604139881E-10  -4.21972048418906E-18
      9.22231424687086E-07
      0.00000000000000E+00  -1.06815429372354E-13   0.00000000000000E+00   1.33830367151765E-16   1.09497050586441E-22
      1.06778028907845E-10   1.06778162738321E-10  -1.29680154358219E-18  -5.32427995706550E-03  -5.32427995707576E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02537084678021E-11   0.00000000000000E+00   1.02537084678021E-11
      5.53830104145241E-18  -4.54440759817672E-01  -4.54403892775466E-01   0.00000000000000E+00  -3.66665820106231E-13
     -1.37767433321427E-22  -1.16665205385880E-10  -1.17031871206124E-10  -4.24149949787022E-18
      9.24231424687086E-07
      0.00000000000000E+00  -1.10672908335070E-13   0.00000000000000E+00   1.39965841939887E-16   1.11967492754512E-22
      1.10705599643197E-10   1.10705739609151E-10  -1.29546254235603E-18  -5.43104286339917E-03  -5.43104286340898E-03
      0.00000000000000E+00   0.00000000000000E+00   9.80200356161290E-12   0.00000000000000E+00   9.80200356161290E-12
      5.55790504857564E-18  -4.66755896944235E-01  -4.66717935173131E-01   0.00000000000000E+00  -3.74478083491838E-13
     -1.39281439711601E-22  -1.20133265087131E-10  -1.20507743170762E-10  -4.26244250621961E-18
      9.26231424687086E-07
      0.00000000000000E+00  -1.14897766246616E-13   0.00000000000000E+00   1.54499248910937E-16   1.14378401652515E-22
      1.14932948582795E-10   1.14933103082158E-10  -1.29396573625769E-18  -5.62522766126031E-03  -5.62522766126959E-03
      0.00000000000000E+00   0.00000000000000E+00   9.28006303673687E-12   0.00000000000000E+00   9.28006303673687E-12
      5.57646517464911E-18  -4.78821194419938E-01  -4.78782065627290E-01   0.00000000000000E+00  -3.80932435676122E-13
     -1.40793187059029E-22  -1.23832233683078E-10  -1.24213166118895E-10  -4.28249943839142E-18
      9.28231424687086E-07
      0.00000000000000E+00  -1.19857382055822E-13   0.00000000000000E+00   1.87824507754138E-16   1.17049069336064E-22
      1.19892623060067E-10   1.19892810884692E-10  -1.29208576438436E-18  -6.00810851046697E-03  -6.00810851047555E-03
      0.00000000000000E+00   0.00000000000000E+00   8.57617806378211E-12   0.00000000000000E+00   8.57617806378211E-12
      5.59361753077668E-18  -4.90640694829737E-01  -4.90600225654861E-01   0.00000000000000E+00  -3.83292342040281E-13
     -1.42284687902073E-22  -1.28085696606291E-10  -1.28468988948474E-10  -4.30153176639232E-18
      9.30231424687086E-07
      0.00000000000000E+00  -1.26929426820802E-13   0.00000000000000E+00   2.84385344093904E-16   1.20859657493112E-22
      1.26933018294429E-10   1.26933302679894E-10  -1.28916077621241E-18  -6.87929361693480E-03  -6.87929361694212E-03
      0.00000000000000E+00   0.00000000000000E+00   7.32567993338441E-12   0.00000000000000E+00   7.32567993338441E-12
      5.60826889064345E-18  -5.02216474190789E-01  -5.02174181386274E-01   0.00000000000000E+00  -3.72946482231203E-13
     -1.43706691993451E-22  -1.33886036130903E-10  -1.34258982613278E-10  -4.31910811443103E-18
      9.32231424687086E-07
      0.00000000000000E+00  -1.41073516350761E-13   0.00000000000000E+00   5.91195671317920E-16   1.28889055074731E-22
      1.41080589760429E-10   1.41081180956229E-10  -1.28291987954445E-18  -9.26767709481104E-03  -9.26767709481522E-03
      0.00000000000000E+00   0.00000000000000E+00   4.18095801676396E-12   0.00000000000000E+00   4.18095801676396E-12
      5.61663080667698E-18  -5.13543428966830E-01  -5.13497670400625E-01   0.00000000000000E+00  -3.18271775068213E-13
     -1.44896921610139E-22  -1.44943867197781E-10  -1.45262138972994E-10  -4.33371092713253E-18
      9.34231424687086E-07
      0.00000000000000E+00  -1.80934132298828E-13   0.00000000000000E+00   1.62980714950381E-15   1.50893287267651E-22
      1.80887648027126E-10   1.80889277834426E-10  -1.26630965769772E-18  -1.63090106628442E-02  -1.63090106628393E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.87465133514268E-12   0.00000000000000E+00  -4.87465133514268E-12
      5.60688150400669E-18  -5.24588333278261E-01  -5.24532887897719E-01   0.00000000000000E+00  -1.28453223371468E-13
     -1.45370094630168E-22  -1.75886173275767E-10  -1.76014626499283E-10  -4.34057184630897E-18
      9.36231424687087E-07
      0.00000000000000E+00  -2.82238877438730E-13   0.00000000000000E+00   3.73138701105698E-15   1.94608381369057E-22
      2.82274870924677E-10   2.82278602311883E-10  -1.23167256655292E-18  -3.09934056626688E-02  -3.09934056626483E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05304545672689E-11   0.00000000000000E+00  -2.05304545672689E-11
      5.56582059487215E-18  -5.35250232527256E-01  -5.35167780932660E-01   0.00000000000000E+00   1.83342544933147E-13
     -1.44687307616905E-22  -2.61931490289402E-10  -2.61748147744613E-10  -4.33414802831923E-18
      9.38231424687087E-07
      0.00000000000000E+00  -4.70979812400197E-13   0.00000000000000E+00   6.06996517868926E-15   2.39848021365777E-22
      4.71015450475692E-10   4.71021520441111E-10  -1.18514318228921E-18  -4.99633023353949E-02  -4.99633023353630E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.19515005193220E-11   0.00000000000000E+00  -3.19515005193220E-11
      5.50191759383351E-18  -5.45359137307168E-01  -5.45220827991396E-01   0.00000000000000E+00   3.35603350684000E-13
     -1.43416314632397E-22  -4.39405623272330E-10  -4.39070019921789E-10  -4.31677441154430E-18
      9.40231424687087E-07
      0.00000000000000E+00  -7.80037353103525E-13   0.00000000000000E+00   8.93728995434442E-15   2.71790895012432E-22
      7.80021635161970E-10   7.80030572452196E-10  -1.13511858532676E-18  -6.98805198184243E-02  -6.98805198183863E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.80182337707862E-11   0.00000000000000E+00  -3.80182337707862E-11
      5.42588112629194E-18  -5.54682393467966E-01  -5.54448654151973E-01   0.00000000000000E+00   3.43784665944700E-13
     -1.42083262611057E-22  -7.42356123347212E-10  -7.42012338681409E-10  -4.29076254096517E-18
      9.42231424687087E-07
      0.00000000000000E+00  -1.25974241553844E-12   0.00000000000000E+00   1.30113746476874E-14   2.93726910092843E-22
      1.25969353964221E-09   1.25970655101715E-09  -1.08592315707680E-18  -8.97020956850302E-02  -8.97020956849878E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.23773655772738E-11   0.00000000000000E+00  -4.23773655772738E-11
      5.34112639513739E-18  -5.62901225268840E-01  -5.62517755268171E-01   0.00000000000000E+00   3.15762159588153E-13
     -1.40827725558496E-22  -1.21764494759933E-09  -1.21732918543988E-09  -4.25520323806059E-18
      9.44231424687087E-07
      0.00000000000000E+00  -1.97264126574326E-12   0.00000000000000E+00   1.86481295861615E-14   3.11266998600157E-22
      1.97260114800740E-09   1.97261979613730E-09  -1.03946184050186E-18  -1.09231570967431E-01  -1.09231570967384E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69256281222284E-11   0.00000000000000E+00  -4.69256281222284E-11
      5.24727513889293E-18  -5.69585404629900E-01  -5.68978789723021E-01   0.00000000000000E+00   2.88074951199226E-13
     -1.39650806266198E-22  -1.92598224296613E-09  -1.92569416801507E-09  -4.20781329839108E-18
      9.46231424687087E-07
      0.00000000000000E+00  -2.98155570396794E-12   0.00000000000000E+00   2.58478688979779E-14   3.26530350301767E-22
      2.98152578482846E-09   2.98155163269768E-09  -9.96494175820898E-19  -1.28411493844686E-01  -1.28411493844634E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.22418025683752E-11   0.00000000000000E+00  -5.22418025683752E-11
      5.14279153375618E-18  -5.74192424023918E-01  -5.73269654451871E-01   0.00000000000000E+00   2.67957534903135E-13
     -1.38523326603558E-22  -2.92957778766407E-09  -2.92930983012930E-09  -4.14629735793528E-18
      9.48231424687087E-07
      0.00000000000000E+00  -4.33846985147194E-12   0.00000000000000E+00   3.43372766467231E-14   3.39584592006373E-22
      4.33842333119147E-09   4.33845766846846E-09  -9.57038177801633E-19  -1.47218839413429E-01  -1.47218839413371E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83387777384037E-11   0.00000000000000E+00  -5.83387777384037E-11
      5.02611397827937E-18  -5.76089494765468E-01  -5.74741196684015E-01   0.00000000000000E+00   2.61851784760731E-13
     -1.37387901426672E-22  -4.28038074251468E-09  -4.28011889073006E-09  -4.06907580047774E-18
      9.50231424687087E-07
      0.00000000000000E+00  -6.07929500050340E-12   0.00000000000000E+00   4.37253857881864E-14   3.49864504736288E-22
      6.07924594867121E-09   6.07928967405734E-09  -9.20676005974484E-19  -1.65648373027070E-01  -1.65648373027005E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48626912372688E-11   0.00000000000000E+00  -6.48626912372688E-11
      4.89638859580484E-18  -5.74585465381183E-01  -5.72690825872820E-01   0.00000000000000E+00   2.78610574196462E-13
     -1.36147154841484E-22  -6.01470559339414E-09  -6.01442698282008E-09  -3.97571258983035E-18
      9.52231424687087E-07
      0.00000000000000E+00  -8.22735971431304E-12   0.00000000000000E+00   5.37023919952672E-14   3.56753959644971E-22
      8.22727215287739E-09   8.22732585526974E-09  -8.86822384364977E-19  -1.83703055352980E-01  -1.83703055352908E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.13084248122565E-11   0.00000000000000E+00  -7.13084248122565E-11
      4.75377174618032E-18  -5.68955973499221E-01  -5.66386683692932E-01   0.00000000000000E+00   3.27118633028059E-13
     -1.34659418302682E-22  -8.15634454909038E-09  -8.15601743045748E-09  -3.86694936181535E-18
      9.54231424687087E-07
      0.00000000000000E+00  -1.08010329403424E-11   0.00000000000000E+00   6.41538496873895E-14   3.59705685090689E-22
      1.08010366748986E-08   1.08011008287486E-08  -8.54898307801646E-19  -2.01389257704378E-01  -2.01389257704301E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.72537016205614E-11   0.00000000000000E+00  -7.72537016205614E-11
      4.59926434293920E-18  -5.58453030716933E-01  -5.55074803814727E-01   0.00000000000000E+00   4.12009140287068E-13
     -1.32750408159142E-22  -1.07242591362682E-08  -1.07238471271281E-08  -3.74436603513755E-18
      9.56231424687087E-07
      0.00000000000000E+00  -1.38193265391933E-11   0.00000000000000E+00   7.50860982990063E-14   3.58161217079673E-22
      1.38192563033460E-08   1.38193313894446E-08  -8.24411833337782E-19  -2.18714537467976E-01  -2.18714537467894E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25033394745485E-11   0.00000000000000E+00  -8.25033394745485E-11
      4.43425766399010E-18  -5.42304889121131E-01  -5.37977471660864E-01   0.00000000000000E+00   5.28989345936935E-13
     -1.30245199339605E-22  -1.37373570393159E-08  -1.37368280499701E-08  -3.60984583065232E-18
      9.58231424687087E-07
      0.00000000000000E+00  -1.72973030477679E-11   0.00000000000000E+00   8.64152126536633E-14   3.51369345356354E-22
      1.72972046687881E-08   1.72972910840011E-08  -7.94981470167985E-19  -2.35686538384377E-01  -2.35686538384290E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.71181331126561E-11   0.00000000000000E+00  -8.71181331126561E-11
      4.26002139776479E-18  -5.19722552989022E-01  -5.14300887717533E-01   0.00000000000000E+00   6.62412545788221E-13
     -1.27016844841387E-22  -1.72108353634341E-08  -1.72101729508884E-08  -3.46503992759680E-18
      9.60231424687087E-07
      0.00000000000000E+00  -2.12339521739569E-11   0.00000000000000E+00   9.77412344644178E-14   3.38211900711526E-22
      2.12338860445461E-08   2.12339837857809E-08  -7.66331962085212E-19  -2.52312485670240E-01  -2.52312485670148E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.13274074029426E-11   0.00000000000000E+00  -9.13274074029426E-11
      4.07736658295891E-18  -4.89930224517670E-01  -4.83269628000750E-01   0.00000000000000E+00   7.88884195025760E-13
     -1.23029001950247E-22  -2.11434452625728E-08  -2.11426563783779E-08  -3.31103462087369E-18
      9.62231424687087E-07
      0.00000000000000E+00  -2.55963935018400E-11   0.00000000000000E+00   1.08275356754595E-13   3.17472807004372E-22
      2.55963037485250E-08   2.55964120238820E-08  -7.38271996275328E-19  -2.68599218453221E-01  -2.68599218453126E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.53214792001461E-11   0.00000000000000E+00  -9.53214792001461E-11
      3.88672362455861E-18  -4.52224886324473E-01  -4.44191119244892E-01   0.00000000000000E+00   8.88785292076892E-13
     -1.18324160342269E-22  -2.55019793299738E-08  -2.55010905446819E-08  -3.14845162828328E-18
      9.64231424687087E-07
      0.00000000000000E+00  -3.03152842548256E-11   0.00000000000000E+00   1.17120708430430E-13   2.89537055204884E-22
      3.03151655777991E-08   3.03152826985078E-08  -7.10652181522627E-19  -2.84553785719603E-01  -2.84553785719504E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89757791093113E-11   0.00000000000000E+00  -9.89757791093113E-11
      3.68877206633999E-18  -4.06045038153203E-01  -3.96525641704705E-01   0.00000000000000E+00   9.59068991143225E-13
     -1.12916419798442E-22  -3.02172659883895E-08  -3.02163069193985E-08  -2.97811988481736E-18
      9.66231424687086E-07
      0.00000000000000E+00  -3.52766451140390E-11   0.00000000000000E+00   1.23170713830243E-13   2.59116451969747E-22
      3.52765487505084E-08   3.52766719212225E-08  -6.83343888637848E-19  -3.00183674522690E-01  -3.00183674522588E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02033928603959E-10   0.00000000000000E+00  -1.02033928603959E-10
      3.48470420913207E-18  -3.51068865845019E-01  -3.39987181854787E-01   0.00000000000000E+00   9.99574157971013E-13
     -1.06673904590010E-22  -3.51756375667765E-08  -3.51746379926186E-08  -2.80136032049423E-18
      9.68231424687086E-07
      0.00000000000000E+00  -4.01797764098628E-11   0.00000000000000E+00   1.21789140804236E-13   2.32840563301546E-22
      4.01796558831125E-08   4.01797776722536E-08  -6.56342147782217E-19  -3.15494386688278E-01  -3.15494386688173E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05462373279905E-10   0.00000000000000E+00  -1.05462373279905E-10
      3.27377946257226E-18  -2.87606516905930E-01  -2.74980962160595E-01   0.00000000000000E+00   9.66902090646202E-13
     -9.92717755593917E-23  -4.00752822010642E-08  -4.00743152989736E-08  -2.61743731479005E-18
      9.70231424687086E-07
      0.00000000000000E+00  -4.42124032864336E-11   0.00000000000000E+00   1.00278361569090E-13   2.05222521262396E-22
      4.42123306055241E-08   4.42124308838858E-08  -6.29928156866832E-19  -3.30485167150261E-01  -3.30485167150148E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12422733010572E-10   0.00000000000000E+00  -1.12422733010572E-10
      3.04893399655112E-18  -2.17540023734096E-01  -2.03645927116919E-01   0.00000000000000E+00   8.04751265219988E-13
     -9.07293482631754E-23  -4.41008129021404E-08  -4.41000081508753E-08  -2.41900583968429E-18
      9.72231424687086E-07
      0.00000000000000E+00  -4.64098804688609E-11   0.00000000000000E+00   5.48080544184005E-14   1.55124337877649E-22
      4.64098113507207E-08   4.64098661587753E-08  -6.04426806684254E-19  -3.45154001728543E-01  -3.45154001728420E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23581326842694E-10   0.00000000000000E+00  -1.23581326842694E-10
      2.80177134286573E-18  -1.44558686194592E-01  -1.29975607379322E-01   0.00000000000000E+00   5.80071405022222E-13
     -8.30407252229611E-23  -4.62868649033375E-08  -4.62862848319325E-08  -2.19734453618147E-18
      9.74231424687086E-07
      0.00000000000000E+00  -4.42545600208119E-11   0.00000000000000E+00  -5.30972723754616E-14   8.47155470762777E-23
      4.42546165011333E-08   4.42545634038610E-08  -5.79282334409353E-19  -3.59518210466811E-01  -3.59518210466682E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29089877784934E-10   0.00000000000000E+00  -1.29089877784934E-10
      2.54359158729586E-18  -7.71869810933757E-02  -6.32845820763518E-02   0.00000000000000E+00   4.54698857586450E-13
     -6.55542881428331E-23  -4.41259282249336E-08  -4.41254735260760E-08  -1.96430925288651E-18
      9.76231424687086E-07
      0.00000000000000E+00  -3.17363060289004E-11   0.00000000000000E+00  -3.09474618775683E-13   3.32154842228569E-23
      3.17365650832215E-08   3.17362556086028E-08  -5.49989539913559E-19  -3.73642541616929E-01  -3.73642541616825E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04543682116911E-10   0.00000000000000E+00  -1.04543682116911E-10
      2.33450422306204E-18  -3.55034458241508E-02  -2.55373551874249E-02   0.00000000000000E+00   4.98984547814701E-13
     -3.03502294170166E-23  -3.16322109110337E-08  -3.16317119264859E-08  -1.78451468314848E-18
      9.78231424687086E-07
      0.00000000000000E+00  -1.98668432606229E-11   0.00000000000000E+00  -2.92943222393097E-13   1.39518883953585E-23
      1.98671072439874E-08   1.98668143007650E-08  -5.16655441965749E-19  -3.87546571232249E-01  -3.87546571232176E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23674887424068E-11   0.00000000000000E+00  -7.23674887424068E-11
      2.18976924557723E-18  -1.77352707723805E-02  -1.14986933541854E-02   0.00000000000000E+00   3.75391329897945E-13
     -1.38282713297172E-23  -1.97948222033525E-08  -1.97944468120226E-08  -1.67311380361147E-18
      9.80231424687086E-07
      0.00000000000000E+00  -1.42939801410818E-11   0.00000000000000E+00  -1.37207629435391E-13   7.59147019670578E-24
      1.42940799642502E-08   1.42939427566207E-08  -4.82743780470999E-19  -4.01199907404182E-01  -4.01199907404124E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79000784978733E-11   0.00000000000000E+00  -5.79000784978733E-11
      2.07396908858148E-18  -1.11532545751355E-02  -6.66794208810155E-03   0.00000000000000E+00   1.84626093983727E-13
     -8.16979612560578E-24  -1.42362273042169E-08  -1.42360426781229E-08  -1.59122530811048E-18
      9.82231424687086E-07
      0.00000000000000E+00  -1.22458425013540E-11   0.00000000000000E+00  -5.02133580022551E-14   5.31608612625192E-24
      1.22459404625755E-08   1.22458902492175E-08  -4.49344545572442E-19  -4.14587729396608E-01  -4.14587729396555E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.34989021049189E-11   0.00000000000000E+00  -5.34989021049189E-11
      1.96697128437164E-18  -8.67624766069319E-03  -4.83481992843721E-03   0.00000000000000E+00   8.55112294320547E-14
     -5.97448371324573E-24  -1.21924768583420E-08  -1.21923913471126E-08  -1.51762673879920E-18
      9.84231424687086E-07
      0.00000000000000E+00  -1.15508533749046E-11   0.00000000000000E+00  -1.68613131336282E-14   4.26561547073712E-24
      1.15508528667475E-08   1.15508360054344E-08  -4.16706544464901E-19  -4.27708146410657E-01  -4.27708146410604E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.27064442243982E-11   0.00000000000000E+00  -5.27064442243982E-11
      1.86155839592284E-18  -7.59185162274607E-03  -3.96916088756985E-03   0.00000000000000E+00   4.67152168465000E-14
     -4.89081393374138E-24  -1.14981762764268E-08  -1.14981295612100E-08  -1.44485185145794E-18
      9.86231424687086E-07
      0.00000000000000E+00  -1.13068219081442E-11   0.00000000000000E+00  -5.76041408304466E-15   3.64797635316506E-24
      1.13068196311957E-08   1.13068138707817E-08  -3.84929210635072E-19  -4.40564155843461E-01  -4.40564155843408E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.30351159484406E-11   0.00000000000000E+00  -5.30351159484406E-11
      1.75548816402596E-18  -6.99724734605039E-03  -3.45154162643944E-03   0.00000000000000E+00   3.22491056794465E-14
     -4.21249927669856E-24  -1.12538110039389E-08  -1.12537787548332E-08  -1.37055895339089E-18
      9.88231424687086E-07
      0.00000000000000E+00  -1.12068948340624E-11   0.00000000000000E+00  -2.22693730004161E-15   3.22453680314958E-24
      1.12069204044306E-08   1.12069181774933E-08  -3.54079046516786E-19  -4.53160272344530E-01  -4.53160272344477E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.36572694428852E-11   0.00000000000000E+00  -5.36572694428852E-11
      1.64817362514019E-18  -6.60436405588119E-03  -3.09032647610389E-03   0.00000000000000E+00   2.61523389769428E-14
     -3.71908824753452E-24  -1.11532870603894E-08  -1.11532609080504E-08  -1.29409457862341E-18
      9.90231424687086E-07
      0.00000000000000E+00  -1.11557373154378E-11   0.00000000000000E+00  -1.04439918252435E-15   2.91017102329710E-24
      1.11557402796509E-08   1.11557392352517E-08  -3.24199100685607E-19  -4.65501356260515E-01  -4.65501356260461E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43016900127759E-11   0.00000000000000E+00  -5.43016900127759E-11
      1.53957024511464E-18  -6.31589649825792E-03  -2.81818518723028E-03   0.00000000000000E+00   2.28411147520459E-14
     -3.33467091988209E-24  -1.11014603863537E-08  -1.11014375452389E-08  -1.21537114442903E-18
      9.92231424687086E-07
      0.00000000000000E+00  -1.11240508811012E-11   0.00000000000000E+00  -5.80338458487645E-16   2.66647543575582E-24
      1.11240478153038E-08   1.11240472349653E-08  -2.95309947133403E-19  -4.77592137022427E-01  -4.77592137022372E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.48732720280554E-11   0.00000000000000E+00  -5.48732720280554E-11
      1.42982370105853E-18  -6.09281696900036E-03  -2.60526942534798E-03   0.00000000000000E+00   2.05550263408907E-14
     -3.02590101904441E-24  -1.10691945179636E-08  -1.10691739629372E-08  -1.13451375392513E-18
      9.94231424687086E-07
      0.00000000000000E+00  -1.11020999889086E-11   0.00000000000000E+00  -3.54254473224230E-16   2.47218644413908E-24
      1.11021221279810E-08   1.11021217737266E-08  -2.67413692761395E-19  -4.89436760006621E-01  -4.89436760006566E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.53336966519811E-11   0.00000000000000E+00  -5.53336966519811E-11
      1.31915630775457E-18  -5.91539178460807E-03  -2.43489600012183E-03   0.00000000000000E+00   1.87497426488939E-14
     -2.77360962035677E-24  -1.10468068268172E-08  -1.10467880770746E-08  -1.05174261499317E-18
      9.96231424687086E-07
      0.00000000000000E+00  -1.10860271598973E-11   0.00000000000000E+00  -2.22979085582183E-16   2.31396272195436E-24
      1.10860498201328E-08   1.10860495971537E-08  -2.40500921666278E-19  -5.01037628301999E-01  -5.01037628301943E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.56614119989480E-11   0.00000000000000E+00  -5.56614119989480E-11
      1.20783348375667E-18  -5.77160939444224E-03  -2.29627949316102E-03   0.00000000000000E+00   1.72379055217252E-14
     -2.56482424622403E-24  -1.10304054230603E-08  -1.10303881851548E-08  -9.67332562090395E-19
      9.98231424687085E-07
      0.00000000000000E+00  -1.10738118098487E-11   0.00000000000000E+00  -1.40150635379342E-16   2.18288457657358E-24
      1.10738157115846E-08   1.10738155714340E-08  -2.14564865942417E-19  -5.12390914625706E-01  -5.12390914625650E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58223891411891E-11   0.00000000000000E+00  -5.58223891411891E-11
      1.09618870547429E-18  -5.65338021216867E-03  -2.18195447020847E-03   0.00000000000000E+00   1.59326676055762E-14
     -2.39018711534166E-24  -1.10180091149604E-08  -1.10179931822928E-08  -8.81623839531875E-19
      1.00000000000000E-06
      0.00000000000000E+00  -1.10648110256024E-11   0.00000000000000E+00  -9.98630658249213E-17   2.08430674663366E-24
      1.10648010834588E-08   1.10648009835958E-08  -1.92437403757208E-19  -5.22218478682780E-01  -5.22218478682724E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58082076424922E-11   0.00000000000000E+00  -5.58082076424922E-11
      9.97487687179777E-19  -5.56526172357891E-03  -2.09667083229111E-03   0.00000000000000E+00   1.48583644554295E-14
     -2.25877300843498E-24  -1.10090076343177E-08  -1.10089927759533E-08  -8.05050283422569E-19
}
